/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.property.SystemPropertiesHelper;
import org.sonatype.nexus.thread.NexusThreadFactory;

@Named
@Singleton
public class RepositoryAuditThreadPool {
    private final int poolSize = SystemPropertiesHelper.getInteger((String)"nexus.firewall.audit.threadCount", (int)10);
    private final ThreadPoolExecutor executor = new ThreadPoolExecutor(this.poolSize, this.poolSize, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(this.poolSize), (ThreadFactory)new NexusThreadFactory("fwa", "Firewall-Audit", 5, true), new ThreadPoolExecutor.CallerRunsPolicy());

    public RepositoryAuditThreadPool() {
        this.executor.allowCoreThreadTimeOut(true);
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.executor.submit(task);
    }
}

