/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal;

import com.google.common.base.Preconditions;
import com.sonatype.insight.rm.rest.RestClient;
import com.sonatype.insight.rm.rest.RestClientFactory;
import com.sonatype.nexus.clm.ClmConnector;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.node.DeploymentAccess;

@Named
public class RestClientProvider {
    private final DeploymentAccess deploymentAccess;
    private final ClmConnector clmConnector;
    private final RestClientFactory restClientFactory;

    @Inject
    RestClientProvider(RestClientFactory restClientFactory, DeploymentAccess deploymentAccess, ClmConnector clmConnector) {
        this.restClientFactory = (RestClientFactory)Preconditions.checkNotNull((Object)restClientFactory);
        this.deploymentAccess = (DeploymentAccess)Preconditions.checkNotNull((Object)deploymentAccess);
        this.clmConnector = (ClmConnector)((Object)Preconditions.checkNotNull((Object)((Object)clmConnector)));
    }

    public RestClient.Repository getRepositoryClient(String repositoryName) {
        return this.restClientFactory.forConfiguration(this.clmConnector.getRestConfiguration()).forRepository(this.deploymentAccess.getId(), repositoryName);
    }

    public RestClient.FirewallMigration getFirewallMigrationClient() {
        return this.restClientFactory.forConfiguration(this.clmConnector.getRestConfiguration()).forFirewallMigration();
    }

    public RestClient.Base getBaseClient() {
        return this.restClientFactory.forConfiguration(this.clmConnector.getRestConfiguration());
    }
}

