/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal.capability;

import com.google.common.collect.Lists;
import com.sonatype.nexus.clm.FirewallAuditCapabilityConfiguration;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.capability.CapabilityDescriptorSupport;
import org.sonatype.nexus.capability.CapabilityType;
import org.sonatype.nexus.capability.Tag;
import org.sonatype.nexus.capability.Taggable;
import org.sonatype.nexus.formfields.CheckboxFormField;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.formfields.RepositoryCombobox;
import org.sonatype.nexus.repository.proxy.ProxyFacet;

@Named(value="firewall.audit")
@Singleton
public class FirewallAuditCapabilityDescriptor
extends CapabilityDescriptorSupport<FirewallAuditCapabilityConfiguration>
implements Taggable {
    public static final String TYPE_ID = "firewall.audit";
    public static final CapabilityType TYPE = CapabilityType.capabilityType((String)"firewall.audit");
    private static final Set<String> UNIQUE_PROPERTIES = Collections.singleton("repository");
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final List<FormField> formFields = Lists.newArrayList((Object[])new FormField[]{new RepositoryCombobox("repository", messages.repositoryLabel(), messages.repositoryHelp(), true).includingAnyOfFacets(new Class[]{ProxyFacet.class}), new CheckboxFormField("quarantine", messages.quarantineLabel(), messages.quarantineHelp(), false)});

    protected Set<String> uniqueProperties() {
        return UNIQUE_PROPERTIES;
    }

    public CapabilityType type() {
        return TYPE;
    }

    public String name() {
        return messages.name();
    }

    public List<FormField> formFields() {
        return this.formFields;
    }

    protected String renderAbout() throws Exception {
        return this.render("firewall.audit-about.vm");
    }

    public Set<Tag> getTags() {
        return Tag.tags((Tag[])new Tag[]{Tag.categoryTag((String)"IQ")});
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="IQ: Audit and Quarantine")
        public String name();

        @MessageBundle.DefaultMessage(value="Repository")
        public String repositoryLabel();

        @MessageBundle.DefaultMessage(value="Select a repository to be evaluated.")
        public String repositoryHelp();

        @MessageBundle.DefaultMessage(value="Quarantine")
        public String quarantineLabel();

        @MessageBundle.DefaultMessage(value="Enable Quarantine for repository. Note: If enabled and later disabled, all quarantined components will be made available in the repository; those components cannot be re-quarantined.")
        public String quarantineHelp();
    }
}

