/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal.migration;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.sonatype.clm.dto.model.repository.migration.MigrationState;
import com.sonatype.insight.rm.rest.RestClientConfiguration;
import com.sonatype.nexus.clm.ClmConnector;
import com.sonatype.nexus.clm.FirewallAuditCapabilityConfiguration;
import com.sonatype.nexus.clm.internal.AssetAttributeStorage;
import com.sonatype.nexus.clm.internal.FirewallIgnorePatternsUpdater;
import com.sonatype.nexus.clm.internal.IsAssetAuditable;
import com.sonatype.nexus.clm.internal.QuarantineStatus;
import com.sonatype.nexus.clm.internal.RepositoryAttributeStorage;
import com.sonatype.nexus.clm.internal.RestClientProvider;
import com.sonatype.nexus.clm.internal.capability.FirewallAuditCapabilityDescriptor;
import com.sonatype.nexus.clm.internal.migration.FirewallRepositoryAttributes;
import com.sonatype.nexus.clm.migration.FirewallMigrationHelper;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.capability.CapabilityReference;
import org.sonatype.nexus.capability.CapabilityReferenceFilterBuilder;
import org.sonatype.nexus.capability.CapabilityRegistry;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.node.DeploymentAccess;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.attributes.AttributesFacet;
import org.sonatype.nexus.repository.storage.Asset;

@Named
@Singleton
public class FirewallMigrationHelperImpl
extends ComponentSupport
implements FirewallMigrationHelper {
    @VisibleForTesting
    static final String NX2_INSTANCE_ID = "nx2InstanceId";
    @VisibleForTesting
    static final String NX2_REPOSITORY_ID = "nx2RepositoryId";
    @VisibleForTesting
    static final String AUDIT_ENABLED = "audit.enabled";
    @VisibleForTesting
    static final String AUDIT_TIMESTAMP = "audit.timestamp";
    @VisibleForTesting
    static final String QUARANTINE_ENABLED_TIMESTAMP = "quarantine.enabled.timestamp";
    @VisibleForTesting
    static final String QUARANTINE_LASTUPDATE_TIMESTAMP = "quarantine.lastupdate.timestamp";
    @VisibleForTesting
    static final String QUARANTINE_STATUS = "quarantine.status";
    private final DeploymentAccess deploymentAccess;
    private final CapabilityRegistry capabilityRegistry;
    private final RestClientProvider restClientProvider;
    private final ClmConnector clmConnector;
    private final FirewallIgnorePatternsUpdater ignorePatternsUpdater;
    private final RepositoryAttributeStorage repositoryAttributeStorage;
    private final AssetAttributeStorage assetAttributeStorage;
    private final IsAssetAuditable isAssetAuditable;

    @Inject
    public FirewallMigrationHelperImpl(DeploymentAccess deploymentAccess, CapabilityRegistry capabilityRegistry, RestClientProvider restClientProvider, ClmConnector clmConnector, FirewallIgnorePatternsUpdater ignorePatternsUpdater, RepositoryAttributeStorage repositoryAttributeStorage, AssetAttributeStorage assetAttributeStorage, IsAssetAuditable isAssetAuditable) {
        this.deploymentAccess = (DeploymentAccess)Preconditions.checkNotNull((Object)deploymentAccess);
        this.capabilityRegistry = (CapabilityRegistry)Preconditions.checkNotNull((Object)capabilityRegistry);
        this.restClientProvider = (RestClientProvider)Preconditions.checkNotNull((Object)restClientProvider);
        this.clmConnector = (ClmConnector)((Object)Preconditions.checkNotNull((Object)((Object)clmConnector)));
        this.ignorePatternsUpdater = (FirewallIgnorePatternsUpdater)Preconditions.checkNotNull((Object)ignorePatternsUpdater);
        this.repositoryAttributeStorage = (RepositoryAttributeStorage)((Object)Preconditions.checkNotNull((Object)((Object)repositoryAttributeStorage)));
        this.assetAttributeStorage = (AssetAttributeStorage)((Object)Preconditions.checkNotNull((Object)((Object)assetAttributeStorage)));
        this.isAssetAuditable = (IsAssetAuditable)Preconditions.checkNotNull((Object)isAssetAuditable);
    }

    @Override
    public void verifyConnection() throws IOException {
        RestClientConfiguration restConfig = this.clmConnector.getRestConfiguration();
        try {
            this.restClientProvider.getBaseClient().validateConfiguration();
            this.ignorePatternsUpdater.run();
        }
        catch (IOException e) {
            throw new IOException("Cannot contact IQ Server at " + restConfig.getServerUrl() + ": " + e.getMessage(), e);
        }
    }

    @Override
    public void cloneRepositoryHistory(Repository repository) throws IOException {
        NestedAttributesMap firewallAttributes = ((AttributesFacet)repository.facet(AttributesFacet.class)).getAttributes().child("firewall");
        String nexus2ManagerId = (String)firewallAttributes.require(NX2_INSTANCE_ID, String.class);
        String nexus2RepositoryId = (String)firewallAttributes.require(NX2_REPOSITORY_ID, String.class);
        this.restClientProvider.getFirewallMigrationClient().migrateRepositoryHistory(nexus2ManagerId, nexus2RepositoryId, this.deploymentAccess.getId(), repository.getName());
    }

    @Override
    public FirewallMigrationHelper.State getRepositoryCloneState(Repository repository) throws IOException {
        MigrationState state = this.restClientProvider.getFirewallMigrationClient().getRepositoryMigrationState(this.deploymentAccess.getId(), repository.getName()).getState();
        switch (state) {
            case FAILED: {
                return FirewallMigrationHelper.State.FAILED;
            }
            case COMPLETED: {
                return FirewallMigrationHelper.State.COMPLETED;
            }
            case RUNNING: {
                return FirewallMigrationHelper.State.RUNNING;
            }
        }
        throw new IllegalStateException("Unexpected MigrationState: " + state);
    }

    @Override
    public boolean isAuditEnabled(Repository repository) {
        return this.repositoryAttributeStorage.isAuditEnabled(repository.getName());
    }

    @Override
    public boolean shouldAuditBeEnabled(Map<String, Object> attributes) {
        return attributes.containsKey(AUDIT_ENABLED) && (Boolean)attributes.get(AUDIT_ENABLED) != false;
    }

    @Override
    public void ingestRepositoryAttributes(String repositoryName, NestedAttributesMap repositoryAttributes, Map<String, Object> attributes) {
        FirewallRepositoryAttributes firewallRepositoryAttributes = new FirewallRepositoryAttributes(attributes);
        if (firewallRepositoryAttributes.isAuditEnabled()) {
            NestedAttributesMap firewallAttributes = repositoryAttributes.child("firewall");
            firewallAttributes.set(NX2_INSTANCE_ID, (Object)firewallRepositoryAttributes.getRepositoryManagerId());
            firewallAttributes.set(NX2_REPOSITORY_ID, (Object)firewallRepositoryAttributes.getRepositoryId());
            firewallAttributes.set("auditEnabled", (Object)Boolean.toString(firewallRepositoryAttributes.isAuditEnabled()));
            firewallAttributes.set("auditTimestamp", (Object)firewallRepositoryAttributes.getAuditTimestamp());
            firewallAttributes.set("quarantineEnabledTimestamp", (Object)firewallRepositoryAttributes.getQuarantineEnabledTimestamp());
            firewallAttributes.set("quarantineLastUpdateTimestamp", (Object)firewallRepositoryAttributes.getQuarantineLastUpdateTimestamp());
        }
    }

    @Override
    public void ingestAssetAttributes(Asset asset, Map<String, Object> attributes) {
        if (this.isAssetAuditable.test(asset)) {
            String statusName;
            String timestamp = (String)attributes.get(AUDIT_TIMESTAMP);
            if (timestamp != null) {
                try {
                    this.assetAttributeStorage.setAuditTimestamp(asset, Long.parseLong(timestamp));
                }
                catch (IllegalArgumentException e) {
                    this.log.debug("Unknown audit timestamp {} for asset {}", new Object[]{timestamp, asset.name(), e});
                }
            }
            if ((statusName = (String)attributes.get(QUARANTINE_STATUS)) != null) {
                try {
                    this.assetAttributeStorage.setQuarantineStatus(asset, QuarantineStatus.valueOf(statusName), null);
                }
                catch (IllegalArgumentException e) {
                    this.log.debug("Unknown quarantine status {} for asset {}", new Object[]{statusName, asset.name(), e});
                }
            }
        }
    }

    @Override
    public void createFirewallCapability(Repository repository, Map<String, Object> attributes) {
        FirewallRepositoryAttributes firewallRepositoryAttributes = new FirewallRepositoryAttributes(attributes);
        if (firewallRepositoryAttributes.isAuditEnabled()) {
            FirewallAuditCapabilityConfiguration configuration = new FirewallAuditCapabilityConfiguration().withRepositoryName(repository.getName()).withQuarantineEnabled(firewallRepositoryAttributes.getQuarantineEnabledTimestamp() != null);
            this.capabilityRegistry.add(FirewallAuditCapabilityDescriptor.TYPE, false, "Migrated from " + firewallRepositoryAttributes.getRepositoryManagerId() + ":" + firewallRepositoryAttributes.getRepositoryId(), configuration.asMap());
        }
    }

    @Override
    public void activateFirewallCapability(Repository repository) {
        if (this.isAuditEnabled(repository)) {
            Collection references = this.capabilityRegistry.get((Predicate)CapabilityReferenceFilterBuilder.capabilities().withType(FirewallAuditCapabilityDescriptor.TYPE).withProperty("repository", repository.getName()));
            if (!references.isEmpty()) {
                this.log.info("Activating IQ: Audit and Quarantine for repository {}.", (Object)repository.getName());
                CapabilityReference capabilityReference = (CapabilityReference)references.iterator().next();
                this.capabilityRegistry.enable(capabilityReference.context().id());
            } else {
                throw new IllegalStateException("No " + FirewallAuditCapabilityDescriptor.TYPE + " capability found for repository " + repository.getName());
            }
        }
    }

    @Override
    public String getFirewallAuditTimestampAssetAttribute() {
        return String.join((CharSequence)".", "firewall", AUDIT_TIMESTAMP);
    }
}

