/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal.migration;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nullable;

public class FirewallRepositoryAttributes {
    private boolean auditEnabled;
    private String auditTimestamp;
    private String quarantineEnabledTimestamp;
    private String quarantineLastUpdateTimestamp;
    private String repositoryManagerId;
    private String repositoryId;

    public FirewallRepositoryAttributes(Map<String, Object> attributes) {
        if (attributes.containsKey("audit.enabled")) {
            this.auditEnabled = (Boolean)attributes.get("audit.enabled");
            this.auditTimestamp = FirewallRepositoryAttributes.toNullableString(attributes.get("audit.timestamp"));
            this.quarantineEnabledTimestamp = FirewallRepositoryAttributes.toNullableString(attributes.get("quarantine.enabled.timestamp"));
            this.quarantineLastUpdateTimestamp = FirewallRepositoryAttributes.toNullableString(attributes.get("quarantine.lastupdate.timestamp"));
            this.repositoryManagerId = (String)Preconditions.checkNotNull((Object)((String)attributes.get("nx2InstanceId")), (Object)"Missing repository manager id!");
            this.repositoryId = (String)Preconditions.checkNotNull((Object)((String)attributes.get("nx2RepositoryId")), (Object)"Missing repository id!");
        }
    }

    @Nullable
    private static String toNullableString(Object obj) {
        return obj != null ? obj.toString() : null;
    }

    public boolean isAuditEnabled() {
        return this.auditEnabled;
    }

    @Nullable
    public String getAuditTimestamp() {
        return this.auditTimestamp;
    }

    @Nullable
    public String getQuarantineEnabledTimestamp() {
        return this.quarantineEnabledTimestamp;
    }

    @Nullable
    public String getQuarantineLastUpdateTimestamp() {
        return this.quarantineLastUpdateTimestamp;
    }

    @Nullable
    public String getRepositoryManagerId() {
        return this.repositoryManagerId;
    }

    @Nullable
    public String getRepositoryId() {
        return this.repositoryId;
    }
}

