/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.validator;

import com.sonatype.nexus.clm.ClmAuthenticationType;
import com.sonatype.nexus.clm.ClmConfiguration;
import com.sonatype.nexus.clm.internal.ui.ClmXO;
import com.sonatype.nexus.clm.validator.ClmAuthentication;
import javax.inject.Named;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang.StringUtils;
import org.sonatype.nexus.validation.ConstraintValidatorSupport;

@Named
public class ClmAuthenticationValidator
extends ConstraintValidatorSupport<ClmAuthentication, Object> {
    static final String USER_OR_PKI_ERROR_MESSAGE = "To proceed with PKI Authentication, clear the username and password fields. Otherwise, please select User Authentication.";
    static final String USERNAME_REQUIRED = "User Authentication method requires the username to be set.";
    static final String PASSWORD_REQUIRED = "User Authentication method requires the password to be set.";

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        if (value instanceof ClmConfiguration) {
            ClmConfiguration config = (ClmConfiguration)((Object)value);
            return this.validate(config.getAuthenticationType(), config.getUsername(), config.getPassword(), context);
        }
        if (value instanceof ClmXO) {
            ClmXO clmXO = (ClmXO)value;
            return this.validate(ClmAuthenticationType.valueOf(clmXO.getAuthenticationType(), ClmAuthenticationType.USER), clmXO.getUsername(), clmXO.getPassword(), context);
        }
        context.buildConstraintViolationWithTemplate("unsupported annotated object " + value).addConstraintViolation();
        return false;
    }

    private boolean validate(ClmAuthenticationType authenticationType, String username, String password, ConstraintValidatorContext context) {
        switch (authenticationType) {
            case PKI: {
                if (StringUtils.isNotBlank((String)username) || StringUtils.isNotBlank((String)password)) {
                    context.buildConstraintViolationWithTemplate(USER_OR_PKI_ERROR_MESSAGE).addPropertyNode("authenticationType").addConstraintViolation();
                    return false;
                }
                return true;
            }
            case USER: {
                if (StringUtils.isBlank((String)username)) {
                    context.buildConstraintViolationWithTemplate(USERNAME_REQUIRED).addPropertyNode("username").addConstraintViolation();
                }
                if (StringUtils.isBlank((String)password)) {
                    context.buildConstraintViolationWithTemplate(PASSWORD_REQUIRED).addPropertyNode("password").addConstraintViolation();
                }
                return StringUtils.isNotBlank((String)username) && StringUtils.isNotBlank((String)password);
            }
        }
        context.buildConstraintViolationWithTemplate("unsupported authentication type " + (Object)((Object)authenticationType)).addConstraintViolation();
        return false;
    }
}

