/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonatype.nexus.capability.CapabilityConfigurationSupport;

public class HealthCheckConfiguration
extends CapabilityConfigurationSupport {
    public static final String CONFIGURED_FOR_ALL = "configuredForAll";
    public static final String USE_TRUST_STORE = "useTrustStore";
    private boolean configuredForAll;
    @Nullable
    private Boolean useTrustStore;

    public HealthCheckConfiguration() {
    }

    public HealthCheckConfiguration(boolean configuredForAll) {
        this.configuredForAll = configuredForAll;
    }

    public HealthCheckConfiguration(Map<String, String> properties) {
        Preconditions.checkNotNull(properties);
        this.configuredForAll = this.parseBoolean(properties.get(CONFIGURED_FOR_ALL), false);
        this.useTrustStore = this.parseBoolean(properties.get(USE_TRUST_STORE), null);
    }

    public boolean isConfiguredForAll() {
        return this.configuredForAll;
    }

    @Nullable
    public Boolean getUseTrustStore() {
        return this.useTrustStore;
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "{" + "configuredForAll=" + this.configuredForAll + ", useTrustStore=" + this.useTrustStore + '}';
    }

    public Map<String, String> toProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(CONFIGURED_FOR_ALL, Boolean.toString(this.isConfiguredForAll()));
        if (this.useTrustStore != null) {
            properties.put(USE_TRUST_STORE, String.valueOf(this.useTrustStore));
        }
        return properties;
    }
}

