/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.internal.capability;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.plugins.healthcheck.HealthCheckConfiguration;
import com.sonatype.nexus.plugins.healthcheck.service.EulaService;
import com.sonatype.nexus.plugins.healthcheck.service.HealthCheckTaskManager;
import com.sonatype.nexus.plugins.healthcheck.service.impl.ConfigServiceImpl;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.capability.CapabilitySupport;

@Named(value="healthcheck")
public class HealthCheckCapability
extends CapabilitySupport<HealthCheckConfiguration> {
    private final HealthCheckTaskManager healthCheckTaskManager;
    private final EulaService eulaService;
    private final ConfigServiceImpl configService;

    @Inject
    public HealthCheckCapability(HealthCheckTaskManager healthCheckTaskManager, EulaService eulaService, ConfigServiceImpl configService) {
        this.healthCheckTaskManager = (HealthCheckTaskManager)Preconditions.checkNotNull((Object)healthCheckTaskManager);
        this.eulaService = (EulaService)Preconditions.checkNotNull((Object)eulaService);
        this.configService = (ConfigServiceImpl)Preconditions.checkNotNull((Object)configService);
    }

    protected HealthCheckConfiguration createConfig(Map<String, String> properties) {
        return new HealthCheckConfiguration(properties);
    }

    protected void onUpdate(HealthCheckConfiguration config) throws Exception {
        this.healthCheckTaskManager.configure(config.isConfiguredForAll(), false);
        this.configService.setUseTrustStore(config.getUseTrustStore());
    }

    protected void onActivate(HealthCheckConfiguration config) throws Exception {
        this.healthCheckTaskManager.configure(config.isConfiguredForAll(), false);
    }

    protected void onPassivate(HealthCheckConfiguration config) throws Exception {
        this.healthCheckTaskManager.configure(false, false);
    }

    public void onCreate(HealthCheckConfiguration config) throws Exception {
        this.healthCheckTaskManager.configure(config.isConfiguredForAll(), config.isConfiguredForAll());
        if (!this.eulaService.isEulaAccepted()) {
            this.eulaService.acceptEula();
        }
        this.configService.setUseTrustStore(config.getUseTrustStore());
    }

    protected void onRemove(HealthCheckConfiguration config) throws Exception {
        this.healthCheckTaskManager.configure(false, false);
        this.configService.setUseTrustStore(false);
    }

    protected String renderStatus() throws Exception {
        return this.decideStatus();
    }

    protected String renderDescription() throws Exception {
        return this.decideStatus();
    }

    private String decideStatus() {
        return "Configured for all supported repositories: " + ((HealthCheckConfiguration)((Object)this.getConfig())).isConfiguredForAll();
    }
}

