/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.internal.capability;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.sonatype.nexus.plugins.healthcheck.HealthCheckConfiguration;
import com.sonatype.nexus.plugins.healthcheck.service.EulaService;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.capability.CapabilityDescriptorSupport;
import org.sonatype.nexus.capability.CapabilityType;
import org.sonatype.nexus.capability.Tag;
import org.sonatype.nexus.capability.Taggable;
import org.sonatype.nexus.common.template.TemplateParameters;
import org.sonatype.nexus.formfields.CheckboxFormField;
import org.sonatype.nexus.formfields.FormField;

@Named(value="healthcheck")
@Singleton
public class HealthCheckCapabilityDescriptor
extends CapabilityDescriptorSupport<HealthCheckConfiguration>
implements Taggable {
    public static final String TYPE_ID = "healthcheck";
    public static final CapabilityType TYPE = CapabilityType.capabilityType((String)"healthcheck");
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final EulaService eulaService;
    private List<FormField> formFields;

    @Inject
    public HealthCheckCapabilityDescriptor(EulaService eulaService) {
        this.eulaService = (EulaService)Preconditions.checkNotNull((Object)eulaService);
        this.formFields = Lists.newArrayList((Object[])new FormField[]{new CheckboxFormField("configuredForAll", messages.configureForAllLabel(), messages.configureForAllHelp(), false).withInitialValue(Boolean.valueOf(true)), new CheckboxFormField("useTrustStore", messages.useTrustStoreLabel(), null, false)});
    }

    public CapabilityType type() {
        return TYPE;
    }

    public String name() {
        return messages.name();
    }

    public List<FormField> formFields() {
        return this.formFields;
    }

    protected HealthCheckConfiguration createConfig(Map<String, String> properties) {
        return new HealthCheckConfiguration(properties);
    }

    public Set<Tag> getTags() {
        return Tag.tags((Tag[])new Tag[]{Tag.categoryTag((String)"Health Check")});
    }

    protected String renderAbout() throws Exception {
        TemplateParameters params = new TemplateParameters();
        params.set("eulaAccepted", (Object)(this.eulaService.isEulaAccepted() ? "You have previously accepted these terms." : "Please read the TOS as you have not yet accepted these terms."));
        return this.render("healthcheck-about.vm", params);
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Health Check: Configuration")
        public String name();

        @MessageBundle.DefaultMessage(value="Configure for all proxy repositories")
        public String configureForAllLabel();

        @MessageBundle.DefaultMessage(value="Configure all supported proxy repositories to regularly check with RHC for updates by default. Newly added repositories will automatically be configured as well, for as long as this is selected.")
        public String configureForAllHelp();

        @MessageBundle.DefaultMessage(value="Use the Nexus truststore")
        public String useTrustStoreLabel();
    }
}

