/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import com.sonatype.clm.dto.model.component.ComponentIdentifier;
import com.sonatype.clm.dto.model.rhc.RepoHealthCheckComponentDetails;
import com.sonatype.nexus.plugins.healthcheck.rest.dto.insight.ArtifactInfo;
import com.sonatype.nexus.plugins.healthcheck.rest.dto.insight.MostPopularVersion;
import com.sonatype.nexus.plugins.healthcheck.service.ConfigService;
import com.sonatype.nexus.plugins.healthcheck.service.HdsService;
import com.sonatype.nexus.plugins.healthcheck.service.HttpResult;
import com.sonatype.nexus.plugins.healthcheck.service.NexusIDService;
import com.sonatype.nexus.plugins.healthcheck.service.UrlService;
import com.sonatype.nexus.plugins.healthcheck.service.impl.HttpResultImpl;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.httpclient.HttpClientManager;
import org.sonatype.nexus.httpclient.config.HttpClientConfigurationChangedEvent;

@Named
@Singleton
public class HdsServiceImpl
extends ComponentSupport
implements HdsService,
EventAware {
    private final ConfigService configService;
    private final UrlService urlService;
    private final NexusIDService idService;
    private final HttpClientManager httpClientManager;
    private final ObjectMapper mapper = new ObjectMapper();
    private HttpClient httpClient;

    @Inject
    public HdsServiceImpl(ConfigService configService, UrlService urlService, NexusIDService idService, HttpClientManager httpClientManager) {
        this.configService = (ConfigService)Preconditions.checkNotNull((Object)configService);
        this.urlService = (UrlService)Preconditions.checkNotNull((Object)urlService);
        this.idService = (NexusIDService)Preconditions.checkNotNull((Object)idService);
        this.httpClientManager = (HttpClientManager)Preconditions.checkNotNull((Object)httpClientManager);
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Override
    public HttpResult uploadScan(String repositoryName, File scanFile) throws IOException {
        return this.doPut(this.urlService.getScanUrl(this.idService.getNexusID(), repositoryName), scanFile);
    }

    @Override
    public HttpResult getNextRunDeltas(String repositoryName) throws IOException {
        return this.doGet(this.urlService.getScanUrl(this.idService.getNexusID(), repositoryName));
    }

    @Override
    public HttpResult getHealthCheckBundle(String repositoryName) throws IOException {
        return this.doGet(this.urlService.getReportUrl(this.idService.getNexusID(), repositoryName));
    }

    @Override
    public void disableScan(String repositoryName) throws IOException {
        this.doDelete(this.urlService.getScanUrl(this.idService.getNexusID(), repositoryName)).close();
    }

    @Override
    public HttpResult getComponentDetails(String hash, ComponentIdentifier componentIdentifier) throws IOException {
        return this.doGet(this.urlService.getComponentDetailsUrl(this.idService.getNexusID(), hash, componentIdentifier));
    }

    @Override
    public RepoHealthCheckComponentDetails convertComponentDetails(HttpResult result) throws IOException {
        return (RepoHealthCheckComponentDetails)this.mapper.readValue(result.getInputStream(), RepoHealthCheckComponentDetails.class);
    }

    @Override
    public HttpResult getMostPopularVersions(List<ComponentIdentifier> identifiers) throws IOException {
        return this.doPost(this.urlService.getMostPopularVersionsUrl(this.idService.getNexusID()), this.mapper.writeValueAsString(identifiers), ContentType.APPLICATION_JSON);
    }

    @Override
    public List<MostPopularVersion> convertMostPopularVersions(HttpResult result) throws IOException {
        if (result.isSuccess()) {
            return (List)this.mapper.readValue(result.getInputStream(), (TypeReference)new TypeReference<List<MostPopularVersion>>(){});
        }
        return Collections.emptyList();
    }

    @Override
    public HttpResult getByComponentIdentifiers(List<ComponentIdentifier> identifiers, boolean alerts) throws IOException {
        return this.doPost(this.urlService.getByComponentIdentifiersUrl(this.idService.getNexusID(), alerts), this.mapper.writeValueAsString(identifiers), ContentType.APPLICATION_JSON);
    }

    @Override
    public List<ArtifactInfo> convertArtifactInfos(HttpResult result) throws IOException {
        List artifactInfos;
        if (result.isSuccess() && (artifactInfos = (List)this.mapper.readValue(result.getInputStream(), (TypeReference)new TypeReference<List<ArtifactInfo>>(){})) != null) {
            long now = System.currentTimeMillis();
            for (ArtifactInfo artifactInfo : artifactInfos) {
                if (artifactInfo.getCreateTime() != null) {
                    artifactInfo.setAge(Math.max(0L, now - artifactInfo.getCreateTime()));
                }
                artifactInfo.setLicenseThreatLevel(this.mapLicenseThreat(artifactInfo.getLicenseCategoryId()));
            }
            return artifactInfos;
        }
        return Collections.emptyList();
    }

    private Integer mapLicenseThreat(String licenseThreat) {
        if (licenseThreat == null) {
            return null;
        }
        if ("COPYLEFT".equalsIgnoreCase(licenseThreat)) {
            return 4;
        }
        if ("WEAKCOPYLEFT".equalsIgnoreCase(licenseThreat)) {
            return 2;
        }
        if ("LIBERAL".equalsIgnoreCase(licenseThreat)) {
            return 1;
        }
        return 3;
    }

    private HttpResult doGet(String url) throws IOException {
        this.log.debug("Calling into server ({}) with GET", (Object)url);
        HttpGet method = new HttpGet(url);
        HttpResponse response = this.execute((HttpUriRequest)method);
        this.log.debug("Server responded with status {}", (Object)response.getStatusLine());
        return new HttpResultImpl(response);
    }

    private HttpResult doPut(String url, File body) throws IOException {
        this.log.debug("Calling into server ({}) with PUT", (Object)url);
        HttpPut method = new HttpPut(url);
        method.setEntity((HttpEntity)new FileEntity(body, null));
        HttpResponse response = this.execute((HttpUriRequest)method);
        this.log.debug("Server responded with status {}", (Object)response.getStatusLine());
        return new HttpResultImpl(response);
    }

    private HttpResult doPost(String url, String body, ContentType contentType) throws IOException {
        this.log.debug("Calling into server ({}) with POST", (Object)url);
        HttpPost method = new HttpPost(url);
        method.setEntity((HttpEntity)new StringEntity(body, contentType));
        HttpResponse response = this.execute((HttpUriRequest)method);
        this.log.debug("Server responded with status {}", (Object)response.getStatusLine());
        return new HttpResultImpl(response);
    }

    private HttpResult doDelete(String url) throws IOException {
        this.log.debug("Calling into server ({}) with DELETE", (Object)url);
        HttpDelete method = new HttpDelete(url);
        HttpResponse response = this.execute((HttpUriRequest)method);
        this.log.debug("Server responded with status {}", (Object)response.getStatusLine());
        return new HttpResultImpl(response);
    }

    protected HttpResponse execute(HttpUriRequest method) throws IOException {
        BasicHttpContext httpContext = new BasicHttpContext();
        if (this.configService.getUseTrustStore()) {
            httpContext.setAttribute("nexus.httpclient.ssl.trustStore", (Object)Boolean.TRUE);
        }
        return this.getHttpClient().execute(method, (HttpContext)httpContext);
    }

    protected synchronized HttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = this.httpClientManager.create();
        }
        return this.httpClient;
    }

    @Override
    public synchronized void resetHttpClient() {
        if (this.httpClient != null) {
            this.log.debug("Requesting reset of HTTP client");
            this.httpClient = null;
        }
    }

    @Subscribe
    public void on(HttpClientConfigurationChangedEvent event) {
        this.resetHttpClient();
    }
}

