/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.service.impl;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.plugins.healthcheck.service.HttpResult;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.entity.ContentType;

public class HttpResultImpl
implements HttpResult {
    private final int statusCode;
    private final String statusText;
    private final InputStream is;
    private final ContentType contentType;

    public HttpResultImpl(HttpResponse response) throws IOException {
        Preconditions.checkNotNull((Object)response);
        StatusLine status = response.getStatusLine();
        this.statusCode = status.getStatusCode();
        this.statusText = status.getReasonPhrase();
        HttpEntity entity = response.getEntity();
        this.contentType = ContentType.getOrDefault((HttpEntity)entity);
        InputStream is = entity != null ? entity.getContent() : null;
        this.is = is != null ? is : new ByteArrayInputStream(new byte[0]);
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String getStatusText() {
        return this.statusText;
    }

    @Override
    public InputStream getInputStream() {
        return this.is;
    }

    @Override
    public boolean isSuccess() {
        return this.statusCode >= 200 && this.statusCode < 300;
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((InputStream)this.is);
    }

    @Override
    public Charset getContentCharset() {
        return this.contentType.getCharset();
    }
}

