/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.service.impl;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.plugins.healthcheck.service.SecurityService;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.shiro.subject.Subject;
import org.sonatype.nexus.security.SecurityHelper;
import org.sonatype.nexus.security.anonymous.AnonymousHelper;

@Named
@Singleton
public class SecurityServiceImpl
implements SecurityService {
    private final SecurityHelper securityHelper;

    @Inject
    public SecurityServiceImpl(SecurityHelper securityHelper) {
        this.securityHelper = (SecurityHelper)Preconditions.checkNotNull((Object)securityHelper);
    }

    @Override
    public boolean isAnonymousUser(HttpServletRequest request) {
        Subject subject = this.securityHelper.subject();
        return AnonymousHelper.isAnonymous((Subject)subject);
    }

    @Override
    public void blockAnonymousUser(HttpServletRequest request) {
        if (this.isAnonymousUser(request)) {
            throw new WebApplicationException("Anonymous users may never access sensitive information", Response.Status.FORBIDDEN);
        }
    }
}

