/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.task;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import com.sonatype.insight.scan.anon.Anonymizer;
import com.sonatype.insight.scan.client.ClientScanRequest;
import com.sonatype.insight.scan.client.ClientScanner;
import com.sonatype.insight.scan.model.ArtifactId;
import com.sonatype.insight.scan.model.DirectoryScanItem;
import com.sonatype.insight.scan.model.Repository;
import com.sonatype.insight.scan.model.ReverseLookupTable;
import com.sonatype.insight.scan.model.Scan;
import com.sonatype.insight.scan.model.ScanConfiguration;
import com.sonatype.insight.scan.model.ScanItem;
import com.sonatype.insight.scan.model.io.ScanWriter;
import com.sonatype.nexus.plugins.healthcheck.service.NexusIDService;
import com.sonatype.nexus.plugins.healthcheck.task.HealthCheckItem;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.joda.time.DateTime;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.assetdownloadcount.AssetDownloadCountStore;
import org.sonatype.nexus.repository.maven.MavenFacet;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.proxy.ProxyFacet;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.types.ProxyType;

@Named
public class HealthCheckProcessor
extends ComponentSupport {
    private static final boolean ANONYMIZE_HEALTH_CHECK_ITEM_IDS = false;
    private final ProxyType proxyType;
    private final Format maven2Format;
    private final Anonymizer scanAnonymizer;
    private final ClientScanner clientScanner;
    private final NexusIDService idService;
    private final AssetDownloadCountStore assetDownloadCountStore;
    private Scan scan;
    private ReverseLookupTable revLookupTable;
    private long start;
    private int items;
    private int artifacts;
    private int snapshots;
    private ScanWriter scanWriter;
    private HealthCheckItemExtractor extractor = new HealthCheckItemExtractor();

    @Inject
    HealthCheckProcessor(Anonymizer anonymizer, ClientScanner clientScanner, NexusIDService idService, ProxyType proxyType, @Named(value="maven2") Format maven2Format, AssetDownloadCountStore assetDownloadCountStore) {
        this.scanAnonymizer = (Anonymizer)Preconditions.checkNotNull((Object)anonymizer);
        this.clientScanner = (ClientScanner)Preconditions.checkNotNull((Object)clientScanner);
        this.idService = (NexusIDService)Preconditions.checkNotNull((Object)idService);
        this.proxyType = (ProxyType)Preconditions.checkNotNull((Object)proxyType);
        this.maven2Format = (Format)Preconditions.checkNotNull((Object)maven2Format);
        this.assetDownloadCountStore = (AssetDownloadCountStore)Preconditions.checkNotNull((Object)assetDownloadCountStore);
    }

    public boolean isStarted() {
        return this.start != 0L;
    }

    public void afterWalk(org.sonatype.nexus.repository.Repository repository) throws Exception {
        this.scan.getSummary().setEndTime();
        this.scan.getSummary().setFiles(this.items);
        this.scan.getSummary().setArchives(this.artifacts);
        this.scan.getSummary().setSnapshots(this.snapshots);
        this.scanWriter.writeSummary(this.scan.getSummary());
        this.scanWriter.writeConfiguration(this.scan.getConfiguration());
        this.scanWriter.closeScan();
        this.log.debug("Scan completed for repository {}: {} files, {} artifacts, {} ms", new Object[]{repository.getName(), this.items, this.artifacts, System.currentTimeMillis() - this.start});
        this.scan = null;
        this.revLookupTable = null;
    }

    public void beforeWalk(org.sonatype.nexus.repository.Repository repo, Integer scanRate, ScanWriter scanWriter) throws Exception {
        this.start = System.currentTimeMillis();
        this.scanWriter = scanWriter;
        this.scan = new Scan();
        this.revLookupTable = new ReverseLookupTable();
        scanWriter.openScan(this.scan);
        String proxyUrl = null;
        if (this.proxyType.equals((Object)repo.getType())) {
            proxyUrl = ((ProxyFacet)repo.facet(ProxyFacet.class)).getRemoteUrl().toASCIIString();
        }
        Repository repository = new Repository(this.idService.getNexusID(), repo.getName(), repo.getName(), repo.getFormat().getValue(), proxyUrl);
        scanWriter.writeRepository(repository);
        ScanConfiguration scanConfig = this.scan.getConfiguration();
        scanConfig.setProperty((Object)"procArch", (Object)"true");
        scanConfig.setProperty((Object)"operatingSystem", (Object)"true");
        scanConfig.setProperty((Object)"jreInfo", (Object)"true");
        scanConfig.setProperty((Object)"ipAddresses", (Object)"false");
        scanConfig.setProperty((Object)"hashFiles", (Object)"true");
        scanConfig.setProperty((Object)"fileSizes", (Object)"false");
        scanConfig.setProperty((Object)"lastAccess", (Object)"true");
        scanConfig.setProperty((Object)"anonymizeArtifactIds", (Object)String.valueOf(false));
        scanConfig.setProperty((Object)"scanRate", (Object)String.valueOf(scanRate));
        this.scan.getSummary().setStartTime();
        this.clientScanner.scan(new ClientScanRequest(this.scan));
        this.log.debug("Scanning repository {} with rate of {} files per second", (Object)repo.getName(), (Object)scanRate);
    }

    protected void processAsset(org.sonatype.nexus.repository.Repository repository, Asset asset) throws Exception {
        if (this.log.isDebugEnabled() && this.items % 1000 == 0 && this.items > 0) {
            this.log.debug("Scan progress for repository {}: {} files, {} artifacts, {} ms", new Object[]{repository.getName(), this.items, this.artifacts, System.currentTimeMillis() - this.start});
        }
        ++this.items;
        HealthCheckItem healthCheckItem = this.extractor.extract(asset, repository, this.maven2Format.equals((Object)repository.getFormat()));
        if (healthCheckItem == null) {
            return;
        }
        String id = healthCheckItem.getId();
        DirectoryScanItem item = new DirectoryScanItem();
        item.setSha1(healthCheckItem.getSha1());
        item.setLastAccess(healthCheckItem.getLastAccess());
        item.setId(id);
        item.setPath(healthCheckItem.getPath());
        if (this.assetDownloadCountStore.isEnabled()) {
            item.setDailyDownloadCounts(this.getDailyDownloadCounts(repository, asset));
            item.setMonthlyDownloadCounts(this.getMonthlyDownloadCounts(repository, asset));
        } else {
            item.setDailyDownloadCounts("");
            item.setMonthlyDownloadCounts("");
        }
        this.scanWriter.writeScanItem((ScanItem)item);
        ++this.artifacts;
        if (healthCheckItem.isSnapshot()) {
            ++this.snapshots;
        }
    }

    private String getDailyDownloadCounts(org.sonatype.nexus.repository.Repository repository, Asset asset) {
        long[] counts = this.assetDownloadCountStore.getDailyCounts(repository.getName(), asset.name());
        return Arrays.stream(counts).mapToObj(Long::toString).collect(Collectors.joining(","));
    }

    private String getMonthlyDownloadCounts(org.sonatype.nexus.repository.Repository repository, Asset asset) {
        long[] counts = this.assetDownloadCountStore.getMonthlyCounts(repository.getName(), asset.name());
        return Arrays.stream(counts).mapToObj(Long::toString).collect(Collectors.joining(","));
    }

    public void setHealthCheckItemExtractor(HealthCheckItemExtractor extractor) {
        this.extractor = extractor;
    }

    static class HealthCheckItemExtractor {
        HealthCheckItemExtractor() {
        }

        public HealthCheckItem extract(Asset asset, org.sonatype.nexus.repository.Repository repo, boolean mavenRepository) {
            HealthCheckItemImpl healthCheckItem = new HealthCheckItemImpl(asset, repo, mavenRepository);
            if (healthCheckItem.getPath() == null || healthCheckItem.getSha1() == null) {
                return null;
            }
            if (mavenRepository && healthCheckItem.getId() == null) {
                return null;
            }
            return healthCheckItem;
        }

        private static class HealthCheckItemImpl
        implements HealthCheckItem {
            private final Asset asset;
            private final org.sonatype.nexus.repository.Repository repo;
            private final MavenPath mavenPath;
            private final String path;
            private final String id;
            private final boolean snapshot;

            public HealthCheckItemImpl(Asset asset, org.sonatype.nexus.repository.Repository repo, boolean mavenRepository) {
                this.asset = asset;
                this.repo = repo;
                this.mavenPath = mavenRepository ? this.createMavenPath() : null;
                this.id = this.createGavId(this.mavenPath);
                this.path = asset.name();
                this.snapshot = this.checkSnapshot();
            }

            @Override
            public String getId() {
                return this.id;
            }

            @Override
            public String getSha1() {
                HashCode checksum = this.asset.getChecksum(HashAlgorithm.SHA1);
                return checksum == null ? null : checksum.toString();
            }

            @Override
            public long getLastAccess() {
                DateTime lastDownloaded = this.asset.lastDownloaded();
                if (lastDownloaded != null) {
                    return lastDownloaded.getMillis();
                }
                return 0L;
            }

            @Override
            public boolean isSnapshot() {
                return this.snapshot;
            }

            private MavenPath createMavenPath() {
                return ((MavenFacet)this.repo.facet(MavenFacet.class)).getMavenPathParser().parsePath(this.asset.name());
            }

            private String createGavId(MavenPath mavenPath) {
                if (mavenPath == null || mavenPath.getCoordinates() == null || mavenPath.isHash() || mavenPath.isSignature() || "pom".equals(mavenPath.getCoordinates().getExtension())) {
                    return null;
                }
                MavenPath.Coordinates gav = mavenPath.getCoordinates();
                String clearTextId = ArtifactId.maven((String)gav.getGroupId(), (String)gav.getArtifactId(), (String)gav.getExtension(), (String)gav.getClassifier(), (String)gav.getVersion()).getId();
                return clearTextId;
            }

            private boolean checkSnapshot() {
                if (this.mavenPath != null && this.mavenPath.getCoordinates() != null) {
                    return this.mavenPath.getCoordinates().isSnapshot();
                }
                return false;
            }

            @Override
            public String getPath() {
                return this.path;
            }
        }
    }
}

