/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.task;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.sonatype.insight.scan.model.io.ScanWriter;
import com.sonatype.insight.scan.model.io.ScanWriterFactory;
import com.sonatype.nexus.plugins.healthcheck.service.ConfigService;
import com.sonatype.nexus.plugins.healthcheck.service.HdsService;
import com.sonatype.nexus.plugins.healthcheck.service.HealthCheckTaskManager;
import com.sonatype.nexus.plugins.healthcheck.service.HttpResult;
import com.sonatype.nexus.plugins.healthcheck.service.WebServerManager;
import com.sonatype.nexus.plugins.healthcheck.service.WebServerService;
import com.sonatype.nexus.plugins.healthcheck.task.HealthCheckProcessor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.commons.io.FileUtils;
import org.joda.time.DateTime;
import org.sonatype.nexus.logging.task.TaskLogType;
import org.sonatype.nexus.logging.task.TaskLogging;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.assetdownloadcount.AssetDownloadCountStore;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.scheduling.Cancelable;
import org.sonatype.nexus.scheduling.CancelableHelper;
import org.sonatype.nexus.scheduling.TaskInterruptedException;
import org.sonatype.nexus.scheduling.TaskSupport;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@TaskLogging(value=TaskLogType.NEXUS_LOG_ONLY)
public class HealthCheckTask
extends TaskSupport
implements Cancelable {
    public static final String REPOSITORY_NAME_KEY = "repositoryName";
    public static final String FORCE_DELTA_CHECK_KEY = "forceDeltaCheck";
    public static final String STATE_KEY = "state";
    public static final String NEXT_UPLOAD_TIME_KEY = "nextUploadTime";
    public static final String NEXT_DOWNLOAD_TIME_KEY = "nextDownloadTime";
    private final AtomicBoolean running;
    private final WebServerManager webServerManager;
    private final HdsService hdsService;
    private final HealthCheckTaskManager taskManager;
    private final ConfigService config;
    private final RepositoryManager repositoryManager;
    private final Provider<HealthCheckProcessor> rhcProcessorProvider;
    private final ScanWriterFactory scanWriterFactory;
    private final AssetDownloadCountStore assetDownloadCountStore;
    private Date now;
    private WebServerService webServer;
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Inject
    public HealthCheckTask(WebServerManager webServerManager, HdsService hdsService, HealthCheckTaskManager taskManager, ConfigService config, RepositoryManager reg, Provider<HealthCheckProcessor> rhcProcessorProvider, ScanWriterFactory scanWriterFactory, AssetDownloadCountStore assetDownloadCountStore) {
        this.webServerManager = (WebServerManager)Preconditions.checkNotNull((Object)webServerManager);
        this.hdsService = (HdsService)Preconditions.checkNotNull((Object)hdsService);
        this.taskManager = (HealthCheckTaskManager)Preconditions.checkNotNull((Object)taskManager);
        this.config = (ConfigService)Preconditions.checkNotNull((Object)config);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)reg);
        this.rhcProcessorProvider = (Provider)Preconditions.checkNotNull(rhcProcessorProvider);
        this.scanWriterFactory = (ScanWriterFactory)Preconditions.checkNotNull((Object)scanWriterFactory);
        this.assetDownloadCountStore = (AssetDownloadCountStore)Preconditions.checkNotNull((Object)assetDownloadCountStore);
        this.running = new AtomicBoolean();
        this.objectMapper.configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, true);
    }

    private boolean isForceDeltaCheck() {
        return this.getConfiguration().getBoolean(FORCE_DELTA_CHECK_KEY, false);
    }

    protected Void execute() throws Exception {
        if (this.running.compareAndSet(false, true)) {
            try {
                this.now = new Date();
                try {
                    Void void_ = this.doRunSafe();
                    return void_;
                }
                catch (Exception e) {
                    this.simulateOldBehaviour();
                    throw e;
                }
            }
            finally {
                this.running.set(false);
            }
        }
        this.log.debug("Health check for repository {} already running", (Object)this.getRepositoryName());
        return null;
    }

    private Void doRunSafe() throws Exception {
        String repositoryName = this.getRepositoryName();
        Repository repo = this.getRepository(repositoryName);
        if (repo == null) {
            this.log.debug("Stopping task on deleted/unsupported repository {}", (Object)repositoryName);
            this.config.setEnabled(repositoryName, false);
            this.taskManager.stopTask(repositoryName);
            return null;
        }
        this.log.debug("state = {}, forceDeltaCheck = {}, next report = {}, next scan = {}", new Object[]{this.getState(), this.isForceDeltaCheck(), this.getNextDownloadTime(), this.getNextUploadTime()});
        if (this.webServer == null) {
            this.webServer = this.webServerManager.addWebServer(repositoryName);
        }
        boolean deltasChecked = false;
        if (State.INIT.equals((Object)this.getState())) {
            this.setState(State.INIT);
            this.doDeltaCheck(repositoryName);
            if (!this.webServer.bundleExists() && this.getNextDownloadTime() != null && this.getNextDownloadTime().before(this.getNextUploadTime())) {
                this.setState(State.GET_REPORT);
            } else {
                this.setState(State.PUT_SCAN);
            }
            deltasChecked = true;
        } else if (this.isForceDeltaCheck()) {
            this.doDeltaCheck(repositoryName);
            deltasChecked = true;
        }
        this.getConfiguration().setBoolean(FORCE_DELTA_CHECK_KEY, false);
        switch (this.getState()) {
            case PUT_SCAN: {
                if (this.now.before(this.getNextUploadTime()) && !deltasChecked) {
                    this.doDeltaCheck(repositoryName);
                }
                if (!this.now.before(this.getNextUploadTime())) {
                    if (!this.doUpload(repo, this.doScan(repo))) break;
                    this.setState(State.GET_REPORT);
                    break;
                }
                if (this.webServer.bundleExists()) break;
                this.doDownload(repositoryName);
                break;
            }
            case GET_REPORT: {
                if (this.now.before(this.getNextDownloadTime()) && !deltasChecked) {
                    this.doDeltaCheck(repositoryName);
                }
                if (this.now.before(this.getNextDownloadTime())) break;
                long overdue = this.now.getTime() - this.getNextDownloadTime().getTime();
                if (this.doDownload(repositoryName)) {
                    this.setState(State.PUT_SCAN);
                    String error = this.webServer.getBundleProperties().getProperty("errorMessage", "");
                    if (error.length() > 0) {
                        this.log.warn("Received no health check report for repository {}: {}", (Object)repositoryName, (Object)error);
                        break;
                    }
                    this.log.info("Received health check report for repository {}", (Object)repositoryName);
                    break;
                }
                if (overdue < 900000L) break;
                if (this.now.before(this.getNextUploadTime())) {
                    throw new IOException("Failed to download health check report for repository " + repositoryName + ", " + overdue / 1000L / 60L + " minutes overdue");
                }
                this.setState(State.PUT_SCAN);
                this.log.debug("Received no health check report for repository {}, retrying with another scan", (Object)repositoryName);
                break;
            }
            default: {
                throw new IllegalStateException("illegal task state " + (Object)((Object)this.getState()));
            }
        }
        this.updateSchedule();
        return null;
    }

    private File doScan(Repository repo) throws Exception {
        long start = System.currentTimeMillis();
        int scanRate = this.config.getScanRate();
        HealthCheckProcessor rhcProcessor = (HealthCheckProcessor)((Object)this.rhcProcessorProvider.get());
        int limit = 256;
        Optional<Object> lastName = Optional.empty();
        File tmpFile = File.createTempFile("healthcheck", ".xml.gz");
        try {
            Throwable throwable = null;
            Object var10_12 = null;
            try (ScanWriter writer = this.scanWriterFactory.newWriter(tmpFile);){
                this.checkContinuation(repo);
                rhcProcessor.beforeWalk(repo, scanRate, writer);
                ArrayList needsProcessed = new ArrayList(limit);
                int resultSize = 1;
                while (resultSize > 0) {
                    boolean hasLastName = lastName.isPresent();
                    ImmutableMap params = hasLastName ? ImmutableMap.of((Object)"lastName", lastName.get()) : Collections.emptyMap();
                    this.log.debug("querying assets by page using name {}", (Object)lastName.orElse("NONE"));
                    Transactional.operation.withDb(((StorageFacet)repo.facet(StorageFacet.class)).txSupplier()).call(() -> HealthCheckTask.lambda$0(needsProcessed, hasLastName, (Map)params, repo, limit));
                    for (Asset asset : needsProcessed) {
                        this.checkContinuation(repo);
                        rhcProcessor.processAsset(repo, asset);
                    }
                    resultSize = needsProcessed.size();
                    this.log.trace("page of assets contained {} results", (Object)resultSize);
                    if (resultSize <= 0) continue;
                    Asset last = (Asset)needsProcessed.get(needsProcessed.size() - 1);
                    lastName = Optional.of(last.name());
                    this.log.debug("clearing process buffer and setting name to {}", (Object)lastName.orElse("NONE"));
                    needsProcessed.clear();
                }
                this.checkContinuation(repo);
                rhcProcessor.afterWalk(repo);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            this.checkContinuation(repo);
            File permFile = new File(tmpFile.getParent(), "healthcheck-" + repo.getName() + ".xml.gz");
            try {
                FileUtils.copyFile((File)tmpFile, (File)permFile);
            }
            catch (IOException e) {
                this.log.warn("Could not backup health check scan to {}", (Object)permFile, (Object)e);
            }
        }
        catch (Exception e) {
            tmpFile.delete();
            throw e;
        }
        long time = System.currentTimeMillis() - start;
        this.log.debug("Scanned repository {} in {} ms", (Object)repo.getName(), (Object)time);
        return tmpFile;
    }

    private void checkContinuation(Repository repo) {
        if (this.isCanceled()) {
            throw new TaskInterruptedException(String.format("Scanning of repository %s got cancelled", repo.getName()), true);
        }
        if (!repo.getConfiguration().isOnline()) {
            throw new TaskInterruptedException(String.format("Repository %s is offline", repo.getName()), false);
        }
    }

    private boolean doUpload(Repository repo, File scanFile) throws IOException {
        try (HttpResult result = this.hdsService.uploadScan(repo.getName(), scanFile);){
            if (!result.isSuccess()) {
                throw new IOException("Failed to upload health check scan for repository " + repo.getName() + ", status code " + result.getStatusCode() + " " + result.getStatusText());
            }
            this.updateTimesFromResult(result, true);
        }
        finally {
            scanFile.delete();
        }
        return this.getNextDownloadTime() != null;
    }

    private void doDeltaCheck(String repositoryName) throws IOException {
        try (HttpResult result = this.hdsService.getNextRunDeltas(repositoryName);){
            if (!result.isSuccess()) {
                throw new IOException("Failed to determine health check interval for repository " + repositoryName + ", status code " + result.getStatusCode() + " " + result.getStatusText());
            }
            this.updateTimesFromResult(result, false);
        }
    }

    private void updateTimesFromResult(HttpResult result, boolean expectDownloadTime) throws IOException {
        block6: {
            ObjectNode obj;
            long now = System.currentTimeMillis();
            this.now = new Date(now);
            try {
                obj = (ObjectNode)this.objectMapper.readTree(result.getInputStream());
            }
            catch (Exception e) {
                throw new IOException("Invalid response from Sonatype server: " + e.getMessage(), e);
            }
            try {
                this.setNextUploadTime(new Date(now + (long)(Integer.parseInt(obj.get("nextScanUpload").asText()) * 1000)));
            }
            catch (Exception e) {
                throw new IOException("Invalid response from Sonatype server: " + e.getMessage(), e);
            }
            try {
                this.setNextDownloadTime(new Date(now + (long)(Integer.parseInt(obj.get("nextReportDownload").asText()) * 1000)));
            }
            catch (Exception exception) {
                if (!expectDownloadTime) break block6;
                this.setNextDownloadTime(null);
                this.log.warn("Health check scan was uploaded prematurely, retrying later");
            }
        }
    }

    private boolean doDownload(String repositoryName) throws IOException {
        try (HttpResult result = this.hdsService.getHealthCheckBundle(repositoryName);){
            if (result.getStatusCode() == 404) {
                return false;
            }
            if (!result.isSuccess()) {
                throw new IOException("Failed to download health check report for repository " + repositoryName + ", status code " + result.getStatusCode() + " " + result.getStatusText());
            }
            this.webServer.extractBundle(result.getInputStream());
            if (this.assetDownloadCountStore.isEnabled()) {
                this.putDownloadCountsInDb(this.getRepositoryName(), this.webServer.getContentItem("summary/monthlyDownloads.json"));
            }
        }
        return true;
    }

    @VisibleForTesting
    void putDownloadCountsInDb(String repositoryName, WebServerService.ContentItem contentItem) throws IOException {
        Map downloadCounts;
        if (contentItem != null && contentItem.exists() && !(downloadCounts = (Map)this.objectMapper.readValue(contentItem.getBlob().getInputStream(), (TypeReference)new TypeReference<Map<String, Object>>(){})).isEmpty()) {
            DateTime current = DateTime.now();
            List counts = (List)downloadCounts.get("vulnerableDownloads");
            int i = 0;
            while (i < counts.size()) {
                this.assetDownloadCountStore.setMonthlyVulnerableCount(repositoryName, current.minusMonths(i), (long)((Integer)counts.get(i)).intValue());
                ++i;
            }
            counts = (List)downloadCounts.get("totalDownloads");
            i = 0;
            while (i < counts.size()) {
                this.assetDownloadCountStore.setMonthlyCount(repositoryName, current.minusMonths(i), (long)((Integer)counts.get(i)).intValue());
                ++i;
            }
        }
    }

    private void simulateOldBehaviour() {
        this.log.debug("Rescheduling to retain old behaviour");
        this.taskManager.updateTaskSchedule(this.getRepositoryName(), this.taskManager.createHealthCheckSchedule(new Date(this.now.getTime() + TimeUnit.HOURS.toMillis(1L))), this.getConfiguration(), false);
    }

    private void updateSchedule() {
        Date nextTime;
        CancelableHelper.checkCancellation();
        switch (this.getState()) {
            case GET_REPORT: {
                nextTime = this.getNextDownloadTime();
                break;
            }
            case PUT_SCAN: {
                nextTime = this.getNextUploadTime();
                break;
            }
            default: {
                throw new IllegalStateException("illegal task state " + (Object)((Object)this.getState()));
            }
        }
        long now = System.currentTimeMillis();
        if (nextTime == null) {
            nextTime = new Date(now + 300000L);
        }
        nextTime = new Date(Math.max(nextTime.getTime(), System.currentTimeMillis() + 5000L));
        this.log.debug("state = {}, next run = {}, next report = {}, next scan = {}", new Object[]{this.getState(), nextTime, this.getNextDownloadTime(), this.getNextUploadTime()});
        this.taskManager.updateTaskSchedule(this.getRepositoryName(), this.taskManager.createHealthCheckSchedule(nextTime), this.getConfiguration(), false);
    }

    public String getMessage() {
        return "Health Check Management for Repository " + this.getRepositoryName();
    }

    public String getRepositoryName() {
        return this.getConfiguration().getString(REPOSITORY_NAME_KEY);
    }

    private Repository getRepository(String repositoryName) {
        Repository repo = this.repositoryManager.get(repositoryName);
        if (repo != null && this.taskManager.isSupported(repo)) {
            return repo;
        }
        return null;
    }

    State getState() {
        return State.valueOf(this.getConfiguration().getString(STATE_KEY, State.INIT.name()));
    }

    void setState(State state) {
        this.log.trace("Setting state to: {}", (Object)state);
        this.getConfiguration().setString(STATE_KEY, state.name());
    }

    Date getNextUploadTime() {
        return this.getConfiguration().getDate(NEXT_UPLOAD_TIME_KEY, null);
    }

    void setNextUploadTime(Date nextUploadTime) {
        this.getConfiguration().setDate(NEXT_UPLOAD_TIME_KEY, nextUploadTime);
    }

    Date getNextDownloadTime() {
        return this.getConfiguration().getDate(NEXT_DOWNLOAD_TIME_KEY, null);
    }

    void setNextDownloadTime(Date nextDownloadTime) {
        this.getConfiguration().setDate(NEXT_DOWNLOAD_TIME_KEY, nextDownloadTime);
    }

    private static /* synthetic */ Object lambda$0(List list, boolean bl, Map map, Repository repository, int n) throws RuntimeException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Iterables.addAll((Collection)list, (Iterable)tx.findAssets(bl ? "name > :lastName" : null, map, (Iterable)ImmutableList.of((Object)repository), String.format("ORDER BY name LIMIT %d", n)));
        return null;
    }

    public static enum State {
        INIT,
        PUT_SCAN,
        GET_REPORT;

    }
}

