/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.upgrade;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchemaProxy;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.io.File;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;

@Named
@Singleton
@Upgrades(model="config", from="1.4", to="1.5")
public class ConfigDatabaseUpgrade_1_5
extends DatabaseUpgradeSupport {
    private static final String C_TRANSACTION = new OClassNameBuilder().prefix("firewall").type("transaction").build();
    private static final String P_REPOSITORY_NAME = "repository_name";
    private static final String P_SEQUENCE_NUMBER = "sequence_number";
    private static final String P_REQUEST_TYPE = "request_type";
    private static final String P_COMPONENT_PATH = "component_path";
    private static final String I_REPOSITORY_NAME_SEQUENCE_NUMBER = new OIndexNameBuilder().type(C_TRANSACTION).property("repository_name").property("sequence_number").build();
    private static final String C_TRANSACTION_SEQUENCE = new OClassNameBuilder().prefix("firewall").type("transaction_sequence").build();
    private static final String P_NAME = "name";
    private static final String P_VALUE = "value";
    private static final String I_NAME = new OIndexNameBuilder().type(C_TRANSACTION_SEQUENCE).property("name").build();
    private final Provider<DatabaseInstance> databaseInstance;
    private final ApplicationDirectories applicationDirectories;

    @Inject
    public ConfigDatabaseUpgrade_1_5(@Named(value="config") Provider<DatabaseInstance> databaseInstance, ApplicationDirectories applicationDirectories) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.applicationDirectories = (ApplicationDirectories)Preconditions.checkNotNull((Object)applicationDirectories);
    }

    public void apply() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.upgradeSchema(db);
            this.migrateBacklogs(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void upgradeSchema(ODatabaseDocumentTx db) {
        this.log.debug("Updgrading schema for Firewall request backlog");
        OSchemaProxy schema = db.getMetadata().getSchema();
        OClass type = schema.getClass(C_TRANSACTION);
        if (type == null) {
            type = schema.createClass(C_TRANSACTION);
            type.createProperty(P_REPOSITORY_NAME, OType.STRING).setMandatory(true).setNotNull(true);
            type.createProperty(P_SEQUENCE_NUMBER, OType.LONG).setMandatory(true).setNotNull(true);
            type.createProperty(P_REQUEST_TYPE, OType.STRING).setMandatory(true).setNotNull(true);
            type.createProperty(P_COMPONENT_PATH, OType.STRING);
            type.createIndex(I_REPOSITORY_NAME_SEQUENCE_NUMBER, OClass.INDEX_TYPE.UNIQUE, new String[]{P_REPOSITORY_NAME, P_SEQUENCE_NUMBER});
            this.log.debug("Created schema type {}: properties={}, indexes={}", new Object[]{type, type.properties(), type.getIndexes()});
        }
        if ((type = schema.getClass(C_TRANSACTION_SEQUENCE)) == null) {
            type = schema.createClass(C_TRANSACTION_SEQUENCE);
            type.createProperty(P_NAME, OType.STRING).setMandatory(true).setNotNull(true);
            type.createProperty(P_VALUE, OType.LONG).setMandatory(true).setNotNull(true);
            type.createIndex(I_NAME, OClass.INDEX_TYPE.UNIQUE, new String[]{P_NAME});
            this.log.debug("Created schema type {}: properties={}, indexes={}", new Object[]{type, type.properties(), type.getIndexes()});
        }
    }

    private void migrateBacklogs(ODatabaseDocumentTx db) {
        File directory = this.applicationDirectories.getWorkDirectory("iq", false);
        File[] backlogs = directory.listFiles((dir, name) -> name.startsWith("firewall-tx-") && name.endsWith(".json"));
        if (backlogs == null || backlogs.length <= 0) {
            this.log.debug("Nothing to migrate, {} is {}", (Object)directory, (Object)(backlogs == null ? "not a directory" : "empty"));
            return;
        }
        File[] fileArray = backlogs;
        int n = backlogs.length;
        int n2 = 0;
        while (n2 < n) {
            File backlog = fileArray[n2];
            this.log.info("Migrating Firewall request backlog {}", (Object)backlog);
            try {
                String repositoryName = backlog.getName();
                repositoryName = repositoryName.substring(12, repositoryName.length() - 5);
                List<BacklogEntry> entries = this.loadBacklog(backlog);
                ODocument sequence = db.newInstance(C_TRANSACTION_SEQUENCE);
                sequence.field(P_NAME, (Object)repositoryName);
                sequence.field(P_VALUE, (Object)(entries.size() + 1));
                sequence.save();
                int i = 0;
                while (i < entries.size()) {
                    BacklogEntry entry = entries.get(i);
                    ODocument document = db.newInstance(C_TRANSACTION);
                    document.field(P_REPOSITORY_NAME, (Object)repositoryName);
                    document.field(P_SEQUENCE_NUMBER, (Object)(i + 1));
                    document.field(P_REQUEST_TYPE, (Object)entry.type);
                    document.field(P_COMPONENT_PATH, (Object)entry.path);
                    document.save();
                    ++i;
                }
            }
            catch (Exception e) {
                this.log.warn("Could not migrate Firewall request backlog {}, skipping", (Object)backlog, (Object)e);
            }
            ++n2;
        }
    }

    private List<BacklogEntry> loadBacklog(File backlog) throws Exception {
        return ((Backlog)new ObjectMapper().readValue((File)backlog, Backlog.class)).transactionLog;
    }

    private static class Backlog {
        public List<BacklogEntry> transactionLog;

        private Backlog() {
        }
    }

    private static class BacklogEntry {
        public String type;
        public String path;

        private BacklogEntry() {
        }
    }
}

