/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.gossip;

import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;
import org.sonatype.gossip.Event;
import org.sonatype.gossip.Level;

public abstract class LoggerSupport
extends MarkerIgnoringBase
implements Logger,
Serializable {
    private static final long serialVersionUID = 1L;

    protected LoggerSupport(String name) {
        this.name = name;
    }

    protected LoggerSupport() {
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.getClass().getSimpleName());
        if (this.name != null) {
            buff.append("[").append(this.name).append("]");
        }
        buff.append(String.format("@%x", System.identityHashCode(this)));
        return buff.toString();
    }

    public final int hashCode() {
        if (this.name == null) {
            return System.identityHashCode(this);
        }
        return this.name.hashCode();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Logger that = (Logger)obj;
        return !(this.name == null ? that.getName() != null : !this.name.equals(that.getName()));
    }

    protected abstract boolean isEnabled(Level var1);

    protected abstract void doLog(Event var1);

    protected void doLog(Level level, String message, Throwable cause) {
        this.doLog(new Event(this, level, message, cause));
    }

    private void log(Level level, FormattingTuple tuple) {
        this.doLog(level, tuple.getMessage(), tuple.getThrowable());
    }

    private void log(Level level, String msg) {
        if (this.isEnabled(level)) {
            this.doLog(level, msg, null);
        }
    }

    private void log(Level level, String format, Object arg) {
        if (this.isEnabled(level)) {
            this.log(level, MessageFormatter.format((String)format, (Object)arg));
        }
    }

    private void log(Level level, String format, Object arg1, Object arg2) {
        if (this.isEnabled(level)) {
            this.log(level, MessageFormatter.format((String)format, (Object)arg1, (Object)arg2));
        }
    }

    private void log(Level level, String format, Object[] args) {
        if (this.isEnabled(level)) {
            this.log(level, MessageFormatter.arrayFormat((String)format, (Object[])args));
        }
    }

    public final boolean isTraceEnabled() {
        return this.isEnabled(Level.TRACE);
    }

    public final void trace(String msg) {
        this.log(Level.TRACE, msg);
    }

    public final void trace(String format, Object arg) {
        this.log(Level.TRACE, format, arg);
    }

    public final void trace(String format, Object arg1, Object arg2) {
        this.log(Level.TRACE, format, arg1, arg2);
    }

    public final void trace(String format, Object ... args) {
        this.log(Level.TRACE, format, args);
    }

    public final void trace(String msg, Throwable cause) {
        this.log(Level.TRACE, msg, cause);
    }

    public final boolean isDebugEnabled() {
        return this.isEnabled(Level.DEBUG);
    }

    public final void debug(String msg) {
        this.log(Level.DEBUG, msg);
    }

    public final void debug(String format, Object arg) {
        this.log(Level.DEBUG, format, arg);
    }

    public final void debug(String format, Object arg1, Object arg2) {
        this.log(Level.DEBUG, format, arg1, arg2);
    }

    public final void debug(String format, Object ... args) {
        this.log(Level.DEBUG, format, args);
    }

    public final void debug(String msg, Throwable cause) {
        this.log(Level.DEBUG, msg, cause);
    }

    public final boolean isInfoEnabled() {
        return this.isEnabled(Level.INFO);
    }

    public final void info(String msg) {
        this.log(Level.INFO, msg);
    }

    public final void info(String format, Object arg) {
        this.log(Level.INFO, format, arg);
    }

    public final void info(String format, Object arg1, Object arg2) {
        this.log(Level.INFO, format, arg1, arg2);
    }

    public final void info(String format, Object ... args) {
        this.log(Level.INFO, format, args);
    }

    public final void info(String msg, Throwable cause) {
        this.log(Level.INFO, msg, cause);
    }

    public final boolean isWarnEnabled() {
        return this.isEnabled(Level.WARN);
    }

    public final void warn(String msg) {
        this.log(Level.WARN, msg);
    }

    public final void warn(String format, Object arg) {
        this.log(Level.WARN, format, arg);
    }

    public final void warn(String format, Object ... args) {
        this.log(Level.WARN, format, args);
    }

    public final void warn(String format, Object arg1, Object arg2) {
        this.log(Level.WARN, format, arg1, arg2);
    }

    public final void warn(String msg, Throwable cause) {
        this.log(Level.WARN, msg, cause);
    }

    public final boolean isErrorEnabled() {
        return this.isEnabled(Level.ERROR);
    }

    public final void error(String msg) {
        this.log(Level.ERROR, msg);
    }

    public final void error(String format, Object arg) {
        this.log(Level.ERROR, format, arg);
    }

    public final void error(String format, Object arg1, Object arg2) {
        this.log(Level.ERROR, format, arg1, arg2);
    }

    public final void error(String format, Object ... args) {
        this.log(Level.ERROR, format, args);
    }

    public final void error(String msg, Throwable cause) {
        this.log(Level.ERROR, msg, cause);
    }
}

