/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.tags.service.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.sonatype.nexus.tags.service.TagCleanupService;
import com.sonatype.nexus.tags.service.TagService;
import com.sonatype.nexus.tags.storage.Tag;
import com.sonatype.nexus.tags.storage.TagCleanupQuery;
import com.sonatype.nexus.tags.storage.TagStore;
import com.sonatype.nexus.tags.tasks.TagCleanupTaskConfiguration;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.sonatype.nexus.common.entity.DetachedEntityId;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.search.SearchService;
import org.sonatype.nexus.repository.security.RepositorySelector;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalDeleteBlob;
import org.sonatype.nexus.scheduling.CancelableHelper;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Singleton
public class TagCleanupServiceImpl
extends StateGuardLifecycleSupport
implements TagCleanupService {
    private final TagStore tagStore;
    private final RepositoryManager repositoryManager;
    private final SearchService searchService;
    private final TagService tagService;

    @Inject
    public TagCleanupServiceImpl(TagStore tagStore, RepositoryManager repositoryManager, SearchService searchService, TagService tagService) {
        this.tagStore = (TagStore)Preconditions.checkNotNull((Object)tagStore);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.searchService = (SearchService)Preconditions.checkNotNull((Object)searchService);
        this.tagService = (TagService)Preconditions.checkNotNull((Object)tagService);
    }

    @Override
    public void cleanup(TagCleanupTaskConfiguration configuration) {
        TagCleanupQuery tagCleanupQuery = TagCleanupQuery.builder().fromConfig(configuration).build();
        List<Tag> results = this.tagStore.query(tagCleanupQuery);
        for (Tag tag : results) {
            this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Delete tag '{}' ", (Object)tag.name());
            this.cleanComponentsForTag(configuration, tag);
            CancelableHelper.checkCancellation();
            this.tagStore.delete(tag);
        }
    }

    private Repository getRepository(SearchHit hit) {
        return this.repositoryManager.get((String)hit.getSource().get("repository_name"));
    }

    private void cleanComponentsForTag(TagCleanupTaskConfiguration configuration, Tag tag) {
        for (SearchHit hit : this.searchService.browseUnrestricted((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"tags", (String)tag.name())))) {
            this.cleanComponent(configuration, tag, hit);
        }
    }

    private void cleanComponent(TagCleanupTaskConfiguration configuration, Tag tag, SearchHit hit) {
        CancelableHelper.checkCancellation();
        Repository repository = this.getRepository(hit);
        if (this.shouldDeleteComponent(configuration, repository)) {
            TransactionalDeleteBlob.operation.withDb(((StorageFacet)repository.facet(StorageFacet.class)).txSupplier()).run(() -> {
                StorageTx storageTx = (StorageTx)UnitOfWork.currentTx();
                Component component = storageTx.findComponent((EntityId)new DetachedEntityId(hit.getId()));
                if (component != null) {
                    this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Deleting component '{}'", (Object)component.toStringExternal());
                    storageTx.deleteComponent(component);
                } else {
                    this.log.error("Failed to find component '{}' during deletion of tag '{}'", (Object)hit.getId(), (Object)tag.name());
                }
            });
        } else {
            this.tagService.disassociateById(tag, repository, (EntityId)new DetachedEntityId(hit.getId()));
        }
    }

    private boolean shouldDeleteComponent(TagCleanupTaskConfiguration configuration, Repository repository) {
        if (!configuration.getDeleteAssociatedComponents().booleanValue()) {
            return false;
        }
        String restrictByRepository = configuration.getRestrictComponentDelete();
        if (!Strings.isNullOrEmpty((String)restrictByRepository)) {
            boolean matchesRepositoryName;
            RepositorySelector repositorySelector = RepositorySelector.fromSelector((String)restrictByRepository);
            boolean matchesFormat = repository.getFormat().getValue().contains(repositorySelector.getFormat()) || repositorySelector.isAllFormats();
            boolean bl = matchesRepositoryName = repository.getName().contains(repositorySelector.getName()) || repositorySelector.isAllRepositories();
            return matchesFormat && matchesRepositoryName;
        }
        return true;
    }
}

