/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.tags.service.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.sonatype.nexus.tags.service.ComponentsNotFoundException;
import com.sonatype.nexus.tags.service.TagAlreadyExistsException;
import com.sonatype.nexus.tags.service.TagAttributesTooLargeException;
import com.sonatype.nexus.tags.service.TagNotFoundException;
import com.sonatype.nexus.tags.service.TagService;
import com.sonatype.nexus.tags.storage.Tag;
import com.sonatype.nexus.tags.storage.TagComponent;
import com.sonatype.nexus.tags.storage.TagStore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.decorator.DecoratorUtils;
import org.sonatype.nexus.common.entity.ContinuationTokenHelper;
import org.sonatype.nexus.common.entity.DetachedEntityId;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.browse.BrowseResult;
import org.sonatype.nexus.repository.browse.QueryOptions;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.rest.api.ComponentResponseUtils;
import org.sonatype.nexus.repository.search.SearchService;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreMetadata;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Singleton
public class TagServiceImpl
extends StateGuardLifecycleSupport
implements TagService {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final TagStore tagStore;
    private final ContinuationTokenHelper continuationTokenHelper;
    private final int maxJsonAttributesSize;
    private final RepositoryManager repositoryManager;
    private final SearchService searchService;

    @Inject
    public TagServiceImpl(TagStore tagStore, @Named(value="tag") ContinuationTokenHelper continuationTokenHelper, RepositoryManager repositoryManager, @Named(value="${nexus.tags.maxAttributesSize:-20000}") int maxJsonAttributesSize, SearchService searchService) {
        this.tagStore = (TagStore)Preconditions.checkNotNull((Object)tagStore);
        this.continuationTokenHelper = (ContinuationTokenHelper)Preconditions.checkNotNull((Object)continuationTokenHelper);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.maxJsonAttributesSize = maxJsonAttributesSize;
        this.searchService = (SearchService)Preconditions.checkNotNull((Object)searchService);
    }

    @Override
    @Guarded(by={"STARTED"})
    public Iterable<Tag> list() {
        return this.tagStore.list();
    }

    @Override
    @Guarded(by={"STARTED"})
    public BrowseResult<Tag> browse(String continuationToken) {
        QueryOptions queryOptions = new QueryOptions(null, "id", "asc", Integer.valueOf(0), Integer.valueOf(10), this.continuationTokenHelper.getIdFromToken(continuationToken), false);
        List<Tag> tags = this.tagStore.browse(queryOptions);
        return new BrowseResult(queryOptions, tags);
    }

    @Override
    @Nullable
    @Guarded(by={"STARTED"})
    public Tag get(String name) {
        return this.tagStore.get(name);
    }

    @Override
    @Guarded(by={"STARTED"})
    public List<Tag> get(Set<String> names) {
        return this.tagStore.get(names);
    }

    @Override
    @Guarded(by={"STARTED"})
    public Tag require(String name) {
        return this.getOrThrowNotFound(name);
    }

    @Override
    @Guarded(by={"STARTED"})
    public Tag create(String name, @Nullable Map<String, Object> attributes) {
        this.checkExists(name);
        this.checkAttributesSize(attributes);
        Tag tag = new Tag().name(name).attributes(new NestedAttributesMap("attributes", attributes == null ? Collections.emptyMap() : attributes));
        this.tagStore.create(tag);
        return tag;
    }

    @Override
    @Guarded(by={"STARTED"})
    public void delete(String name) {
        Tag tag = this.getOrThrowNotFound(name);
        Iterable<SearchHit> searchHits = this.searchByTag(name);
        for (SearchHit hit : searchHits) {
            this.disassociateById(tag, this.getRepository(hit), (EntityId)new DetachedEntityId(hit.getId()));
        }
        this.tagStore.delete(tag);
    }

    @Override
    @Guarded(by={"STARTED"})
    public List<Map<String, String>> associate(String tagName, Iterable<SearchHit> searchHits) {
        if (Iterables.isEmpty(searchHits)) {
            throw new ComponentsNotFoundException();
        }
        return this.associate(this.getOrThrowNotFound(tagName), searchHits);
    }

    private List<Map<String, String>> associate(Tag tag, Iterable<SearchHit> searchHits) {
        return StreamSupport.stream(searchHits.spliterator(), false).flatMap(hit -> this.associateById(tag, this.getRepository((SearchHit)hit), (EntityId)new DetachedEntityId(hit.getId())).stream()).collect(Collectors.toList());
    }

    @Override
    @Guarded(by={"STARTED"})
    public List<Map<String, String>> associateById(String tagName, Repository repository, EntityId componentId) {
        return this.associateById(this.getOrThrowNotFound(tagName), repository, componentId);
    }

    private List<Map<String, String>> associateById(Tag tag, Repository repository, EntityId componentId) {
        ArrayList<Map<String, String>> associated = new ArrayList<Map<String, String>>();
        this.componentSaveAction(repository, componentId, component -> {
            this.log.debug("Associating component '{}' with tag '{}'", (Object)component.name(), (Object)tag.name());
            TagComponent tagComponent = (TagComponent)((Object)((Object)DecoratorUtils.getDecoratedEntity((Object)component, TagComponent.class)));
            if (tagComponent != null) {
                tagComponent.tags().add(tag);
                associated.add(ComponentResponseUtils.mapFor((Component)component));
            }
        });
        return associated;
    }

    @Override
    @Guarded(by={"STARTED"})
    public List<Map<String, String>> disassociate(String tagName, Iterable<SearchHit> searchHits) {
        if (Iterables.isEmpty(searchHits)) {
            throw new ComponentsNotFoundException();
        }
        return this.disassociate(this.getOrThrowNotFound(tagName), searchHits);
    }

    private List<Map<String, String>> disassociate(Tag tag, Iterable<SearchHit> searchHits) {
        return StreamSupport.stream(searchHits.spliterator(), false).flatMap(hit -> this.disassociateById(tag, this.getRepository((SearchHit)hit), (EntityId)new DetachedEntityId(hit.getId())).stream()).collect(Collectors.toList());
    }

    @Override
    @Guarded(by={"STARTED"})
    public List<Map<String, String>> disassociateById(String tagName, Repository repository, EntityId componentId) {
        return this.disassociateById(this.getOrThrowNotFound(tagName), repository, componentId);
    }

    @Override
    @Guarded(by={"STARTED"})
    public List<Map<String, String>> disassociateById(Tag tag, Repository repository, EntityId componentId) {
        ArrayList<Map<String, String>> disassociated = new ArrayList<Map<String, String>>();
        this.componentSaveAction(repository, componentId, component -> {
            this.log.debug("Disassociating component '{}' from tag '{}'", (Object)component.name(), (Object)tag.name());
            TagComponent tagComponent = (TagComponent)((Object)((Object)DecoratorUtils.getDecoratedEntity((Object)component, TagComponent.class)));
            if (tagComponent != null) {
                tagComponent.tags().remove((Object)tag);
                disassociated.add(ComponentResponseUtils.mapFor((Component)component));
            }
        });
        return disassociated;
    }

    @Override
    @Guarded(by={"STARTED"})
    public Tag update(String name, Map<String, Object> attributes) {
        Tag tag = this.getOrThrowNotFound(name);
        this.checkAttributesSize(attributes);
        tag.attributes(new NestedAttributesMap("attributes", attributes));
        this.tagStore.update(tag);
        return tag;
    }

    private void checkAttributesSize(Map<String, Object> attributes) {
        if (attributes == null) {
            return;
        }
        try {
            byte[] bytes = objectMapper.writeValueAsBytes(attributes);
            if (bytes.length > this.maxJsonAttributesSize) {
                throw new TagAttributesTooLargeException(this.maxJsonAttributesSize);
            }
        }
        catch (JsonProcessingException e) {
            this.log.error("Error processing size of tag attributes", (Throwable)e);
        }
    }

    private void checkExists(String name) {
        Tag tag = this.get(name);
        if (tag != null) {
            throw new TagAlreadyExistsException(name);
        }
    }

    private Tag getOrThrowNotFound(String name) {
        Tag tag = this.get(name);
        if (tag == null) {
            throw new TagNotFoundException(name);
        }
        return tag;
    }

    private Iterable<SearchHit> searchByTag(String name) {
        return this.searchService.browseUnrestricted((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"tags", (String)name)));
    }

    private void componentSaveAction(Repository repository, EntityId componentId, Consumer<Component> consumer) {
        TransactionalStoreMetadata.operation.withDb(((StorageFacet)repository.facet(StorageFacet.class)).txSupplier()).run(() -> {
            StorageTx storageTx = (StorageTx)UnitOfWork.currentTx();
            Component component = storageTx.findComponent(componentId);
            if (component != null) {
                consumer.accept(component);
                storageTx.saveComponent(component);
            }
        });
    }

    private Repository getRepository(SearchHit hit) {
        return this.repositoryManager.get((String)hit.getSource().get("repository_name"));
    }
}

