/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.tags.storage;

import com.google.common.base.Preconditions;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.joda.time.DateTime;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.AbstractEntity;

public class Tag
extends AbstractEntity {
    @NotNull
    @Pattern(regexp="^[a-zA-Z0-9\\-]{1}[a-zA-Z0-9_\\-\\.]*$", message="{org.sonatype.nexus.validation.constraint.name}")
    @Size(min=1, max=256)
    private String name;
    private NestedAttributesMap attributes;
    private DateTime firstCreated;
    private DateTime lastUpdated;

    public String name() {
        return this.name;
    }

    public Tag name(String name) {
        this.name = name;
        return this;
    }

    public NestedAttributesMap attributes() {
        Preconditions.checkState((this.attributes != null ? 1 : 0) != 0, (String)"Missing attributes: %s", (Object)"attributes");
        return this.attributes;
    }

    public Tag attributes(NestedAttributesMap attributes) {
        this.attributes = (NestedAttributesMap)Preconditions.checkNotNull((Object)attributes);
        return this;
    }

    public DateTime firstCreated() {
        return this.firstCreated;
    }

    public Tag firstCreated(DateTime firstCreated) {
        this.firstCreated = (DateTime)Preconditions.checkNotNull((Object)firstCreated);
        return this;
    }

    public DateTime lastUpdated() {
        return this.lastUpdated;
    }

    public Tag lastUpdated(DateTime lastUpdated) {
        this.lastUpdated = (DateTime)Preconditions.checkNotNull((Object)lastUpdated);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        Tag tag = (Tag)((Object)o);
        return this.name.equals(tag.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

