/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.tags.storage;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sonatype.nexus.tags.tasks.TagCleanupTaskConfiguration;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class TagCleanupQuery {
    private final String whereSql;
    private final Map<String, Object> params;

    private TagCleanupQuery(String whereSql, Map<String, Object> params) {
        this.whereSql = whereSql;
        this.params = params;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWhere() {
        return this.whereSql;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    /* synthetic */ TagCleanupQuery(String string, Map map, TagCleanupQuery tagCleanupQuery) {
        this(string, map);
    }

    public static class Builder {
        private Integer firstCreatedDaysOld;
        private Integer lastUpdatedDaysOld;
        private Pattern nameRegex;

        public Builder fromConfig(TagCleanupTaskConfiguration configuration) {
            return this.firstCreatedDaysOld(configuration.getFirstCreatedDaysOld()).lastUpdatedDaysOld(configuration.getLastUpdatedDaysOld()).nameRegex(configuration.getNameRegex());
        }

        public Builder firstCreatedDaysOld(int firstCreatedDaysOld) {
            this.firstCreatedDaysOld = firstCreatedDaysOld;
            return this;
        }

        public Builder lastUpdatedDaysOld(int lastUpdatedDaysOld) {
            this.lastUpdatedDaysOld = lastUpdatedDaysOld;
            return this;
        }

        public Builder nameRegex(Pattern nameRegex) {
            this.nameRegex = nameRegex;
            return this;
        }

        public TagCleanupQuery build() {
            ArrayList conditionals = Lists.newArrayList();
            HashMap params = Maps.newHashMap();
            if (this.firstCreatedDaysOld > 0) {
                conditionals.add(String.format("%s < :firstCreated", "first_created"));
                params.put("firstCreated", this.dateAsString(LocalDate.now().minusDays(this.firstCreatedDaysOld.intValue())));
            }
            if (this.lastUpdatedDaysOld > 0) {
                conditionals.add(String.format("%s < :lastUpdated", "last_updated"));
                params.put("lastUpdated", this.dateAsString(LocalDate.now().minusDays(this.lastUpdatedDaysOld.intValue())));
            }
            if (this.nameRegex != null && !this.nameRegex.pattern().isEmpty()) {
                conditionals.add(String.format("%s MATCHES :nameRegex", "name"));
                params.put("nameRegex", this.nameRegex.pattern());
            }
            Preconditions.checkArgument((params.size() > 0 ? 1 : 0) != 0, (Object)"No tag cleanup options selected. At least one is required");
            return new TagCleanupQuery(String.join((CharSequence)" AND ", conditionals), params, null);
        }

        private String dateAsString(LocalDate localDate) {
            return localDate.format(DateTimeFormatter.ISO_LOCAL_DATE);
        }
    }
}

