/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.tags.storage.internal;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.sonatype.nexus.tags.storage.TagComponent;
import com.sonatype.nexus.tags.storage.internal.TagEntityAdapter;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.collections.CollectionUtils;
import org.sonatype.nexus.common.decorator.DecoratorUtils;
import org.sonatype.nexus.orient.OIndexBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentEntityAdapter;
import org.sonatype.nexus.repository.storage.ComponentEntityAdapterExtension;

@Named
@Singleton
public class TagsComponentEntityAdapterExtension
implements ComponentEntityAdapterExtension {
    public static final String P_TAGS = "tags";
    public static final String I_COMPONENT_TAGS = new OIndexNameBuilder().type(ComponentEntityAdapter.DB_CLASS).property("tags").build();
    private final TagEntityAdapter tagEntityAdapter;

    @Inject
    public TagsComponentEntityAdapterExtension(TagEntityAdapter tagEntityAdapter) {
        this.tagEntityAdapter = (TagEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)tagEntityAdapter)));
    }

    public void defineType(ODatabaseDocumentTx db, OClass type) {
        type.createProperty(P_TAGS, OType.LINKLIST, this.tagEntityAdapter.getSchemaType(), true).setDefaultValue("[]");
        new OIndexBuilder(type, I_COMPONENT_TAGS, OClass.INDEX_TYPE.NOTUNIQUE_HASH_INDEX).property(P_TAGS, OType.LINKLIST).ignoreNullValues().build(db);
    }

    public void readFields(ODocument document, Component entity) {
        TagComponent tagComponent = (TagComponent)((Object)DecoratorUtils.getDecoratedEntity((Object)entity, TagComponent.class));
        if (tagComponent == null) {
            return;
        }
        List tags = (List)document.field(P_TAGS, OType.LINKLIST);
        if (!CollectionUtils.isEmpty((Collection)tags)) {
            tags.stream().forEach(tag -> Optional.ofNullable(tag).map(OIdentifiable::getRecord).map(arg_0 -> ((TagEntityAdapter)this.tagEntityAdapter).readEntity(arg_0)).ifPresent(tagComponent::addTag));
        }
    }

    public void writeFields(ODocument document, Component entity) {
        TagComponent tagComponent = (TagComponent)((Object)DecoratorUtils.getDecoratedEntity((Object)entity, TagComponent.class));
        if (tagComponent == null) {
            return;
        }
        document.field(P_TAGS, tagComponent.tags().stream().map(arg_0 -> ((TagEntityAdapter)this.tagEntityAdapter).recordIdentity(arg_0)).collect(Collectors.toList()));
    }

    public void prefetchFields(ODocument document) {
        List tags = (List)document.field(P_TAGS, OType.LINKLIST);
        if (!CollectionUtils.isEmpty((Collection)tags) && tags instanceof ORecordLazyMultiValue) {
            ORecordLazyMultiValue lazyTags = (ORecordLazyMultiValue)tags;
            lazyTags.setAutoConvertToRecord(true);
            lazyTags.convertLinks2Records();
        }
    }
}

