/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.tags.tasks;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.elasticsearch.common.Strings;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.scheduling.TaskConfiguration;

public class TagCleanupTaskConfiguration
extends ComponentSupport {
    public static final String FIRST_CREATED_DAYS_OLD_FIELD_ID = "firstCreatedDays";
    public static final String LAST_UPDATED_DAYS_OLD_FIELD_ID = "lastUpdatedDays";
    public static final String NAME_REGEX_FIELD_ID = "nameRegex";
    public static final String DELETE_ASSOCIATED_COMPONENTS_FIELD_ID = "deleteAssociatedComponents";
    public static final String RESTRICT_COMPONENT_DELETE_FIELD_ID = "restrictComponentDelete";
    static final String NO_OPTIONS_INVALID_ERROR = "No task configuration options were selected";
    static final String AGE_CONFIG_INVALID_ERROR = "Tag modified age cannot be greater than creation age";
    static final String NAME_REGEX_INVALID_ERROR = "Name regular expression is not valid: {}";
    static final String RESTRICT_COMPONENT_DELETE_OPTION_DOES_NOT_HAVE_DELETE_CHECKED_ERROR = "'Delete associated components' must be selected when the 'Restrict delete' option is selected";
    private final Integer firstCreatedDaysOld;
    private final Integer lastUpdatedDaysOld;
    private final String nameRegexStr;
    private final Boolean deleteAssociatedComponents;
    private final String restrictComponentDelete;
    private Pattern nameRegex;

    TagCleanupTaskConfiguration(TaskConfiguration taskConfiguration) {
        this.firstCreatedDaysOld = taskConfiguration.getInteger(FIRST_CREATED_DAYS_OLD_FIELD_ID, -1);
        this.lastUpdatedDaysOld = taskConfiguration.getInteger(LAST_UPDATED_DAYS_OLD_FIELD_ID, -1);
        this.nameRegexStr = taskConfiguration.getString(NAME_REGEX_FIELD_ID, "");
        this.deleteAssociatedComponents = taskConfiguration.getBoolean(DELETE_ASSOCIATED_COMPONENTS_FIELD_ID, false);
        this.restrictComponentDelete = taskConfiguration.getString(RESTRICT_COMPONENT_DELETE_FIELD_ID, "");
    }

    boolean validate() {
        if (this.firstCreatedDaysOld < 1 && this.lastUpdatedDaysOld < 1 && Strings.isNullOrEmpty((String)this.nameRegexStr)) {
            this.log.error(NO_OPTIONS_INVALID_ERROR);
            return false;
        }
        if (this.firstCreatedDaysOld > 0 && this.lastUpdatedDaysOld > 0 && this.lastUpdatedDaysOld > this.firstCreatedDaysOld) {
            this.log.error(AGE_CONFIG_INVALID_ERROR);
            return false;
        }
        try {
            this.nameRegex = Pattern.compile(this.nameRegexStr);
        }
        catch (PatternSyntaxException e) {
            this.log.error(NAME_REGEX_INVALID_ERROR, (Object)e.getMessage());
            return false;
        }
        if (!Strings.isNullOrEmpty((String)this.restrictComponentDelete) && !this.deleteAssociatedComponents.booleanValue()) {
            this.log.error(RESTRICT_COMPONENT_DELETE_OPTION_DOES_NOT_HAVE_DELETE_CHECKED_ERROR);
            return false;
        }
        return true;
    }

    public Integer getFirstCreatedDaysOld() {
        return this.firstCreatedDaysOld;
    }

    public Integer getLastUpdatedDaysOld() {
        return this.lastUpdatedDaysOld;
    }

    public Pattern getNameRegex() {
        return this.nameRegex;
    }

    public Boolean getDeleteAssociatedComponents() {
        return this.deleteAssociatedComponents;
    }

    public String getRestrictComponentDelete() {
        return this.restrictComponentDelete;
    }
}

