/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.ssl.plugin.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.ssl.plugin.internal.keystore.KeyStoreDataEvent;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.orient.freeze.DatabaseFreezeService;
import org.sonatype.nexus.ssl.CertificateCreatedEvent;
import org.sonatype.nexus.ssl.CertificateDeletedEvent;
import org.sonatype.nexus.ssl.CertificateUtil;
import org.sonatype.nexus.ssl.KeyStoreManager;
import org.sonatype.nexus.ssl.KeystoreException;
import org.sonatype.nexus.ssl.TrustStore;

@Named
@Singleton
public class TrustStoreImpl
extends ComponentSupport
implements EventAware,
TrustStore {
    public static final SecureRandom DEFAULT_RANDOM = null;
    private final DatabaseFreezeService databaseFreezeService;
    private final EventManager eventManager;
    private final KeyManager[] keyManagers;
    private final TrustManager[] trustManagers;
    private X509TrustManager managedTrustManager;
    private final KeyStoreManager keyStoreManager;
    private volatile SSLContext sslcontext;

    @Inject
    public TrustStoreImpl(EventManager eventManager, @Named(value="ssl") KeyStoreManager keyStoreManager, DatabaseFreezeService databaseFreezeService) throws Exception {
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.keyStoreManager = (KeyStoreManager)Preconditions.checkNotNull((Object)keyStoreManager);
        this.databaseFreezeService = (DatabaseFreezeService)Preconditions.checkNotNull((Object)databaseFreezeService);
        this.keyManagers = TrustStoreImpl.getSystemKeyManagers();
        this.trustManagers = this.getTrustManagers();
    }

    public Certificate importTrustCertificate(Certificate certificate, String alias) throws KeystoreException {
        this.databaseFreezeService.checkUnfrozen("Unable to import a certificate while database is frozen.");
        this.keyStoreManager.importTrustCertificate(certificate, alias);
        this.eventManager.post((Object)new CertificateCreatedEvent(alias, certificate));
        this.log.info("Certificate added successfully in trust-store with Fingerprint: {}, Name: {} and SHA1 Identifier: {} ", new Object[]{alias, this.getCertificateName(certificate), this.getCertificateSha1(certificate)});
        return certificate;
    }

    public Certificate importTrustCertificate(String certificateInPEM, String alias) throws KeystoreException, CertificateException {
        Certificate certificate = CertificateUtil.decodePEMFormattedCertificate((String)certificateInPEM);
        return this.importTrustCertificate(certificate, alias);
    }

    public Certificate getTrustedCertificate(String alias) throws KeystoreException {
        return this.keyStoreManager.getTrustedCertificate(alias);
    }

    public Collection<Certificate> getTrustedCertificates() throws KeystoreException {
        return this.keyStoreManager.getTrustedCertificates();
    }

    public void removeTrustCertificate(String alias) throws KeystoreException {
        this.databaseFreezeService.checkUnfrozen("Unable to remove a certificate while database is frozen.");
        Certificate certificate = this.getTrustedCertificate(alias);
        this.keyStoreManager.removeTrustCertificate(alias);
        this.sslcontext = null;
        this.eventManager.post((Object)new CertificateDeletedEvent(alias, certificate));
        this.log.info("Certificate removed successfully from trust-store with Fingerprint : {}, Name : {} and SHA1 Identifier : {}", new Object[]{alias, this.getCertificateName(certificate), this.getCertificateSha1(certificate)});
    }

    public SSLContext getSSLContext() {
        SSLContext _sslcontext = this.sslcontext;
        if (_sslcontext == null) {
            try {
                this.managedTrustManager = TrustStoreImpl.getManagedTrustManager(this.keyStoreManager);
                _sslcontext = SSLContext.getInstance("TLS");
                _sslcontext.init(this.keyManagers, this.trustManagers, DEFAULT_RANDOM);
                this.sslcontext = _sslcontext;
            }
            catch (Exception e) {
                this.log.debug("Could not create SSL context", (Throwable)e);
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return _sslcontext;
    }

    @Subscribe
    public void onKeyStoreDataUpdated(KeyStoreDataEvent event) {
        this.sslcontext = null;
    }

    private TrustManager[] getTrustManagers() throws Exception {
        TrustManager[] systemTrustManagers = TrustStoreImpl.getSystemTrustManagers();
        if (systemTrustManagers != null) {
            return (TrustManager[])Arrays.stream(systemTrustManagers).map(tm -> {
                if (tm instanceof X509TrustManager) {
                    return new FallbackOnManagedX509TrustManager((X509TrustManager)tm);
                }
                return tm;
            }).toArray(TrustManager[]::new);
        }
        return null;
    }

    private static X509TrustManager getManagedTrustManager(KeyStoreManager keyStoreManager) throws KeystoreException {
        TrustManager[] managedTrustManagers = keyStoreManager.getTrustManagers();
        if (managedTrustManagers != null) {
            TrustManager[] trustManagerArray = managedTrustManagers;
            int n = managedTrustManagers.length;
            int n2 = 0;
            while (n2 < n) {
                TrustManager tm = trustManagerArray[n2];
                if (tm instanceof X509TrustManager) {
                    return (X509TrustManager)tm;
                }
                ++n2;
            }
        }
        return null;
    }

    private static KeyManager[] getSystemKeyManagers() throws Exception {
        KeyManagerFactory keyManagerFactory;
        String keyStoreType;
        String keyAlgorithm = System.getProperty("ssl.KeyManagerFactory.algorithm");
        if (keyAlgorithm == null) {
            keyAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
        }
        if ((keyStoreType = System.getProperty("javax.net.ssl.keyStoreType")) == null) {
            keyStoreType = KeyStore.getDefaultType();
        }
        if ("none".equalsIgnoreCase(keyStoreType)) {
            keyManagerFactory = KeyManagerFactory.getInstance(keyAlgorithm);
        } else {
            String keyStoreFileName = System.getProperty("javax.net.ssl.keyStore");
            if (keyStoreFileName != null) {
                File keyStoreFile = new File(keyStoreFileName);
                keyManagerFactory = KeyManagerFactory.getInstance(keyAlgorithm);
                String keyStoreProvider = System.getProperty("javax.net.ssl.keyStoreProvider");
                KeyStore keyStore = keyStoreProvider != null ? KeyStore.getInstance(keyStoreType, keyStoreProvider) : KeyStore.getInstance(keyStoreType);
                String password = System.getProperty("javax.net.ssl.keyStorePassword");
                Throwable throwable = null;
                Object var9_10 = null;
                try (FileInputStream in = new FileInputStream(keyStoreFile);){
                    keyStore.load(in, password != null ? password.toCharArray() : null);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                keyManagerFactory.init(keyStore, password != null ? password.toCharArray() : null);
            } else {
                return null;
            }
        }
        return keyManagerFactory.getKeyManagers();
    }

    private static TrustManager[] getSystemTrustManagers() throws Exception {
        TrustManagerFactory trustManagerFactory;
        String trustStoreType;
        String trustAlgorithm = System.getProperty("ssl.TrustManagerFactory.algorithm");
        if (trustAlgorithm == null) {
            trustAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
        }
        if ((trustStoreType = System.getProperty("javax.net.ssl.trustStoreType")) == null) {
            trustStoreType = KeyStore.getDefaultType();
        }
        if ("none".equalsIgnoreCase(trustStoreType)) {
            trustManagerFactory = TrustManagerFactory.getInstance(trustAlgorithm);
        } else {
            KeyStore trustStore;
            File trustStoreFile;
            String trustStoreFileName = System.getProperty("javax.net.ssl.trustStore");
            if (trustStoreFileName != null) {
                trustStoreFile = new File(trustStoreFileName);
                trustManagerFactory = TrustManagerFactory.getInstance(trustAlgorithm);
                String trustStoreProvider = System.getProperty("javax.net.ssl.trustStoreProvider");
                trustStore = trustStoreProvider != null ? KeyStore.getInstance(trustStoreType, trustStoreProvider) : KeyStore.getInstance(trustStoreType);
            } else {
                File javaHome = new File(System.getProperty("java.home"));
                File file = new File(javaHome, "lib/security/jssecacerts");
                trustStoreFile = !file.exists() ? (file = new File(javaHome, "lib/security/cacerts")) : file;
                trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            }
            String password = System.getProperty("javax.net.ssl.trustStorePassword");
            Throwable throwable = null;
            Object var8_9 = null;
            try (FileInputStream in = new FileInputStream(trustStoreFile);){
                trustStore.load(in, password != null ? password.toCharArray() : null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            trustManagerFactory.init(trustStore);
        }
        return trustManagerFactory.getTrustManagers();
    }

    private String getCertificateName(Certificate certificate) {
        if (certificate instanceof X509Certificate) {
            X509Certificate cert = (X509Certificate)certificate;
            return cert.getSubjectDN().getName();
        }
        this.log.warn("Unknown certificate found, hence can't get the name.");
        return "Unknown";
    }

    private String getCertificateSha1(Certificate certificate) {
        try {
            return CertificateUtil.calculateSha1((Certificate)certificate);
        }
        catch (CertificateEncodingException e) {
            this.log.error("Error occurred while calculating certificate SHA1", (Throwable)e);
            return "Unknown";
        }
    }

    private class FallbackOnManagedX509TrustManager
    implements X509TrustManager {
        private final X509TrustManager primary;

        FallbackOnManagedX509TrustManager(X509TrustManager primary) {
            this.primary = (X509TrustManager)Preconditions.checkNotNull((Object)primary);
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.primary.checkClientTrusted(chain, authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            try {
                this.primary.checkServerTrusted(chain, authType);
            }
            catch (CertificateException e) {
                if (TrustStoreImpl.this.managedTrustManager == null) {
                    throw e;
                }
                try {
                    TrustStoreImpl.this.managedTrustManager.checkServerTrusted(chain, authType);
                }
                catch (CertificateException certificateException) {
                    throw e;
                }
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.primary.getAcceptedIssuers();
        }
    }
}

