/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.ssl.plugin.internal.keystore;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.Time;
import org.sonatype.nexus.ssl.KeyStoreManagerConfigurationSupport;

@Named(value="ssl")
@Singleton
public class KeyStoreManagerConfigurationImpl
extends KeyStoreManagerConfigurationSupport {
    private static final String CPREFIX = "${ssl.keyStoreManager";
    private static final char[] PKSP = "QePgCbrDbQiNdT6X".toCharArray();
    private static final char[] TKSP = "xfWHLzWxDF14OUW6".toCharArray();
    private static final char[] PKP = "Xw5JCuS5aDZ14oZG".toCharArray();

    @Inject
    public KeyStoreManagerConfigurationImpl(@Named(value="${ssl.keyStoreManager.keyStoreType:-JKS}") String keyStoreType, @Named(value="${ssl.keyStoreManager.keyAlgorithm:-RSA}") String keyAlgorithm, @Named(value="${ssl.keyStoreManager.keyAlgorithmSize:-2048}") int keyAlgorithmSize, @Named(value="${ssl.keyStoreManager.certificateValidity:-36500d}") Time certificateValidity, @Named(value="${ssl.keyStoreManager.signatureAlgorithm:-SHA1WITHRSA}") String signatureAlgorithm, @Named(value="${ssl.keyStoreManager.keyManagerAlgorithm:-DEFAULT}") String keyManagerAlgorithm, @Named(value="${ssl.keyStoreManager.trustManagerAlgorithm:-DEFAULT}") String trustManagerAlgorithm) {
        this.setPrivateKeyStorePassword(PKSP);
        this.setTrustedKeyStorePassword(TKSP);
        this.setPrivateKeyPassword(PKP);
        this.setKeyStoreType(keyStoreType);
        this.setKeyAlgorithm(keyAlgorithm);
        this.setKeyAlgorithmSize(keyAlgorithmSize);
        this.setCertificateValidity(certificateValidity);
        this.setSignatureAlgorithm(signatureAlgorithm);
        this.setKeyManagerAlgorithm(keyManagerAlgorithm);
        this.setTrustManagerAlgorithm(trustManagerAlgorithm);
    }
}

