/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.ssl.plugin.internal.keystore;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.ssl.plugin.internal.keystore.KeyStoreData;
import com.sonatype.nexus.ssl.plugin.internal.keystore.KeyStoreDataEvent;
import com.sonatype.nexus.ssl.plugin.internal.keystore.KeyStoreStorageManagerImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.entity.EntityVersion;
import org.sonatype.nexus.ssl.spi.KeyStoreStorage;

public class OrientKeyStoreStorage
extends ComponentSupport
implements KeyStoreStorage {
    private final KeyStoreStorageManagerImpl storageManager;
    private final String keyStoreName;
    private volatile EntityVersion loadedVersion;
    private volatile EntityVersion latestVersion;

    public OrientKeyStoreStorage(KeyStoreStorageManagerImpl storageManager, String keyStoreName) {
        this.storageManager = (KeyStoreStorageManagerImpl)((Object)Preconditions.checkNotNull((Object)((Object)storageManager)));
        this.keyStoreName = (String)Preconditions.checkNotNull((Object)keyStoreName);
    }

    @VisibleForTesting
    public String getKeyStoreName() {
        return this.keyStoreName;
    }

    public boolean exists() {
        return this.storageManager.load(this.keyStoreName) != null;
    }

    public boolean modified() {
        return this.loadedVersion == null ? this.exists() : this.latestVersion != null && !this.latestVersion.equals(this.loadedVersion);
    }

    @Subscribe
    public void onKeyStoreDataUpdated(KeyStoreDataEvent event) {
        if (this.keyStoreName.equals(event.getKeyStoreName())) {
            this.latestVersion = event.getVersion();
            this.log.debug("Observed version {} of key store {} updated by node {}", new Object[]{this.latestVersion, this.keyStoreName, event.getRemoteNodeId()});
        }
    }

    public void load(KeyStore keyStore, char[] password) throws NoSuchAlgorithmException, CertificateException, IOException {
        KeyStoreData entity = this.storageManager.load(this.keyStoreName);
        Preconditions.checkState((entity != null ? 1 : 0) != 0, (String)"key store %s does not exist", (Object)this.keyStoreName);
        keyStore.load(new ByteArrayInputStream(entity.getBytes()), password);
        this.loadedVersion = entity.getEntityMetadata().getVersion();
        this.log.debug("Loaded version {} of key store {}", (Object)this.loadedVersion, (Object)this.keyStoreName);
    }

    public void save(KeyStore keyStore, char[] password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(16384);
        keyStore.store(baos, password);
        KeyStoreData entity = new KeyStoreData();
        entity.setName(this.keyStoreName);
        entity.setBytes(baos.toByteArray());
        this.storageManager.save(entity);
        this.loadedVersion = entity.getEntityMetadata().getVersion();
        this.log.debug("Saved version {} of key store {}", (Object)this.loadedVersion, (Object)this.keyStoreName);
    }

    public String toString() {
        return "orient:/" + this.keyStoreName;
    }
}

