/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.ssl.plugin.internal.ui;

import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Timed;
import com.softwarementors.extjs.djn.config.annotations.DirectAction;
import com.softwarementors.extjs.djn.config.annotations.DirectMethod;
import com.sonatype.nexus.ssl.plugin.PemCertificate;
import com.sonatype.nexus.ssl.plugin.internal.CertificateRetriever;
import com.sonatype.nexus.ssl.plugin.internal.ui.CertificateXO;
import com.sonatype.nexus.ssl.plugin.internal.ui.TrustStoreComponent;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.UnknownHostException;
import java.security.cert.Certificate;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.NotEmpty;
import org.sonatype.nexus.extdirect.DirectComponentSupport;
import org.sonatype.nexus.ssl.CertificateUtil;
import org.sonatype.nexus.ssl.TrustStore;
import org.sonatype.nexus.validation.Validate;

@Named
@Singleton
@DirectAction(action={"ssl_Certificate"})
public class CertificateComponent
extends DirectComponentSupport
implements GroovyObject {
    @Inject
    private TrustStore trustStore;
    @Inject
    private CertificateRetriever certificateRetriever;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public CertificateComponent() {
        MetaClass metaClass;
        CallSite[] callSiteArray = CertificateComponent.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @Validate
    @RequiresAuthentication
    public CertificateXO retrieveFromHost(@NotEmpty String host, @Nullable Integer port, @Nullable String protocolHint) {
        CallSite[] callSiteArray = CertificateComponent.$getCallSiteArray();
        Integer n = port;
        int actualPort = DefaultTypeTransformation.booleanUnbox((Object)n) ? n : Integer.valueOf(443);
        Object[] chain = null;
        try {
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[0].callCurrent((GroovyObject)this, (Object)host, (Object)actualPort, (Object)protocolHint);
                chain = (Certificate[])ScriptBytecodeAdapter.castToType((Object)object, Certificate[].class);
            } else {
                Object[] objectArray;
                chain = objectArray = this.retrieveCertificates(host, actualPort, protocolHint);
            }
        }
        catch (Exception e) {
            String errorMessage = ShortTypeHandling.castToString((Object)callSiteArray[1].callGetProperty((Object)e));
            if (e instanceof UnknownHostException) {
                GStringImpl gStringImpl = new GStringImpl(new Object[]{host}, new String[]{"Unknown host '", "'"});
                errorMessage = ShortTypeHandling.castToString((Object)gStringImpl);
            }
            throw (Throwable)callSiteArray[2].callConstructor(IOException.class, (Object)errorMessage);
        }
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)chain) || ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[3].callGetProperty((Object)chain), (Object)0)) {
                throw (Throwable)callSiteArray[4].callConstructor(IOException.class, (Object)new GStringImpl(new Object[]{host, actualPort}, new String[]{"Could not retrieve an SSL certificate from '", ":", "'"}));
            }
        } else if (!DefaultTypeTransformation.booleanUnbox((Object)chain) || ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[5].callGetProperty((Object)chain), (Object)0)) {
            throw (Throwable)callSiteArray[6].callConstructor(IOException.class, (Object)new GStringImpl(new Object[]{host, actualPort}, new String[]{"Could not retrieve an SSL certificate from '", ":", "'"}));
        }
        if (!BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (CertificateXO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[7].callStatic(TrustStoreComponent.class, callSiteArray[8].call((Object)chain, (Object)0), callSiteArray[9].callCurrent((GroovyObject)this, callSiteArray[10].call((Object)chain, (Object)0))), CertificateXO.class);
        }
        return (CertificateXO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[11].callStatic(TrustStoreComponent.class, BytecodeInterface8.objectArrayGet((Object[])chain, (int)0), callSiteArray[12].callCurrent((GroovyObject)this, BytecodeInterface8.objectArrayGet((Object[])chain, (int)0))), CertificateXO.class);
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @Validate
    @RequiresAuthentication
    public CertificateXO details(@NotBlank @PemCertificate String pem) {
        CallSite[] callSiteArray = CertificateComponent.$getCallSiteArray();
        Certificate certificate = (Certificate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[13].callStatic(CertificateUtil.class, (Object)pem), Certificate.class);
        return (CertificateXO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[14].callStatic(TrustStoreComponent.class, (Object)certificate, callSiteArray[15].callCurrent((GroovyObject)this, (Object)certificate)), CertificateXO.class);
    }

    public Certificate[] retrieveCertificates(String host, int port, String protocolHint) {
        CallSite[] callSiteArray = CertificateComponent.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)protocolHint)) {
            Certificate[] certificateArray = (Certificate[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[16].call((Object)this.certificateRetriever, (Object)host, (Object)port), Certificate[].class);
            try {
                return certificateArray;
            }
            catch (Exception e) {
                callSiteArray[17].call(callSiteArray[18].callGroovyObjectGetProperty((Object)this), (Object)"Cannot connect directly to {}:{}. Will retry using https protocol.", (Object)host, (Object)port, (Object)e);
                Certificate[] certificateArray2 = (Certificate[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[19].call((Object)this.certificateRetriever, (Object)host, (Object)port), Certificate[].class);
                return certificateArray2;
            }
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[20].call((Object)"https", (Object)protocolHint))) {
            return (Certificate[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[21].call((Object)this.certificateRetriever, (Object)host, (Object)port), Certificate[].class);
        }
        return (Certificate[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[22].call((Object)this.certificateRetriever, (Object)host, (Object)port), Certificate[].class);
    }

    public boolean isInTrustStore(Certificate certificate) {
        CallSite[] callSiteArray = CertificateComponent.$getCallSiteArray();
        boolean bl = ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[23].call((Object)this.trustStore, callSiteArray[24].callStatic(CertificateUtil.class, (Object)certificate)), null);
        try {
            return bl;
        }
        catch (Exception ignore) {
            boolean bl2 = false;
            return bl2;
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != CertificateComponent.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public TrustStore getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(TrustStore trustStore) {
        this.trustStore = trustStore;
    }

    public CertificateRetriever getCertificateRetriever() {
        return this.certificateRetriever;
    }

    public void setCertificateRetriever(CertificateRetriever certificateRetriever) {
        this.certificateRetriever = certificateRetriever;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "retrieveCertificates";
        stringArray[1] = "message";
        stringArray[2] = "<$constructor$>";
        stringArray[3] = "length";
        stringArray[4] = "<$constructor$>";
        stringArray[5] = "length";
        stringArray[6] = "<$constructor$>";
        stringArray[7] = "asCertificateXO";
        stringArray[8] = "getAt";
        stringArray[9] = "isInTrustStore";
        stringArray[10] = "getAt";
        stringArray[11] = "asCertificateXO";
        stringArray[12] = "isInTrustStore";
        stringArray[13] = "decodePEMFormattedCertificate";
        stringArray[14] = "asCertificateXO";
        stringArray[15] = "isInTrustStore";
        stringArray[16] = "retrieveCertificates";
        stringArray[17] = "debug";
        stringArray[18] = "log";
        stringArray[19] = "retrieveCertificatesFromHttpsServer";
        stringArray[20] = "equalsIgnoreCase";
        stringArray[21] = "retrieveCertificatesFromHttpsServer";
        stringArray[22] = "retrieveCertificates";
        stringArray[23] = "getTrustedCertificate";
        stringArray[24] = "calculateFingerprint";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[25];
        CertificateComponent.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(CertificateComponent.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = CertificateComponent.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

