/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.ssl.plugin.upgrade;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchemaProxy;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;

@Named
@Singleton
public class LegacyKeyStoreUpgradeService
extends ComponentSupport {
    private static final String TRUSTED_KEYS_FILENAME = "trusted.ks";
    private static final String PRIVATE_KEYS_FILENAME = "private.ks";
    private static final String DB_CLASS = new OClassNameBuilder().type("key_store").build();
    private static final String P_NAME = "name";
    private static final String P_BYTES = "bytes";
    private static final String I_NAME = new OIndexNameBuilder().type(DB_CLASS).property("name").build();
    private final Provider<DatabaseInstance> databaseInstance;
    private final Path keyStoreBasedir;

    @Inject
    public LegacyKeyStoreUpgradeService(@Named(value="config") Provider<DatabaseInstance> databaseInstance, ApplicationDirectories appDirectories) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.keyStoreBasedir = new File(appDirectories.getWorkDirectory("keystores", false), "ssl").toPath();
    }

    public void upgradeSchema() throws Exception {
        this.log.debug("Updgrading schema for trust store");
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            OSchemaProxy schema = db.getMetadata().getSchema();
            OClass type = schema.getClass(DB_CLASS);
            if (type == null) {
                type = schema.createClass(DB_CLASS);
                type.createProperty(P_NAME, OType.STRING).setMandatory(true).setNotNull(true);
                type.createProperty(P_BYTES, OType.BINARY).setMandatory(true).setNotNull(true);
                type.createIndex(I_NAME, OClass.INDEX_TYPE.UNIQUE, new String[]{P_NAME});
                this.log.debug("Created schema type {}: properties={}, indexes={}", new Object[]{type, type.properties(), type.getIndexes()});
            } else {
                this.log.debug("Skipped creating existing schema type {}: properties={}, indexes={}", new Object[]{type, type.properties(), type.getIndexes()});
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void importKeyStoreFiles() throws Exception {
        this.log.debug("Importing legacy trust store from {}", (Object)this.keyStoreBasedir);
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            for (String filename : Arrays.asList(TRUSTED_KEYS_FILENAME, PRIVATE_KEYS_FILENAME)) {
                String keyStoreName = "ssl/" + filename;
                String query = "SELECT FROM " + DB_CLASS + " WHERE " + P_NAME + " = ?";
                List results = (List)db.command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[]{keyStoreName});
                if (!results.isEmpty()) {
                    this.log.debug("Skipped import of existing legacy key store {}", results.get(0));
                    continue;
                }
                Path keyStorePath = this.keyStoreBasedir.resolve(filename);
                if (!Files.isRegularFile(keyStorePath, new LinkOption[0])) continue;
                ODocument doc = db.newInstance(DB_CLASS);
                doc.field(P_NAME, (Object)keyStoreName);
                doc.field(P_BYTES, (Object)Files.readAllBytes(keyStorePath));
                doc.save();
                this.log.debug("Imported legacy key store {}", (Object)doc);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void deleteKeyStoreFiles() {
        this.log.debug("Deleting legacy trust store from {}", (Object)this.keyStoreBasedir);
        try {
            for (String filename : Arrays.asList(TRUSTED_KEYS_FILENAME, PRIVATE_KEYS_FILENAME)) {
                Files.deleteIfExists(this.keyStoreBasedir.resolve(filename));
            }
            Files.deleteIfExists(this.keyStoreBasedir);
        }
        catch (IOException e) {
            this.log.warn("Could not delete obsolete trust store from {}. Error: {}", (Object)this.keyStoreBasedir, (Object)e.toString());
        }
    }
}

