/*
 * Decompiled with CFR 0.152.
 */
package org.redline_rpm;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dependency {
    private String name;
    private String version;
    private Integer flags;

    public Dependency(String name, String version, Integer flags) {
        this.name = name;
        this.version = version;
        this.flags = flags;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public Integer getFlags() {
        return this.flags;
    }

    public static String[] getArrayOfNames(List<Dependency> dependencyList) {
        LinkedList<String> nameList = new LinkedList<String>();
        for (Dependency dependency : dependencyList) {
            nameList.add(dependency.getName());
        }
        return nameList.toArray(new String[nameList.size()]);
    }

    public static String[] getArrayOfVersions(List<Dependency> dependencyList) {
        LinkedList<String> versionList = new LinkedList<String>();
        for (Dependency dependency : dependencyList) {
            versionList.add(dependency.getVersion());
        }
        return versionList.toArray(new String[versionList.size()]);
    }

    public static Integer[] getArrayOfFlags(List<Dependency> dependencyList) {
        LinkedList<Integer> flagsList = new LinkedList<Integer>();
        for (Dependency dependency : dependencyList) {
            flagsList.add(dependency.getFlags());
        }
        return flagsList.toArray(new Integer[flagsList.size()]);
    }

    public static String[] getArrayOfNames(Map<String, Dependency> dependencies) {
        LinkedList<String> nameList = new LinkedList<String>();
        for (Dependency dependency : dependencies.values()) {
            nameList.add(dependency.getName());
        }
        return nameList.toArray(new String[nameList.size()]);
    }

    public static String[] getArrayOfVersions(Map<String, Dependency> dependencies) {
        LinkedList<String> versionList = new LinkedList<String>();
        for (Dependency dependency : dependencies.values()) {
            versionList.add(dependency.getVersion());
        }
        return versionList.toArray(new String[versionList.size()]);
    }

    public static Integer[] getArrayOfFlags(Map<String, Dependency> dependencies) {
        LinkedList<Integer> flagsList = new LinkedList<Integer>();
        for (Dependency dependency : dependencies.values()) {
            flagsList.add(dependency.getFlags());
        }
        return flagsList.toArray(new Integer[flagsList.size()]);
    }
}

