/*
 * Decompiled with CFR 0.152.
 */
package org.redline_rpm;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.Formatter;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.redline_rpm.header.AbstractHeader;
import org.redline_rpm.header.Header;
import org.redline_rpm.header.PayloadCompressionType;

public class Util {
    private static final int ARRAY_SIZE = 4096;

    private Util() {
    }

    public static int getTempArraySize(int totalSize) {
        return Math.min(4096, totalSize);
    }

    public static String normalizePath(String path) {
        return path.replace('\\', '/');
    }

    public static ByteBuffer fill(ReadableByteChannel in, int size) throws IOException {
        return Util.fill(in, ByteBuffer.allocate(size));
    }

    public static ByteBuffer fill(ReadableByteChannel in, ByteBuffer buffer) throws IOException {
        while (buffer.hasRemaining()) {
            if (in.read(buffer) != -1) continue;
            throw new BufferUnderflowException();
        }
        buffer.flip();
        return buffer;
    }

    public static void empty(WritableByteChannel out, ByteBuffer buffer) throws IOException {
        while (buffer.hasRemaining()) {
            out.write(buffer);
        }
    }

    public static void check(int expected, int actual) throws IOException {
        if (expected != actual) {
            throw new IOException("check expected " + Integer.toHexString(0xFF & expected) + ", found " + Integer.toHexString(0xFF & actual));
        }
    }

    public static void check(byte expected, byte actual) throws IOException {
        if (expected != actual) {
            throw new IOException("check expected " + Integer.toHexString(0xFF & expected) + ", found " + Integer.toHexString(0xFF & actual));
        }
    }

    public static int difference(int start, int boundary) {
        return boundary + 1 - (start & boundary) & boundary;
    }

    public static int round(int start, int boundary) {
        return start + boundary & ~boundary;
    }

    public static void pad(ByteBuffer buffer, int boundary) {
        buffer.position(Util.round(buffer.position(), boundary));
    }

    public static void dump(byte[] data) {
        Util.dump(data, (Appendable)System.out);
    }

    public static void dump(byte[] data, Appendable out) {
        Util.dump(ByteBuffer.wrap(data), out);
    }

    public static void dump(char[] data) {
        Util.dump(data, (Appendable)System.out);
    }

    public static void dump(CharSequence data) {
        Util.dump(Charset.forName("US-ASCII").encode(CharBuffer.wrap(data)), (Appendable)System.out);
    }

    public static void dump(char[] data, Appendable out) {
        Util.dump(Charset.forName("US-ASCII").encode(CharBuffer.wrap(data)), out);
    }

    public static void dump(ByteBuffer buf, Appendable out) {
        Formatter fmt = new Formatter(out);
        int pos = buf.position();
        fmt.format("%8x:", pos & 0xFFFFFFF0);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < (pos & 0xF); ++i) {
            fmt.format("   ", new Object[0]);
            builder.append(' ');
        }
        while (buf.hasRemaining()) {
            byte b = buf.get();
            fmt.format(" %2x", b);
            if (32 <= b && b < 127) {
                builder.append((char)b);
            } else {
                builder.append(' ');
            }
            if (!buf.hasRemaining() || (buf.position() & 0xF) != 0) continue;
            fmt.format(" %s\n%8x:", builder, buf.position());
            builder.setLength(0);
        }
        fmt.close();
        buf.position(pos);
    }

    public static String hex(byte[] data) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream printer = new PrintStream(baos);
        for (byte b : data) {
            printer.format("%02x", b);
        }
        printer.flush();
        return baos.toString();
    }

    public static InputStream openPayloadStream(Header header, InputStream rpmIS) throws IOException {
        AbstractHeader.Entry<?> pcEntry = header.getEntry(Header.HeaderTag.PAYLOADCOMPRESSOR);
        String[] pc = (String[])pcEntry.getValues();
        PayloadCompressionType pcType = PayloadCompressionType.valueOf(pc[0]);
        InputStream payloadIS = rpmIS;
        switch (pcType) {
            case none: {
                break;
            }
            case gzip: {
                payloadIS = new GZIPInputStream(rpmIS);
                break;
            }
            case bzip2: {
                try {
                    payloadIS = new BZip2CompressorInputStream(rpmIS);
                    break;
                }
                catch (Exception e) {
                    throw new IOException("Failed to load BZIP2 compression stream", e);
                }
            }
            case xz: {
                try {
                    payloadIS = new XZCompressorInputStream(rpmIS);
                    break;
                }
                catch (Exception e) {
                    throw new IOException("Failed to load XZ compression stream", e);
                }
            }
        }
        return payloadIS;
    }
}

