/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.stresstest;

import com.orientechnologies.orient.stresstest.OStressTester;
import com.orientechnologies.orient.stresstest.OStressTesterSettings;
import java.io.File;

public class ODatabaseIdentifier {
    private OStressTesterSettings settings;

    public ODatabaseIdentifier(OStressTesterSettings settings) {
        this.settings = settings;
    }

    public String getUrl() {
        switch (this.settings.mode) {
            case MEMORY: {
                return "memory:" + this.settings.dbName;
            }
            case REMOTE: {
                return "remote:" + this.settings.remoteIp + ":" + this.settings.remotePort + "/" + this.settings.dbName;
            }
            case DISTRIBUTED: {
                return null;
            }
        }
        String basePath = System.getProperty("java.io.tmpdir");
        if (this.settings.plocalPath != null) {
            basePath = this.settings.plocalPath;
        }
        if (!basePath.endsWith(File.separator)) {
            basePath = basePath + File.separator;
        }
        return "plocal:" + basePath + this.settings.dbName;
    }

    public OStressTester.OMode getMode() {
        return this.settings.mode;
    }

    public String getPassword() {
        return this.settings.rootPassword;
    }

    public void setPassword(String password) {
        this.settings.rootPassword = password;
    }

    public String getName() {
        return this.settings.dbName;
    }

    public String getRemoteIp() {
        return this.settings.remoteIp;
    }

    public int getRemotePort() {
        return this.settings.remotePort;
    }

    public String getPlocalPath() {
        return this.settings.plocalPath;
    }
}

