/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.script.plugin.internal;

import com.google.common.collect.ImmutableList;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.script.Script;
import org.sonatype.nexus.script.ScriptCreatedEvent;
import org.sonatype.nexus.script.ScriptDeletedEvent;
import org.sonatype.nexus.script.ScriptManager;
import org.sonatype.nexus.script.ScriptUpdatedEvent;
import org.sonatype.nexus.script.plugin.internal.ScriptStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
@Singleton
public class ScriptManagerImpl
extends StateGuardLifecycleSupport
implements ScriptManager,
GroovyObject {
    @Inject
    private EventManager eventManager;
    @Inject
    private ScriptStore scriptStore;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public ScriptManagerImpl() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Guarded(by={"STARTED"})
    public Iterable<Script> browse() {
        return ImmutableList.copyOf(this.scriptStore.list());
    }

    @Guarded(by={"STARTED"})
    public Script get(String name) {
        return this.scriptStore.get(name);
    }

    @Guarded(by={"STARTED"})
    public Script create(String name, String content, String type) {
        Script script = new Script(name, content, type);
        this.scriptStore.create(script);
        this.eventManager.post((Object)new ScriptCreatedEvent(script));
        return script;
    }

    @Guarded(by={"STARTED"})
    public Script update(String name, String content) {
        Script script = this.scriptStore.get(name);
        if (script == null) {
            return (Script)ScriptBytecodeAdapter.castToType(null, Script.class);
        }
        String string = content;
        script.setContent(string);
        this.scriptStore.update(script);
        this.eventManager.post((Object)new ScriptUpdatedEvent(script));
        return script;
    }

    @Guarded(by={"STARTED"})
    public void delete(String name) {
        Script script = this.scriptStore.get(name);
        if (script != null) {
            this.scriptStore.delete(script);
            this.eventManager.post((Object)new ScriptDeletedEvent(script));
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != ScriptManagerImpl.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public ScriptStore getScriptStore() {
        return this.scriptStore;
    }

    public void setScriptStore(ScriptStore scriptStore) {
        this.scriptStore = scriptStore;
    }
}

