/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.script.plugin.internal.orient;

import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;
import org.sonatype.nexus.script.Script;

@Named
@Singleton
public class ScriptEntityAdapter
extends IterableEntityAdapter<Script> {
    private static final String P_NAME = "name";
    private static final String P_CONTENT = "content";
    private static final String P_TYPE = "type";
    private static final String DB_CLASS = new OClassNameBuilder().type("script").build();
    private static final String I_NAME = new OIndexNameBuilder().type(DB_CLASS).property("name").build();

    public ScriptEntityAdapter() {
        super(DB_CLASS);
    }

    protected void defineType(OClass type) {
        type.createProperty(P_NAME, OType.STRING).setNotNull(true);
        type.createProperty(P_TYPE, OType.STRING).setNotNull(true);
        type.createProperty(P_CONTENT, OType.STRING).setNotNull(true);
        type.createIndex(I_NAME, OClass.INDEX_TYPE.UNIQUE, new String[]{P_NAME});
    }

    protected Script newEntity() {
        return new Script();
    }

    protected void readFields(ODocument document, Script entity) throws Exception {
        entity.setName((String)document.field(P_NAME, OType.STRING));
        entity.setType((String)document.field(P_TYPE, OType.STRING));
        entity.setContent((String)document.field(P_CONTENT, OType.STRING));
    }

    protected void writeFields(ODocument document, Script entity) throws Exception {
        document.field(P_NAME, (Object)entity.getName());
        document.field(P_TYPE, (Object)entity.getType());
        document.field(P_CONTENT, (Object)entity.getContent());
    }
}

