/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.script.plugin.internal.provisioning;

import com.google.common.base.Preconditions;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.maven.LayoutPolicy;
import org.sonatype.nexus.repository.maven.VersionPolicy;
import org.sonatype.nexus.repository.storage.WritePolicy;
import org.sonatype.nexus.script.plugin.RepositoryApi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
@Singleton
public class RepositoryApiImpl
implements RepositoryApi,
GroovyObject {
    @Inject
    private RepositoryManager repositoryManager;
    @Inject
    private BlobStoreManager blobStoreManager;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public RepositoryApiImpl() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Override
    @Nonnull
    public Configuration createHosted(String name, String recipeName, String blobStoreName, WritePolicy writePolicy, boolean strictContentTypeValidation) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkArgument((DefaultTypeTransformation.booleanUnbox((Object)recipeName) && recipeName.endsWith("-hosted") ? 1 : 0) != 0);
        Configuration configuration = new Configuration();
        String string = name;
        configuration.setRepositoryName(string);
        String string2 = recipeName;
        configuration.setRecipeName(string2);
        boolean bl = true;
        configuration.setOnline(bl);
        Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"storage", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"blobStoreName", blobStoreName, "writePolicy", writePolicy, "strictContentTypeValidation", strictContentTypeValidation})});
        configuration.setAttributes(map);
        return configuration;
    }

    @Override
    @Nonnull
    public Configuration createProxy(String name, String recipeName, String remoteUrl, String blobStoreName, boolean strictContentTypeValidation) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkArgument((DefaultTypeTransformation.booleanUnbox((Object)recipeName) && recipeName.endsWith("-proxy") ? 1 : 0) != 0);
        Configuration configuration = new Configuration();
        String string = name;
        configuration.setRepositoryName(string);
        String string2 = recipeName;
        configuration.setRecipeName(string2);
        boolean bl = true;
        configuration.setOnline(bl);
        Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"httpclient", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"connection", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"blocked", false, "autoBlock", true})}), "proxy", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"remoteUrl", remoteUrl, "contentMaxAge", 1440, "metadataMaxAge", 1440}), "negativeCache", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"enabled", true, "timeToLive", 1440}), "storage", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"blobStoreName", blobStoreName, "strictContentTypeValidation", strictContentTypeValidation})});
        configuration.setAttributes(map);
        return configuration;
    }

    @Override
    @Nonnull
    public Configuration createGroup(String name, String recipeName, String blobStoreName, String ... members) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkArgument((DefaultTypeTransformation.booleanUnbox((Object)recipeName) && recipeName.endsWith("-group") ? 1 : 0) != 0);
        Configuration configuration = new Configuration();
        String string = name;
        configuration.setRepositoryName(string);
        String string2 = recipeName;
        configuration.setRecipeName(string2);
        boolean bl = true;
        configuration.setOnline(bl);
        Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"group", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"memberNames", DefaultGroovyMethods.unique((List)DefaultGroovyMethods.toList((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)members, Object[].class))))}), "storage", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"blobStoreName", blobStoreName})});
        configuration.setAttributes(map);
        return configuration;
    }

    @Override
    @Nonnull
    public Repository createMavenHosted(String name, String blobStoreName, boolean strictContentTypeValidation, VersionPolicy versionPolicy, WritePolicy writePolicy, LayoutPolicy layoutPolicy) {
        Configuration configuration = this.createHosted(name, "maven2-hosted", blobStoreName, writePolicy, strictContentTypeValidation);
        Map map = RepositoryApiImpl.configureMaven(versionPolicy, layoutPolicy);
        ScriptBytecodeAdapter.setProperty((Object)map, null, (Object)configuration.getAttributes(), (String)"maven");
        return this.createRepository(configuration);
    }

    @Override
    @Nonnull
    public Repository createMavenProxy(String name, String remoteUrl, String blobStoreName, boolean strictContentTypeValidation, VersionPolicy versionPolicy, LayoutPolicy layoutPolicy) {
        Configuration configuration = this.createProxy(name, "maven2-proxy", remoteUrl, blobStoreName, strictContentTypeValidation);
        Map map = RepositoryApiImpl.configureMaven(versionPolicy, layoutPolicy);
        ScriptBytecodeAdapter.setProperty((Object)map, null, (Object)configuration.getAttributes(), (String)"maven");
        return this.createRepository(configuration);
    }

    @Override
    @Nonnull
    public Repository createMavenGroup(String name, List<String> members, String blobStoreName) {
        Configuration configuration = this.createGroup(name, "maven2-group", blobStoreName, (String[])ScriptBytecodeAdapter.asType(members, String[].class));
        Map map = RepositoryApiImpl.configureMaven();
        ScriptBytecodeAdapter.setProperty((Object)map, null, (Object)configuration.getAttributes(), (String)"maven");
        return this.createRepository(configuration);
    }

    @Override
    @Nonnull
    public Repository createNpmHosted(String name, String blobStoreName, boolean strictContentTypeValidation, WritePolicy writePolicy) {
        return this.createRepository(this.createHosted(name, "npm-hosted", blobStoreName, writePolicy, strictContentTypeValidation));
    }

    @Override
    @Nonnull
    public Repository createNpmProxy(String name, String remoteUrl, String blobStoreName, boolean strictContentTypeValidation) {
        return this.createRepository(this.createProxy(name, "npm-proxy", remoteUrl, blobStoreName, strictContentTypeValidation));
    }

    @Override
    @Nonnull
    public Repository createNpmGroup(String name, List<String> members, String blobStoreName) {
        return this.createRepository(this.createGroup(name, "npm-group", blobStoreName, (String[])ScriptBytecodeAdapter.asType(members, String[].class)));
    }

    @Override
    @Nonnull
    public Repository createNugetHosted(String name, String blobStoreName, boolean strictContentTypeValidation, WritePolicy writePolicy) {
        return this.createRepository(this.createHosted(name, "nuget-hosted", blobStoreName, writePolicy, strictContentTypeValidation));
    }

    @Override
    @Nonnull
    public Repository createNugetProxy(String name, String remoteUrl, String blobStoreName, boolean strictContentTypeValidation) {
        return this.createRepository(this.createProxy(name, "nuget-proxy", remoteUrl, blobStoreName, strictContentTypeValidation));
    }

    @Override
    @Nonnull
    public Repository createNugetGroup(String name, List<String> members, String blobStoreName) {
        return this.createRepository(this.createGroup(name, "nuget-group", blobStoreName, (String[])ScriptBytecodeAdapter.asType(members, String[].class)));
    }

    @Override
    @Nonnull
    public Repository createRawHosted(String name, String blobStoreName, boolean strictContentTypeValidation, WritePolicy writePolicy) {
        return this.createRepository(this.createHosted(name, "raw-hosted", blobStoreName, writePolicy, strictContentTypeValidation));
    }

    @Override
    @Nonnull
    public Repository createRawProxy(String name, String remoteUrl, String blobStoreName, boolean strictContentTypeValidation) {
        return this.createRepository(this.createProxy(name, "raw-proxy", remoteUrl, blobStoreName, strictContentTypeValidation));
    }

    @Override
    @Nonnull
    public Repository createRawGroup(String name, List<String> members, String blobStoreName) {
        return this.createRepository(this.createGroup(name, "raw-group", blobStoreName, (String[])ScriptBytecodeAdapter.asType(members, String[].class)));
    }

    @Override
    @Nonnull
    public Repository createDockerHosted(String name, @Nullable Integer httpPort, @Nullable Integer httpsPort, String blobStoreName, boolean strictContentTypeValidation, boolean v1Enabled, WritePolicy writePolicy, boolean forceBasicAuth) {
        Configuration configuration = this.createHosted(name, "docker-hosted", blobStoreName, writePolicy, strictContentTypeValidation);
        Map map = RepositoryApiImpl.configureDockerAttributes(httpPort, httpsPort, v1Enabled, forceBasicAuth);
        ScriptBytecodeAdapter.setProperty((Object)map, null, (Object)configuration.getAttributes(), (String)"docker");
        return this.createRepository(configuration);
    }

    @Nonnull
    public Repository createDockerProxy(String name, String remoteUrl, String indexType, @Nullable String indexUrl, @Nullable Integer httpPort, @Nullable Integer httpsPort, String blobStoreName, boolean strictContentTypeValidation, boolean v1Enabled, boolean forceBasicAuth) {
        CallSite[] callSiteArray = RepositoryApiImpl.$getCallSiteArray();
        Configuration configuration = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[0].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)name, (Object)"docker-proxy", (Object)remoteUrl, (Object)blobStoreName, (Object)strictContentTypeValidation));
            configuration = (Configuration)ScriptBytecodeAdapter.castToType((Object)object, Configuration.class);
        } else {
            Configuration configuration2;
            configuration = configuration2 = this.createProxy(name, "docker-proxy", remoteUrl, blobStoreName, strictContentTypeValidation);
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[1].callStatic(RepositoryApiImpl.class, (Object)httpPort, (Object)httpsPort, (Object)v1Enabled, (Object)forceBasicAuth);
            ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)callSiteArray[2].callGetProperty((Object)configuration), (String)"docker");
        } else {
            Map map = RepositoryApiImpl.configureDockerAttributes(httpPort, httpsPort, v1Enabled, forceBasicAuth);
            ScriptBytecodeAdapter.setProperty((Object)map, null, (Object)callSiteArray[3].callGetProperty((Object)configuration), (String)"docker");
        }
        Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"indexType", indexType, "indexUrl", indexUrl});
        ScriptBytecodeAdapter.setProperty((Object)map, null, (Object)callSiteArray[4].callGetProperty((Object)configuration), (String)"dockerProxy");
        boolean bl = true;
        ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)callSiteArray[5].callGetProperty(callSiteArray[6].callGetProperty(callSiteArray[7].callGetProperty((Object)configuration))), (String)"useTrustStore");
        return (Repository)ScriptBytecodeAdapter.castToType((Object)callSiteArray[8].callCurrent((GroovyObject)this, (Object)configuration), Repository.class);
    }

    @Nonnull
    public Repository createDockerGroup(String name, @Nullable Integer httpPort, @Nullable Integer httpsPort, List<String> members, boolean v1Enabled, String blobStoreName, boolean forceBasicAuth) {
        Configuration configuration = this.createGroup(name, "docker-group", blobStoreName, (String[])ScriptBytecodeAdapter.asType(members, String[].class));
        Map map = RepositoryApiImpl.configureDockerAttributes(httpPort, httpsPort, v1Enabled, forceBasicAuth);
        ScriptBytecodeAdapter.setProperty((Object)map, null, (Object)configuration.getAttributes(), (String)"docker");
        return this.createRepository(configuration);
    }

    @Override
    @Nonnull
    public Repository createBowerHosted(String name, String blobStoreName, boolean strictContentTypeValidation, WritePolicy writePolicy) {
        return this.createRepository(this.createHosted(name, "bower-hosted", blobStoreName, writePolicy, strictContentTypeValidation));
    }

    @Override
    @Nonnull
    public Repository createBowerProxy(String name, String remoteUrl, String blobStoreName, boolean strictContentTypeValidation, boolean rewritePackageUrls) {
        Configuration configuration = this.createProxy(name, "bower-proxy", remoteUrl, blobStoreName, strictContentTypeValidation);
        Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"rewritePackageUrls", rewritePackageUrls});
        ScriptBytecodeAdapter.setProperty((Object)map, null, (Object)configuration.getAttributes(), (String)"bower");
        return this.createRepository(configuration);
    }

    @Override
    @Nonnull
    public Repository createBowerGroup(String name, List<String> members, String blobStoreName) {
        return this.createRepository(this.createGroup(name, "bower-group", blobStoreName, (String[])ScriptBytecodeAdapter.asType(members, String[].class)));
    }

    @Override
    @Nonnull
    public Repository createPyPiHosted(String name, String blobStoreName, boolean strictContentTypeValidation, WritePolicy writePolicy) {
        return this.createRepository(this.createHosted(name, "pypi-hosted", blobStoreName, writePolicy, strictContentTypeValidation));
    }

    @Override
    @Nonnull
    public Repository createPyPiProxy(String name, String remoteUrl, String blobStoreName, boolean strictContentTypeValidation) {
        return this.createRepository(this.createProxy(name, "pypi-proxy", remoteUrl, blobStoreName, strictContentTypeValidation));
    }

    @Override
    @Nonnull
    public Repository createPyPiGroup(String name, List<String> members, String blobStoreName) {
        return this.createRepository(this.createGroup(name, "pypi-group", blobStoreName, (String[])ScriptBytecodeAdapter.asType(members, String[].class)));
    }

    @Override
    @Nonnull
    public Repository createRubygemsHosted(String name, String blobStoreName, boolean strictContentTypeValidation, WritePolicy writePolicy) {
        return this.createRepository(this.createHosted(name, "rubygems-hosted", blobStoreName, writePolicy, strictContentTypeValidation));
    }

    @Override
    @Nonnull
    public Repository createRubygemsProxy(String name, String remoteUrl, String blobStoreName, boolean strictContentTypeValidation) {
        return this.createRepository(this.createProxy(name, "rubygems-proxy", remoteUrl, blobStoreName, strictContentTypeValidation));
    }

    @Override
    @Nonnull
    public Repository createRubygemsGroup(String name, List<String> members, String blobStoreName) {
        return this.createRepository(this.createGroup(name, "rubygems-group", blobStoreName, (String[])ScriptBytecodeAdapter.asType(members, String[].class)));
    }

    @Override
    @Nonnull
    public Repository createYumHosted(String name, String blobStoreName, boolean strictContentTypeValidation, WritePolicy writePolicy, int depth) {
        Configuration configuration = this.createHosted(name, "yum-hosted", blobStoreName, writePolicy, strictContentTypeValidation);
        Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"repodataDepth", depth});
        ScriptBytecodeAdapter.setProperty((Object)map, null, (Object)configuration.getAttributes(), (String)"yum");
        return this.createRepository(configuration);
    }

    @Override
    @Nonnull
    public Repository createYumProxy(String name, String remoteUrl, String blobStoreName, boolean strictContentTypeValidation) {
        return this.createRepository(this.createProxy(name, "yum-proxy", remoteUrl, blobStoreName, strictContentTypeValidation));
    }

    @Nonnull
    public Repository createYumGroup(String name, List<String> members, String blobStoreName) {
        return this.createRepository(this.createGroup(name, "yum-group", blobStoreName, (String[])ScriptBytecodeAdapter.asType(members, String[].class)));
    }

    @Override
    @Nonnull
    public Repository createGitLfsHosted(String name, String blobStoreName, boolean strictContentTypeValidation, WritePolicy writePolicy) {
        return this.createRepository(this.createHosted(name, "gitlfs-hosted", blobStoreName, writePolicy, strictContentTypeValidation));
    }

    private static Map configureMaven(VersionPolicy versionPolicy, LayoutPolicy layoutPolicy) {
        return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"versionPolicy", versionPolicy, "layoutPolicy", layoutPolicy});
    }

    private static Map configureDockerAttributes(Integer httpPort, Integer httpsPort, boolean v1Enabled, boolean forceBasicAuth) {
        LinkedHashMap docker = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)httpPort)) {
            Integer n = httpPort;
            ScriptBytecodeAdapter.setProperty((Object)n, null, (Object)docker, (String)"httpPort");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)httpsPort)) {
            Integer n = httpsPort;
            ScriptBytecodeAdapter.setProperty((Object)n, null, (Object)docker, (String)"httpsPort");
        }
        boolean bl = v1Enabled;
        ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)docker, (String)"v1Enabled");
        boolean bl2 = forceBasicAuth;
        ScriptBytecodeAdapter.setProperty((Object)bl2, null, (Object)docker, (String)"forceBasicAuth");
        return docker;
    }

    public Repository createRepository(Configuration configuration) {
        this.validateBlobStore(configuration);
        this.validateGroupMembers(configuration);
        return this.repositoryManager.create(configuration);
    }

    public void validateGroupMembers(Configuration configuration) {
        CallSite[] callSiteArray = RepositoryApiImpl.$getCallSiteArray();
        Collection members = (Collection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[9].callGetPropertySafe(callSiteArray[10].callGetProperty(callSiteArray[11].callGetProperty((Object)configuration))), Collection.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)members)) {
            Reference existingRepos = new Reference(callSiteArray[12].call(callSiteArray[13].call((Object)this.repositoryManager), (Object)new GeneratedClosure(this, this){
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;
                {
                    CallSite[] callSiteArray = _validateGroupMembers_closure1.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Repository repository) {
                    CallSite[] callSiteArray = _validateGroupMembers_closure1.$getCallSiteArray();
                    return callSiteArray[0].callGetProperty((Object)repository);
                }

                public Object call(Repository repository) {
                    CallSite[] callSiteArray = _validateGroupMembers_closure1.$getCallSiteArray();
                    return callSiteArray[1].callCurrent((GroovyObject)this, (Object)repository);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _validateGroupMembers_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "name";
                    stringArray[1] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[2];
                    _validateGroupMembers_closure1.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_validateGroupMembers_closure1.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _validateGroupMembers_closure1.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }));
            boolean valid = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[14].call((Object)members, (Object)new GeneratedClosure(this, this, existingRepos){
                private /* synthetic */ Reference existingRepos;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;
                {
                    Reference reference;
                    CallSite[] callSiteArray = _validateGroupMembers_closure2.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.existingRepos = reference = existingRepos;
                }

                public Object doCall(String memberName) {
                    CallSite[] callSiteArray = _validateGroupMembers_closure2.$getCallSiteArray();
                    return callSiteArray[0].call(this.existingRepos.get(), (Object)memberName);
                }

                public Object call(String memberName) {
                    CallSite[] callSiteArray = _validateGroupMembers_closure2.$getCallSiteArray();
                    if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                        return callSiteArray[1].callCurrent((GroovyObject)this, (Object)memberName);
                    }
                    return this.doCall(memberName);
                }

                public Object getExistingRepos() {
                    CallSite[] callSiteArray = _validateGroupMembers_closure2.$getCallSiteArray();
                    return this.existingRepos.get();
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _validateGroupMembers_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "contains";
                    stringArray[1] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[2];
                    _validateGroupMembers_closure2.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_validateGroupMembers_closure2.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _validateGroupMembers_closure2.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }));
            if (!valid) {
                throw (Throwable)callSiteArray[15].callConstructor(IllegalStateException.class, (Object)"One or more of the specified group memberNames does not actually exist");
            }
        }
    }

    public void validateBlobStore(Configuration configuration) {
        CallSite[] callSiteArray = RepositoryApiImpl.$getCallSiteArray();
        Reference name = new Reference(callSiteArray[16].callGetPropertySafe(callSiteArray[17].callGetProperty(callSiteArray[18].callGetProperty((Object)configuration))));
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[19].call(callSiteArray[20].call((Object)this.blobStoreManager), (Object)new GeneratedClosure(this, this, name){
            private /* synthetic */ Reference name;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                CallSite[] callSiteArray = _validateBlobStore_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.name = reference = name;
            }

            public Object doCall(BlobStore blobStore) {
                CallSite[] callSiteArray = _validateBlobStore_closure3.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(callSiteArray[1].callGetProperty((Object)blobStore)), (Object)this.name.get());
            }

            public Object call(BlobStore blobStore) {
                CallSite[] callSiteArray = _validateBlobStore_closure3.$getCallSiteArray();
                return callSiteArray[2].callCurrent((GroovyObject)this, (Object)blobStore);
            }

            public Object getName() {
                CallSite[] callSiteArray = _validateBlobStore_closure3.$getCallSiteArray();
                return this.name.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _validateBlobStore_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "name";
                stringArray[1] = "blobStoreConfiguration";
                stringArray[2] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _validateBlobStore_closure3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_validateBlobStore_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _validateBlobStore_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }))) {
            throw (Throwable)callSiteArray[21].callConstructor(IllegalArgumentException.class, (Object)new GStringImpl(new Object[]{name.get()}, new String[]{"No blobStore found with name ", ""}));
        }
    }

    @Nonnull
    public Configuration createHosted(String name, String recipeName, String blobStoreName, WritePolicy writePolicy) {
        return this.createHosted(name, recipeName, blobStoreName, writePolicy, true);
    }

    @Nonnull
    public Configuration createHosted(String name, String recipeName, String blobStoreName) {
        return this.createHosted(name, recipeName, blobStoreName, WritePolicy.ALLOW, true);
    }

    @Nonnull
    public Configuration createHosted(String name, String recipeName) {
        return this.createHosted(name, recipeName, BlobStoreManager.DEFAULT_BLOBSTORE_NAME, WritePolicy.ALLOW, true);
    }

    @Nonnull
    public Configuration createProxy(String name, String recipeName, String remoteUrl, String blobStoreName) {
        return this.createProxy(name, recipeName, remoteUrl, blobStoreName, true);
    }

    @Nonnull
    public Configuration createProxy(String name, String recipeName, String remoteUrl) {
        return this.createProxy(name, recipeName, remoteUrl, BlobStoreManager.DEFAULT_BLOBSTORE_NAME, true);
    }

    @Nonnull
    public Configuration createGroup(String name, String recipeName, String ... members) {
        return this.createGroup(name, recipeName, BlobStoreManager.DEFAULT_BLOBSTORE_NAME, members);
    }

    @Nonnull
    public Repository createMavenHosted(String name, String blobStoreName, boolean strictContentTypeValidation, VersionPolicy versionPolicy, WritePolicy writePolicy) {
        return this.createMavenHosted(name, blobStoreName, strictContentTypeValidation, versionPolicy, writePolicy, LayoutPolicy.STRICT);
    }

    @Nonnull
    public Repository createMavenHosted(String name, String blobStoreName, boolean strictContentTypeValidation, VersionPolicy versionPolicy) {
        return this.createMavenHosted(name, blobStoreName, strictContentTypeValidation, versionPolicy, WritePolicy.ALLOW_ONCE, LayoutPolicy.STRICT);
    }

    @Nonnull
    public Repository createMavenHosted(String name, String blobStoreName, boolean strictContentTypeValidation) {
        return this.createMavenHosted(name, blobStoreName, strictContentTypeValidation, VersionPolicy.RELEASE, WritePolicy.ALLOW_ONCE, LayoutPolicy.STRICT);
    }

    @Nonnull
    public Repository createMavenHosted(String name, String blobStoreName) {
        return this.createMavenHosted(name, blobStoreName, true, VersionPolicy.RELEASE, WritePolicy.ALLOW_ONCE, LayoutPolicy.STRICT);
    }

    @Nonnull
    public Repository createMavenHosted(String name) {
        return this.createMavenHosted(name, BlobStoreManager.DEFAULT_BLOBSTORE_NAME, true, VersionPolicy.RELEASE, WritePolicy.ALLOW_ONCE, LayoutPolicy.STRICT);
    }

    @Nonnull
    public Repository createMavenProxy(String name, String remoteUrl, String blobStoreName, boolean strictContentTypeValidation, VersionPolicy versionPolicy) {
        return this.createMavenProxy(name, remoteUrl, blobStoreName, strictContentTypeValidation, versionPolicy, LayoutPolicy.STRICT);
    }

    @Nonnull
    public Repository createMavenProxy(String name, String remoteUrl, String blobStoreName, boolean strictContentTypeValidation) {
        return this.createMavenProxy(name, remoteUrl, blobStoreName, strictContentTypeValidation, VersionPolicy.RELEASE, LayoutPolicy.STRICT);
    }

    @Nonnull
    public Repository createMavenProxy(String name, String remoteUrl, String blobStoreName) {
        return this.createMavenProxy(name, remoteUrl, blobStoreName, true, VersionPolicy.RELEASE, LayoutPolicy.STRICT);
    }

    @Nonnull
    public Repository createMavenProxy(String name, String remoteUrl) {
        return this.createMavenProxy(name, remoteUrl, BlobStoreManager.DEFAULT_BLOBSTORE_NAME, true, VersionPolicy.RELEASE, LayoutPolicy.STRICT);
    }

    @Nonnull
    public Repository createMavenGroup(String name, List<String> members) {
        return this.createMavenGroup(name, members, BlobStoreManager.DEFAULT_BLOBSTORE_NAME);
    }

    @Nonnull
    public Repository createNpmHosted(String name, String blobStoreName, boolean strictContentTypeValidation) {
        return this.createNpmHosted(name, blobStoreName, strictContentTypeValidation, WritePolicy.ALLOW);
    }

    @Nonnull
    public Repository createNpmHosted(String name, String blobStoreName) {
        return this.createNpmHosted(name, blobStoreName, true, WritePolicy.ALLOW);
    }

    @Nonnull
    public Repository createNpmHosted(String name) {
        return this.createNpmHosted(name, BlobStoreManager.DEFAULT_BLOBSTORE_NAME, true, WritePolicy.ALLOW);
    }

    @Nonnull
    public Repository createNpmProxy(String name, String remoteUrl, String blobStoreName) {
        return this.createNpmProxy(name, remoteUrl, blobStoreName, true);
    }

    @Nonnull
    public Repository createNpmProxy(String name, String remoteUrl) {
        return this.createNpmProxy(name, remoteUrl, BlobStoreManager.DEFAULT_BLOBSTORE_NAME, true);
    }

    @Nonnull
    public Repository createNpmGroup(String name, List<String> members) {
        return this.createNpmGroup(name, members, BlobStoreManager.DEFAULT_BLOBSTORE_NAME);
    }

    @Nonnull
    public Repository createNugetHosted(String name, String blobStoreName, boolean strictContentTypeValidation) {
        return this.createNugetHosted(name, blobStoreName, strictContentTypeValidation, WritePolicy.ALLOW);
    }

    @Nonnull
    public Repository createNugetHosted(String name, String blobStoreName) {
        return this.createNugetHosted(name, blobStoreName, true, WritePolicy.ALLOW);
    }

    @Nonnull
    public Repository createNugetHosted(String name) {
        return this.createNugetHosted(name, BlobStoreManager.DEFAULT_BLOBSTORE_NAME, true, WritePolicy.ALLOW);
    }

    @Nonnull
    public Repository createNugetProxy(String name, String remoteUrl, String blobStoreName) {
        return this.createNugetProxy(name, remoteUrl, blobStoreName, true);
    }

    @Nonnull
    public Repository createNugetProxy(String name, String remoteUrl) {
        return this.createNugetProxy(name, remoteUrl, BlobStoreManager.DEFAULT_BLOBSTORE_NAME, true);
    }

    @Nonnull
    public Repository createNugetGroup(String name, List<String> members) {
        return this.createNugetGroup(name, members, BlobStoreManager.DEFAULT_BLOBSTORE_NAME);
    }

    @Nonnull
    public Repository createRawHosted(String name, String blobStoreName, boolean strictContentTypeValidation) {
        return this.createRawHosted(name, blobStoreName, strictContentTypeValidation, WritePolicy.ALLOW);
    }

    @Nonnull
    public Repository createRawHosted(String name, String blobStoreName) {
        return this.createRawHosted(name, blobStoreName, false, WritePolicy.ALLOW);
    }

    @Nonnull
    public Repository createRawHosted(String name) {
        return this.createRawHosted(name, BlobStoreManager.DEFAULT_BLOBSTORE_NAME, false, WritePolicy.ALLOW);
    }

    @Nonnull
    public Repository createRawProxy(String name, String remoteUrl, String blobStoreName) {
        return this.createRawProxy(name, remoteUrl, blobStoreName, true);
    }

    @Nonnull
    public Repository createRawProxy(String name, String remoteUrl) {
        return this.createRawProxy(name, remoteUrl, BlobStoreManager.DEFAULT_BLOBSTORE_NAME, true);
    }

    @Nonnull
    public Repository createRawGroup(String name, List<String> members) {
        return this.createRawGroup(name, members, BlobStoreManager.DEFAULT_BLOBSTORE_NAME);
    }

    @Override
    @Nonnull
    public Repository createDockerHosted(String name, @Nullable Integer httpPort, @Nullable Integer httpsPort, String blobStoreName, boolean strictContentTypeValidation, boolean v1Enabled, WritePolicy writePolicy) {
        return this.createDockerHosted(name, httpPort, httpsPort, blobStoreName, strictContentTypeValidation, v1Enabled, writePolicy, true);
    }

    @Nonnull
    public Repository createDockerHosted(String name, @Nullable Integer httpPort, @Nullable Integer httpsPort, String blobStoreName, boolean strictContentTypeValidation, boolean v1Enabled) {
        return this.createDockerHosted(name, httpPort, httpsPort, blobStoreName, strictContentTypeValidation, v1Enabled, WritePolicy.ALLOW, true);
    }

    @Nonnull
    public Repository createDockerHosted(String name, @Nullable Integer httpPort, @Nullable Integer httpsPort, String blobStoreName, boolean strictContentTypeValidation) {
        return this.createDockerHosted(name, httpPort, httpsPort, blobStoreName, strictContentTypeValidation, true, WritePolicy.ALLOW, true);
    }

    @Nonnull
    public Repository createDockerHosted(String name, @Nullable Integer httpPort, @Nullable Integer httpsPort, String blobStoreName) {
        return this.createDockerHosted(name, httpPort, httpsPort, blobStoreName, true, true, WritePolicy.ALLOW, true);
    }

    @Nonnull
    public Repository createDockerHosted(String name, @Nullable Integer httpPort, @Nullable Integer httpsPort) {
        return this.createDockerHosted(name, httpPort, httpsPort, BlobStoreManager.DEFAULT_BLOBSTORE_NAME, true, true, WritePolicy.ALLOW, true);
    }

    @Override
    @Nonnull
    public Repository createDockerProxy(String name, String remoteUrl, String indexType, @Nullable String indexUrl, @Nullable Integer httpPort, @Nullable Integer httpsPort, String blobStoreName, boolean strictContentTypeValidation, boolean v1Enabled) {
        return this.createDockerProxy(name, remoteUrl, indexType, indexUrl, httpPort, httpsPort, blobStoreName, strictContentTypeValidation, v1Enabled, true);
    }

    @Nonnull
    public Repository createDockerProxy(String name, String remoteUrl, String indexType, @Nullable String indexUrl, @Nullable Integer httpPort, @Nullable Integer httpsPort, String blobStoreName, boolean strictContentTypeValidation) {
        return this.createDockerProxy(name, remoteUrl, indexType, indexUrl, httpPort, httpsPort, blobStoreName, strictContentTypeValidation, true, true);
    }

    @Nonnull
    public Repository createDockerProxy(String name, String remoteUrl, String indexType, @Nullable String indexUrl, @Nullable Integer httpPort, @Nullable Integer httpsPort, String blobStoreName) {
        return this.createDockerProxy(name, remoteUrl, indexType, indexUrl, httpPort, httpsPort, blobStoreName, true, true, true);
    }

    @Nonnull
    public Repository createDockerProxy(String name, String remoteUrl, String indexType, @Nullable String indexUrl, @Nullable Integer httpPort, @Nullable Integer httpsPort) {
        return this.createDockerProxy(name, remoteUrl, indexType, indexUrl, httpPort, httpsPort, BlobStoreManager.DEFAULT_BLOBSTORE_NAME, true, true, true);
    }

    @Override
    @Nonnull
    public Repository createDockerGroup(String name, @Nullable Integer httpPort, @Nullable Integer httpsPort, List<String> members, boolean v1Enabled, String blobStoreName) {
        return this.createDockerGroup(name, httpPort, httpsPort, members, v1Enabled, blobStoreName, true);
    }

    @Nonnull
    public Repository createDockerGroup(String name, @Nullable Integer httpPort, @Nullable Integer httpsPort, List<String> members, boolean v1Enabled) {
        return this.createDockerGroup(name, httpPort, httpsPort, members, v1Enabled, BlobStoreManager.DEFAULT_BLOBSTORE_NAME, true);
    }

    @Nonnull
    public Repository createDockerGroup(String name, @Nullable Integer httpPort, @Nullable Integer httpsPort, List<String> members) {
        return this.createDockerGroup(name, httpPort, httpsPort, members, true, BlobStoreManager.DEFAULT_BLOBSTORE_NAME, true);
    }

    @Nonnull
    public Repository createBowerHosted(String name, String blobStoreName, boolean strictContentTypeValidation) {
        return this.createBowerHosted(name, blobStoreName, strictContentTypeValidation, WritePolicy.ALLOW);
    }

    @Nonnull
    public Repository createBowerHosted(String name, String blobStoreName) {
        return this.createBowerHosted(name, blobStoreName, true, WritePolicy.ALLOW);
    }

    @Nonnull
    public Repository createBowerHosted(String name) {
        return this.createBowerHosted(name, BlobStoreManager.DEFAULT_BLOBSTORE_NAME, true, WritePolicy.ALLOW);
    }

    @Nonnull
    public Repository createBowerProxy(String name, String remoteUrl, String blobStoreName, boolean strictContentTypeValidation) {
        return this.createBowerProxy(name, remoteUrl, blobStoreName, strictContentTypeValidation, true);
    }

    @Nonnull
    public Repository createBowerProxy(String name, String remoteUrl, String blobStoreName) {
        return this.createBowerProxy(name, remoteUrl, blobStoreName, true, true);
    }

    @Nonnull
    public Repository createBowerProxy(String name, String remoteUrl) {
        return this.createBowerProxy(name, remoteUrl, BlobStoreManager.DEFAULT_BLOBSTORE_NAME, true, true);
    }

    @Nonnull
    public Repository createBowerGroup(String name, List<String> members) {
        return this.createBowerGroup(name, members, BlobStoreManager.DEFAULT_BLOBSTORE_NAME);
    }

    @Nonnull
    public Repository createPyPiHosted(String name, String blobStoreName, boolean strictContentTypeValidation) {
        return this.createPyPiHosted(name, blobStoreName, strictContentTypeValidation, WritePolicy.ALLOW);
    }

    @Nonnull
    public Repository createPyPiHosted(String name, String blobStoreName) {
        return this.createPyPiHosted(name, blobStoreName, true, WritePolicy.ALLOW);
    }

    @Nonnull
    public Repository createPyPiHosted(String name) {
        return this.createPyPiHosted(name, BlobStoreManager.DEFAULT_BLOBSTORE_NAME, true, WritePolicy.ALLOW);
    }

    @Nonnull
    public Repository createPyPiProxy(String name, String remoteUrl, String blobStoreName) {
        return this.createPyPiProxy(name, remoteUrl, blobStoreName, true);
    }

    @Nonnull
    public Repository createPyPiProxy(String name, String remoteUrl) {
        return this.createPyPiProxy(name, remoteUrl, BlobStoreManager.DEFAULT_BLOBSTORE_NAME, true);
    }

    @Nonnull
    public Repository createPyPiGroup(String name, List<String> members) {
        return this.createPyPiGroup(name, members, BlobStoreManager.DEFAULT_BLOBSTORE_NAME);
    }

    @Nonnull
    public Repository createRubygemsHosted(String name, String blobStoreName, boolean strictContentTypeValidation) {
        return this.createRubygemsHosted(name, blobStoreName, strictContentTypeValidation, WritePolicy.ALLOW);
    }

    @Nonnull
    public Repository createRubygemsHosted(String name, String blobStoreName) {
        return this.createRubygemsHosted(name, blobStoreName, true, WritePolicy.ALLOW);
    }

    @Nonnull
    public Repository createRubygemsHosted(String name) {
        return this.createRubygemsHosted(name, BlobStoreManager.DEFAULT_BLOBSTORE_NAME, true, WritePolicy.ALLOW);
    }

    @Nonnull
    public Repository createRubygemsProxy(String name, String remoteUrl, String blobStoreName) {
        return this.createRubygemsProxy(name, remoteUrl, blobStoreName, true);
    }

    @Nonnull
    public Repository createRubygemsProxy(String name, String remoteUrl) {
        return this.createRubygemsProxy(name, remoteUrl, BlobStoreManager.DEFAULT_BLOBSTORE_NAME, true);
    }

    @Nonnull
    public Repository createRubygemsGroup(String name, List<String> members) {
        return this.createRubygemsGroup(name, members, BlobStoreManager.DEFAULT_BLOBSTORE_NAME);
    }

    @Nonnull
    public Repository createYumHosted(String name, String blobStoreName, boolean strictContentTypeValidation, WritePolicy writePolicy) {
        return this.createYumHosted(name, blobStoreName, strictContentTypeValidation, writePolicy, 0);
    }

    @Nonnull
    public Repository createYumHosted(String name, String blobStoreName, boolean strictContentTypeValidation) {
        return this.createYumHosted(name, blobStoreName, strictContentTypeValidation, WritePolicy.ALLOW, 0);
    }

    @Nonnull
    public Repository createYumHosted(String name, String blobStoreName) {
        return this.createYumHosted(name, blobStoreName, true, WritePolicy.ALLOW, 0);
    }

    @Nonnull
    public Repository createYumHosted(String name) {
        return this.createYumHosted(name, BlobStoreManager.DEFAULT_BLOBSTORE_NAME, true, WritePolicy.ALLOW, 0);
    }

    @Nonnull
    public Repository createYumProxy(String name, String remoteUrl, String blobStoreName) {
        return this.createYumProxy(name, remoteUrl, blobStoreName, true);
    }

    @Nonnull
    public Repository createYumProxy(String name, String remoteUrl) {
        return this.createYumProxy(name, remoteUrl, BlobStoreManager.DEFAULT_BLOBSTORE_NAME, true);
    }

    @Nonnull
    public Repository createYumGroup(String name, List<String> members) {
        return this.createYumGroup(name, members, BlobStoreManager.DEFAULT_BLOBSTORE_NAME);
    }

    @Nonnull
    public Repository createGitLfsHosted(String name, String blobStoreName, boolean strictContentTypeValidation) {
        return this.createGitLfsHosted(name, blobStoreName, strictContentTypeValidation, WritePolicy.ALLOW);
    }

    @Nonnull
    public Repository createGitLfsHosted(String name, String blobStoreName) {
        return this.createGitLfsHosted(name, blobStoreName, true, WritePolicy.ALLOW);
    }

    @Nonnull
    public Repository createGitLfsHosted(String name) {
        return this.createGitLfsHosted(name, BlobStoreManager.DEFAULT_BLOBSTORE_NAME, true, WritePolicy.ALLOW);
    }

    private static Map configureMaven(VersionPolicy versionPolicy) {
        return RepositoryApiImpl.configureMaven(versionPolicy, LayoutPolicy.STRICT);
    }

    private static Map configureMaven() {
        return RepositoryApiImpl.configureMaven(VersionPolicy.MIXED, LayoutPolicy.STRICT);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != RepositoryApiImpl.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public RepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    public void setRepositoryManager(RepositoryManager repositoryManager) {
        this.repositoryManager = repositoryManager;
    }

    public BlobStoreManager getBlobStoreManager() {
        return this.blobStoreManager;
    }

    public void setBlobStoreManager(BlobStoreManager blobStoreManager) {
        this.blobStoreManager = blobStoreManager;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "createProxy";
        stringArray[1] = "configureDockerAttributes";
        stringArray[2] = "attributes";
        stringArray[3] = "attributes";
        stringArray[4] = "attributes";
        stringArray[5] = "connection";
        stringArray[6] = "httpclient";
        stringArray[7] = "attributes";
        stringArray[8] = "createRepository";
        stringArray[9] = "memberNames";
        stringArray[10] = "group";
        stringArray[11] = "attributes";
        stringArray[12] = "collect";
        stringArray[13] = "browse";
        stringArray[14] = "every";
        stringArray[15] = "<$constructor$>";
        stringArray[16] = "blobStoreName";
        stringArray[17] = "storage";
        stringArray[18] = "attributes";
        stringArray[19] = "any";
        stringArray[20] = "browse";
        stringArray[21] = "<$constructor$>";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[22];
        RepositoryApiImpl.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(RepositoryApiImpl.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = RepositoryApiImpl.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

