/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.script.plugin.internal.rest;

import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Preconditions;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.lang.ref.SoftReference;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.slf4j.LoggerFactory;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.script.ScriptService;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.script.Script;
import org.sonatype.nexus.script.ScriptClient;
import org.sonatype.nexus.script.ScriptManager;
import org.sonatype.nexus.script.ScriptResultXO;
import org.sonatype.nexus.script.ScriptXO;
import org.sonatype.nexus.script.plugin.internal.security.ScriptPermission;
import org.sonatype.nexus.security.BreadActions;
import org.sonatype.nexus.security.SecurityHelper;
import org.sonatype.nexus.security.privilege.PrivilegeDescriptorSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
@Singleton
@Path(value="/v1/script")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="script")
public class ScriptResource
extends ComponentSupport
implements ScriptClient,
Resource,
GroovyObject {
    public static final String RESOURCE_URI = "/v1/script";
    @Inject
    private ScriptManager scriptManager;
    @Inject
    private SecurityHelper securityHelper;
    @Inject
    private ScriptService scriptService;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public ScriptResource() {
        MetaClass metaClass;
        CallSite[] callSiteArray = ScriptResource.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Timed
    @ExceptionMetered
    @ApiOperation(value="List all stored scripts")
    public List<ScriptXO> browse() {
        CallSite[] callSiteArray = ScriptResource.$getCallSiteArray();
        callSiteArray[0].call((Object)this.securityHelper, callSiteArray[1].callStatic(ScriptResource.class, callSiteArray[2].callGetProperty(PrivilegeDescriptorSupport.class), callSiteArray[3].callGetProperty(BreadActions.class)));
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[4].call(callSiteArray[5].call((Object)this.scriptManager), (Object)new GeneratedClosure((Object)this, (Object)this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                CallSite[] callSiteArray = _browse_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _browse_closure1.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, it);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _browse_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _browse_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "convert";
                return new CallSiteArray(_browse_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _browse_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }), List.class);
    }

    @Timed
    @ExceptionMetered
    @ApiOperation(value="Read stored script by name")
    @ApiResponses(value={@ApiResponse(code=404, message="No script with the specified name")})
    public ScriptXO read(@PathParam(value="name") String name) {
        CallSite[] callSiteArray = ScriptResource.$getCallSiteArray();
        callSiteArray[6].call((Object)this.securityHelper, callSiteArray[7].callStatic(ScriptResource.class, (Object)name, callSiteArray[8].callGetProperty(BreadActions.class)));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (ScriptXO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[9].callStatic(ScriptResource.class, callSiteArray[10].callCurrent((GroovyObject)this, (Object)name)), ScriptXO.class);
        }
        return (ScriptXO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[11].callStatic(ScriptResource.class, (Object)this.findOr404(name)), ScriptXO.class);
    }

    @Timed
    @ExceptionMetered
    @ApiOperation(value="Update stored script by name")
    @ApiResponses(value={@ApiResponse(code=204, message="Script was updated"), @ApiResponse(code=404, message="No script with the specified name")})
    public void edit(@PathParam(value="name") String name, @NotNull @Valid ScriptXO scriptXO) {
        CallSite[] callSiteArray = ScriptResource.$getCallSiteArray();
        callSiteArray[12].call((Object)this.securityHelper, callSiteArray[13].callStatic(ScriptResource.class, (Object)name, callSiteArray[14].callGetProperty(BreadActions.class)));
        callSiteArray[15].callStatic(Preconditions.class, (Object)ScriptBytecodeAdapter.compareEqual((Object)name, (Object)callSiteArray[16].callGroovyObjectGetProperty((Object)scriptXO)), (Object)new GStringImpl(new Object[]{name, callSiteArray[17].callGroovyObjectGetProperty((Object)scriptXO)}, new String[]{"Path parameter: ", " does not match data name: ", ""}));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[18].callCurrent((GroovyObject)this, (Object)name);
        } else {
            this.findOr404(name);
        }
        callSiteArray[19].call(callSiteArray[20].callGroovyObjectGetProperty((Object)this), (Object)"Updating Script named: {}", (Object)name);
        callSiteArray[21].call((Object)this.scriptManager, (Object)name, callSiteArray[22].callGroovyObjectGetProperty((Object)scriptXO));
    }

    @Timed
    @ExceptionMetered
    @ApiOperation(value="Add a new script")
    @ApiResponses(value={@ApiResponse(code=204, message="Script was added")})
    public void add(@NotNull @Valid ScriptXO scriptXO) {
        CallSite[] callSiteArray = ScriptResource.$getCallSiteArray();
        callSiteArray[23].call((Object)this.securityHelper, callSiteArray[24].callStatic(ScriptResource.class, callSiteArray[25].callGetProperty(PrivilegeDescriptorSupport.class), callSiteArray[26].callGetProperty(BreadActions.class)));
        callSiteArray[27].call(callSiteArray[28].callGroovyObjectGetProperty((Object)this), (Object)"Adding Script named: {}", callSiteArray[29].callGroovyObjectGetProperty((Object)scriptXO));
        callSiteArray[30].call((Object)this.scriptManager, callSiteArray[31].callGroovyObjectGetProperty((Object)scriptXO), callSiteArray[32].callGroovyObjectGetProperty((Object)scriptXO), callSiteArray[33].callGroovyObjectGetProperty((Object)scriptXO));
    }

    @Timed
    @ExceptionMetered
    @ApiOperation(value="Delete stored script by name")
    @ApiResponses(value={@ApiResponse(code=204, message="Script was deleted"), @ApiResponse(code=404, message="No script with the specified name")})
    public void delete(@PathParam(value="name") String name) {
        CallSite[] callSiteArray = ScriptResource.$getCallSiteArray();
        callSiteArray[34].call((Object)this.securityHelper, callSiteArray[35].callStatic(ScriptResource.class, (Object)name, callSiteArray[36].callGetProperty(BreadActions.class)));
        callSiteArray[37].call(callSiteArray[38].callGroovyObjectGetProperty((Object)this), (Object)"Deleting Script named: {}", (Object)name);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[39].call((Object)this.scriptManager, callSiteArray[40].callGetProperty(callSiteArray[41].callCurrent((GroovyObject)this, (Object)name)));
        } else {
            callSiteArray[42].call((Object)this.scriptManager, callSiteArray[43].callGetProperty((Object)this.findOr404(name)));
        }
    }

    @Timed
    @ExceptionMetered
    @ApiOperation(value="Run stored script by name")
    @ApiResponses(value={@ApiResponse(code=404, message="No script with the specified name"), @ApiResponse(code=500, message="Script execution failed with exception")})
    public ScriptResultXO run(@PathParam(value="name") String name, String args) {
        CallSite[] callSiteArray = ScriptResource.$getCallSiteArray();
        callSiteArray[44].call((Object)this.securityHelper, callSiteArray[45].callStatic(ScriptResource.class, (Object)name, callSiteArray[46].callGroovyObjectGetProperty((Object)this)));
        callSiteArray[47].call(callSiteArray[48].callGroovyObjectGetProperty((Object)this), (Object)"Running Script named: {}", (Object)name);
        Script script = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[49].callCurrent((GroovyObject)this, (Object)name);
            script = (Script)ScriptBytecodeAdapter.castToType((Object)object, Script.class);
        } else {
            Script script2;
            script = script2 = this.findOr404(name);
        }
        Object result = null;
        try {
            Object object;
            result = object = callSiteArray[50].call((Object)this.scriptService, callSiteArray[51].callGroovyObjectGetProperty((Object)script), callSiteArray[52].callGroovyObjectGetProperty((Object)script), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"log", callSiteArray[53].call(LoggerFactory.class, callSiteArray[54].callCurrent((GroovyObject)this)), "args", callSiteArray[55].callSafe((Object)args)}));
        }
        catch (Exception e) {
            callSiteArray[56].call(callSiteArray[57].callGroovyObjectGetProperty((Object)this), (Object)"Exception in script execution for script named: {}", (Object)name, (Object)e);
            throw (Throwable)callSiteArray[58].callConstructor(WebApplicationException.class, callSiteArray[59].call(callSiteArray[60].call(callSiteArray[61].call(Response.class, callSiteArray[62].callGetProperty(Response.Status.class)), callSiteArray[63].callConstructor(ScriptResultXO.class, callSiteArray[64].callGroovyObjectGetProperty((Object)script), callSiteArray[65].callGetProperty((Object)e)))));
        }
        callSiteArray[66].call(callSiteArray[67].callGroovyObjectGetProperty((Object)this), (Object)"Result: {}", result);
        return (ScriptResultXO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[68].callConstructor(ScriptResultXO.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", name, "result", callSiteArray[69].call(result)})), ScriptResultXO.class);
    }

    private Script findOr404(String name) {
        CallSite[] callSiteArray = ScriptResource.$getCallSiteArray();
        Script script = (Script)ScriptBytecodeAdapter.castToType((Object)callSiteArray[70].call((Object)this.scriptManager, (Object)name), Script.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)script)) {
            throw (Throwable)callSiteArray[71].callConstructor(NotFoundException.class, (Object)new GStringImpl(new Object[]{name}, new String[]{"Script with name: '", "' not found"}));
        }
        return script;
    }

    public static ScriptXO convert(Script script) {
        CallSite[] callSiteArray = ScriptResource.$getCallSiteArray();
        return (ScriptXO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[72].callConstructor(ScriptXO.class, callSiteArray[73].callGroovyObjectGetProperty((Object)script), callSiteArray[74].callGroovyObjectGetProperty((Object)script), callSiteArray[75].callGroovyObjectGetProperty((Object)script)), ScriptXO.class);
    }

    public static ScriptPermission scriptPermission(String name, String action) {
        CallSite[] callSiteArray = ScriptResource.$getCallSiteArray();
        return (ScriptPermission)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[76].callConstructor(ScriptPermission.class, (Object)name, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{action})), ScriptPermission.class));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != ScriptResource.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public ScriptManager getScriptManager() {
        return this.scriptManager;
    }

    public void setScriptManager(ScriptManager scriptManager) {
        this.scriptManager = scriptManager;
    }

    public SecurityHelper getSecurityHelper() {
        return this.securityHelper;
    }

    public void setSecurityHelper(SecurityHelper securityHelper) {
        this.securityHelper = securityHelper;
    }

    public ScriptService getScriptService() {
        return this.scriptService;
    }

    public void setScriptService(ScriptService scriptService) {
        this.scriptService = scriptService;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "ensurePermitted";
        stringArray[1] = "scriptPermission";
        stringArray[2] = "ALL";
        stringArray[3] = "BROWSE";
        stringArray[4] = "collect";
        stringArray[5] = "browse";
        stringArray[6] = "ensurePermitted";
        stringArray[7] = "scriptPermission";
        stringArray[8] = "READ";
        stringArray[9] = "convert";
        stringArray[10] = "findOr404";
        stringArray[11] = "convert";
        stringArray[12] = "ensurePermitted";
        stringArray[13] = "scriptPermission";
        stringArray[14] = "EDIT";
        stringArray[15] = "checkArgument";
        stringArray[16] = "name";
        stringArray[17] = "name";
        stringArray[18] = "findOr404";
        stringArray[19] = "debug";
        stringArray[20] = "log";
        stringArray[21] = "update";
        stringArray[22] = "content";
        stringArray[23] = "ensurePermitted";
        stringArray[24] = "scriptPermission";
        stringArray[25] = "ALL";
        stringArray[26] = "ADD";
        stringArray[27] = "debug";
        stringArray[28] = "log";
        stringArray[29] = "name";
        stringArray[30] = "create";
        stringArray[31] = "name";
        stringArray[32] = "content";
        stringArray[33] = "type";
        stringArray[34] = "ensurePermitted";
        stringArray[35] = "scriptPermission";
        stringArray[36] = "DELETE";
        stringArray[37] = "debug";
        stringArray[38] = "log";
        stringArray[39] = "delete";
        stringArray[40] = "name";
        stringArray[41] = "findOr404";
        stringArray[42] = "delete";
        stringArray[43] = "name";
        stringArray[44] = "ensurePermitted";
        stringArray[45] = "scriptPermission";
        stringArray[46] = "RUN_ACTION";
        stringArray[47] = "debug";
        stringArray[48] = "log";
        stringArray[49] = "findOr404";
        stringArray[50] = "eval";
        stringArray[51] = "type";
        stringArray[52] = "content";
        stringArray[53] = "getLogger";
        stringArray[54] = "getClass";
        stringArray[55] = "trim";
        stringArray[56] = "error";
        stringArray[57] = "log";
        stringArray[58] = "<$constructor$>";
        stringArray[59] = "build";
        stringArray[60] = "entity";
        stringArray[61] = "status";
        stringArray[62] = "BAD_REQUEST";
        stringArray[63] = "<$constructor$>";
        stringArray[64] = "name";
        stringArray[65] = "message";
        stringArray[66] = "trace";
        stringArray[67] = "log";
        stringArray[68] = "<$constructor$>";
        stringArray[69] = "toString";
        stringArray[70] = "get";
        stringArray[71] = "<$constructor$>";
        stringArray[72] = "<$constructor$>";
        stringArray[73] = "name";
        stringArray[74] = "content";
        stringArray[75] = "type";
        stringArray[76] = "<$constructor$>";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[77];
        ScriptResource.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(ScriptResource.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = ScriptResource.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

