/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cache.internal.ehcache;

import com.google.common.base.Preconditions;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.expiry.ExpiryPolicy;
import javax.inject.Named;
import org.ehcache.ValueSupplier;
import org.ehcache.config.Builder;
import org.ehcache.config.CacheRuntimeConfiguration;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.event.CacheEventListener;
import org.ehcache.event.EventFiring;
import org.ehcache.event.EventOrdering;
import org.ehcache.event.EventType;
import org.ehcache.expiry.Duration;
import org.ehcache.expiry.Expiry;
import org.ehcache.jsr107.Eh107Configuration;
import org.sonatype.nexus.cache.AbstractCacheBuilder;

@Named(value="ehcache")
public class EhCacheBuilder<K, V>
extends AbstractCacheBuilder<K, V> {
    @Override
    public Cache<K, V> build(CacheManager manager) {
        Preconditions.checkNotNull((Object)manager);
        Preconditions.checkNotNull((Object)this.keyType);
        Preconditions.checkNotNull((Object)this.valueType);
        Preconditions.checkNotNull((Object)this.name);
        Preconditions.checkNotNull((Object)this.expiryFactory);
        CacheConfigurationBuilder builder = CacheConfigurationBuilder.newCacheConfigurationBuilder((Class)this.keyType, (Class)this.valueType, (Builder)ResourcePoolsBuilder.heap((long)this.cacheSize));
        builder.withExpiry(this.mapToEhCacheExpiry((ExpiryPolicy)this.expiryFactory.create()));
        Cache cache = manager.createCache(this.name, Eh107Configuration.fromEhcacheCacheConfiguration((Builder)builder));
        manager.enableStatistics(this.name, this.statisticsEnabled);
        manager.enableManagement(this.name, this.managementEnabled);
        if (this.persister != null) {
            CacheEventListener listener = cacheEvent -> this.persister.accept(cacheEvent.getKey(), cacheEvent.getOldValue());
            Eh107Configuration configuration = (Eh107Configuration)cache.getConfiguration(Eh107Configuration.class);
            ((CacheRuntimeConfiguration)configuration.unwrap(CacheRuntimeConfiguration.class)).registerCacheEventListener(listener, EventOrdering.UNORDERED, EventFiring.ASYNCHRONOUS, EventType.EVICTED, new EventType[]{EventType.REMOVED, EventType.EXPIRED});
        }
        return cache;
    }

    private Expiry<K, V> mapToEhCacheExpiry(final ExpiryPolicy policy) {
        return new Expiry<K, V>(){

            public Duration getExpiryForCreation(K k, V v) {
                return this.toEhCacheDuration(policy.getExpiryForCreation());
            }

            public Duration getExpiryForAccess(K k, ValueSupplier<? extends V> valueSupplier) {
                return this.toEhCacheDuration(policy.getExpiryForAccess());
            }

            public Duration getExpiryForUpdate(K k, ValueSupplier<? extends V> valueSupplier, V v) {
                return this.toEhCacheDuration(policy.getExpiryForUpdate());
            }

            private Duration toEhCacheDuration(javax.cache.expiry.Duration duration) {
                return duration.isEternal() ? Duration.INFINITE : new Duration(duration.getDurationAmount(), duration.getTimeUnit());
            }
        };
    }
}

