/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cache.internal.ehcache;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.net.URI;
import javax.annotation.Nullable;
import javax.annotation.PreDestroy;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.spi.CachingProvider;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.ehcache.jsr107.EhcacheCachingProvider;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ApplicationDirectories;

@Named(value="ehcache")
@Singleton
public class EhCacheManagerProvider
extends ComponentSupport
implements Provider<CacheManager> {
    private static final String CONFIG_FILE = "ehcache.xml";
    private volatile CacheManager cacheManager;

    @Inject
    public EhCacheManagerProvider(ApplicationDirectories directories) {
        Preconditions.checkNotNull((Object)directories);
        URI uri = null;
        File file = new File(directories.getConfigDirectory("fabric"), CONFIG_FILE);
        if (file.exists()) {
            uri = file.toURI();
        } else {
            this.log.warn("Missing configuration: {}", (Object)file.getAbsolutePath());
        }
        this.cacheManager = this.create(uri);
    }

    @VisibleForTesting
    public EhCacheManagerProvider(@Nullable URI uri) {
        this.cacheManager = this.create(uri);
    }

    private CacheManager create(@Nullable URI config) {
        CachingProvider provider = Caching.getCachingProvider((String)EhcacheCachingProvider.class.getName(), (ClassLoader)EhcacheCachingProvider.class.getClassLoader());
        this.log.info("Creating cache-manager with configuration: {}", (Object)config);
        CacheManager manager = provider.getCacheManager(config, ((Object)((Object)this)).getClass().getClassLoader());
        this.log.debug("Created cache-manager: {}", (Object)manager);
        return manager;
    }

    public CacheManager get() {
        Preconditions.checkState((this.cacheManager != null ? 1 : 0) != 0, (Object)"Cache-manager destroyed");
        return this.cacheManager;
    }

    @PreDestroy
    public void destroy() {
        if (this.cacheManager != null) {
            this.cacheManager.close();
            this.log.info("Cache-manager closed");
            this.cacheManager = null;
        }
    }
}

