/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.atlas;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipOutputStream;

public class FlushableZipOutputStream
extends ZipOutputStream {
    private boolean syncFlush;

    public FlushableZipOutputStream(OutputStream out) {
        super(out);
    }

    public void setSyncFlush(boolean syncFlush) {
        this.syncFlush = syncFlush;
    }

    @Override
    public void flush() throws IOException {
        if (this.syncFlush && !this.def.finished()) {
            int len = 0;
            while ((len = this.def.deflate(this.buf, 0, this.buf.length, 2)) > 0) {
                this.out.write(this.buf, 0, len);
                if (len < this.buf.length) break;
            }
        }
        this.out.flush();
    }
}

