/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.atlas;

import com.google.common.base.Preconditions;
import com.google.common.io.CountingOutputStream;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.util.List;
import java.util.Set;
import java.util.zip.Deflater;
import java.util.zip.ZipEntry;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.sonatype.goodies.common.ByteSize;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.wonderland.DownloadService;
import org.sonatype.nexus.internal.atlas.FlushableZipOutputStream;
import org.sonatype.nexus.supportzip.SupportBundle;
import org.sonatype.nexus.supportzip.SupportBundleCustomizer;
import org.sonatype.nexus.supportzip.SupportZipGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
@Singleton
public class SupportZipGeneratorImpl
extends ComponentSupport
implements SupportZipGenerator,
GroovyObject {
    private final List<SupportBundleCustomizer> bundleCustomizers;
    private final DownloadService downloadService;
    private final ByteSize maxFileSize;
    private final ByteSize maxZipFileSize;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    /*
     * WARNING - void declaration
     */
    @Inject
    public SupportZipGeneratorImpl(DownloadService downloadService, List<SupportBundleCustomizer> list, @Named(value="${atlas.supportZipGenerator.maxFileSize:-30mb}") ByteSize byteSize, @Named(value="${atlas.supportZipGenerator.maxZipFileSize:-20mb}") ByteSize byteSize2) {
        void maxZipFileSize;
        void maxFileSize;
        void downloadService2;
        void bundleCustomizers;
        MetaClass metaClass;
        CallSite[] callSiteArray = SupportZipGeneratorImpl.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Object object = callSiteArray[0].callStatic(Preconditions.class, (Object)bundleCustomizers);
        this.bundleCustomizers = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
        Object object2 = callSiteArray[1].callStatic(Preconditions.class, (Object)downloadService2);
        this.downloadService = (DownloadService)ScriptBytecodeAdapter.castToType((Object)object2, DownloadService.class);
        void var9_9 = maxFileSize;
        this.maxFileSize = (ByteSize)ScriptBytecodeAdapter.castToType((Object)var9_9, ByteSize.class);
        callSiteArray[2].call(callSiteArray[3].callGroovyObjectGetProperty((Object)this), (Object)"Maximum included file size: {}", (Object)maxFileSize);
        void var10_10 = maxZipFileSize;
        this.maxZipFileSize = (ByteSize)ScriptBytecodeAdapter.castToType((Object)var10_10, ByteSize.class);
        callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this), (Object)"Maximum ZIP file size: {}", (Object)maxZipFileSize);
    }

    private Set<SupportBundle.ContentSource.Type> includedTypes(SupportZipGenerator.Request request) {
        CallSite[] callSiteArray = SupportZipGeneratorImpl.$getCallSiteArray();
        List types = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[6].callGetProperty((Object)request))) {
            callSiteArray[7].call((Object)types, callSiteArray[8].callGetProperty(SupportBundle.ContentSource.Type.class));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[9].callGetProperty((Object)request))) {
            callSiteArray[10].call((Object)types, callSiteArray[11].callGetProperty(SupportBundle.ContentSource.Type.class));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[12].callGetProperty((Object)request))) {
            callSiteArray[13].call((Object)types, callSiteArray[14].callGetProperty(SupportBundle.ContentSource.Type.class));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[15].callGetProperty((Object)request))) {
            callSiteArray[16].call((Object)types, callSiteArray[17].callGetProperty(SupportBundle.ContentSource.Type.class));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[18].callGetProperty((Object)request))) {
            callSiteArray[19].call((Object)types, callSiteArray[20].callGetProperty(SupportBundle.ContentSource.Type.class));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[21].callGetProperty((Object)request))) {
            callSiteArray[22].call((Object)types, callSiteArray[23].callGetProperty(SupportBundle.ContentSource.Type.class));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[24].callGetProperty((Object)request))) {
            callSiteArray[25].call((Object)types, callSiteArray[26].callGetProperty(SupportBundle.ContentSource.Type.class));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[27].callGetProperty((Object)request))) {
            callSiteArray[28].call((Object)types, callSiteArray[29].callGetProperty(SupportBundle.ContentSource.Type.class));
        }
        return (Set)ScriptBytecodeAdapter.castToType((Object)types, Set.class);
    }

    private List<SupportBundle.ContentSource> filterSources(SupportZipGenerator.Request request, SupportBundle supportBundle) {
        CallSite[] callSiteArray = SupportZipGeneratorImpl.$getCallSiteArray();
        Reference include = new Reference(callSiteArray[30].callCurrent((GroovyObject)this, (Object)request));
        Reference sources = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        callSiteArray[31].call(callSiteArray[32].callGetProperty((Object)supportBundle), (Object)new GeneratedClosure((Object)this, (Object)this, include, sources){
            private /* synthetic */ Reference include;
            private /* synthetic */ Reference sources;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _filterSources_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.include = reference2 = include;
                this.sources = reference = sources;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _filterSources_closure1.$getCallSiteArray();
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(this.include.get(), callSiteArray[1].callGetProperty(it)))) {
                    callSiteArray[2].call(callSiteArray[3].callGroovyObjectGetProperty((Object)this), (Object)"Including content source: {}", it);
                    return callSiteArray[4].call(this.sources.get(), it);
                }
                return null;
            }

            public Object getInclude() {
                CallSite[] callSiteArray = _filterSources_closure1.$getCallSiteArray();
                return this.include.get();
            }

            public Object getSources() {
                CallSite[] callSiteArray = _filterSources_closure1.$getCallSiteArray();
                return this.sources.get();
            }

            public Object doCall() {
                CallSite[] callSiteArray = _filterSources_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _filterSources_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "contains";
                stringArray[1] = "type";
                stringArray[2] = "debug";
                stringArray[3] = "log";
                stringArray[4] = "leftShift";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _filterSources_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_filterSources_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _filterSources_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        });
        return (List)ScriptBytecodeAdapter.castToType((Object)sources.get(), List.class);
    }

    public SupportZipGenerator.Result generate(SupportZipGenerator.Request request) {
        CallSite[] callSiteArray = SupportZipGeneratorImpl.$getCallSiteArray();
        callSiteArray[33].callStatic(Preconditions.class, (Object)request);
        callSiteArray[34].call(callSiteArray[35].callGroovyObjectGetProperty((Object)this), (Object)"Generating support ZIP: {}", (Object)request);
        Object prefix = callSiteArray[36].call((Object)this.downloadService, (Object)"support-");
        Object file = callSiteArray[37].callGetProperty(callSiteArray[38].call(File.class, (Object)new GStringImpl(new Object[]{prefix}, new String[]{"", "-"}), (Object)".zip"));
        callSiteArray[39].call(callSiteArray[40].callGroovyObjectGetProperty((Object)this), (Object)"Writing ZIP file: {}", file);
        Object truncated = callSiteArray[41].callCurrent((GroovyObject)this, (Object)request, prefix, callSiteArray[42].call(file));
        Object length = callSiteArray[43].call(file);
        GStringImpl targetFileName = new GStringImpl(new Object[]{prefix}, new String[]{"", ".zip"});
        Object path = callSiteArray[44].call((Object)this.downloadService, file, (Object)targetFileName);
        callSiteArray[45].call(callSiteArray[46].callGroovyObjectGetProperty((Object)this), (Object)"Created support ZIP file: {}", path);
        return (SupportZipGenerator.Result)ScriptBytecodeAdapter.castToType((Object)callSiteArray[47].callConstructor(SupportZipGenerator.Result.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"filename", targetFileName, "localPath", path, "size", length, "truncated", truncated})), SupportZipGenerator.Result.class);
    }

    public boolean generate(SupportZipGenerator.Request request, String prefix, OutputStream outputStream) {
        CallSite[] callSiteArray = SupportZipGeneratorImpl.$getCallSiteArray();
        Reference bundle = new Reference(callSiteArray[48].callConstructor(SupportBundle.class));
        callSiteArray[49].call(this.bundleCustomizers, (Object)new GeneratedClosure((Object)this, (Object)this, bundle){
            private /* synthetic */ Reference bundle;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                CallSite[] callSiteArray = _generate_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.bundle = reference = bundle;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _generate_closure2.$getCallSiteArray();
                callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), (Object)"Customizing bundle with: {}", it);
                return callSiteArray[2].call(it, this.bundle.get());
            }

            public Object getBundle() {
                CallSite[] callSiteArray = _generate_closure2.$getCallSiteArray();
                return this.bundle.get();
            }

            public Object doCall() {
                CallSite[] callSiteArray = _generate_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _generate_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "debug";
                stringArray[1] = "log";
                stringArray[2] = "customize";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _generate_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_generate_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _generate_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        });
        callSiteArray[50].callStatic(Preconditions.class, (Object)(!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[51].call(callSiteArray[52].callGetProperty(bundle.get()))) ? 1 : 0), (Object)"At least one bundle source must be configured");
        Object sources = callSiteArray[53].callCurrent((GroovyObject)this, (Object)request, bundle.get());
        callSiteArray[54].callStatic(Preconditions.class, (Object)(!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[55].call(sources)) ? 1 : 0), (Object)"At least one content source must be configured");
        callSiteArray[56].call(sources, (Object)new GeneratedClosure((Object)this, (Object)this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                CallSite[] callSiteArray = _generate_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _generate_closure3.$getCallSiteArray();
                callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), (Object)"Preparing bundle source: {}", it);
                return callSiteArray[2].call(it);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _generate_closure3.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _generate_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "debug";
                stringArray[1] = "log";
                stringArray[2] = "prepare";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _generate_closure3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_generate_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _generate_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        });
        boolean bl = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[57].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)outputStream, (Object)sources, (Object)prefix, (Object)callSiteArray[58].callGetProperty((Object)request), (Object)callSiteArray[59].callGetProperty((Object)request))));
        callSiteArray[60].call(sources, (Object)new GeneratedClosure((Object)this, (Object)this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                CallSite[] callSiteArray = _generate_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _generate_closure4.$getCallSiteArray();
                callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), (Object)"Cleaning bundle source: {}", it);
                Object object = callSiteArray[2].call(it);
                try {
                    return object;
                }
                catch (Exception e) {
                    Object object2 = callSiteArray[3].call(callSiteArray[4].callGroovyObjectGetProperty((Object)this), (Object)"Bundle source cleanup failed", (Object)e);
                    return object2;
                }
            }

            public Object doCall() {
                CallSite[] callSiteArray = _generate_closure4.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _generate_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "debug";
                stringArray[1] = "log";
                stringArray[2] = "cleanup";
                stringArray[3] = "warn";
                stringArray[4] = "log";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _generate_closure4.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_generate_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _generate_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        });
        try {
            return bl;
        }
        catch (Exception e) {
            boolean bl2 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[61].call(callSiteArray[62].callGroovyObjectGetProperty((Object)this), (Object)"Failed to create support ZIP", (Object)e));
            callSiteArray[63].call(sources, (Object)new /* invalid duplicate definition of identical inner class */);
            try {
                return bl2;
            }
            catch (Throwable throwable) {
                callSiteArray[65].call(sources, (Object)new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean createZip(OutputStream outputStream, List<SupportBundle.ContentSource> sources, String prefix, boolean limitFileSizes, boolean limitZipSize) {
        void var3_3;
        Reference sources2 = new Reference(sources);
        Reference prefix2 = new Reference((Object)var3_3);
        Reference limitFileSizes2 = new Reference((Object)limitFileSizes);
        Reference limitZipSize2 = new Reference((Object)limitZipSize);
        CallSite[] callSiteArray = SupportZipGeneratorImpl.$getCallSiteArray();
        Reference stream = new Reference(callSiteArray[66].callConstructor(CountingOutputStream.class, (Object)outputStream));
        Reference totalUncompressed = new Reference((Object)((Long)ScriptBytecodeAdapter.castToType((Object)0, Long.class)));
        Reference zip = new Reference(callSiteArray[67].callConstructor(FlushableZipOutputStream.class, stream.get()));
        Object object = callSiteArray[68].callGetProperty(Deflater.class);
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)zip.get(), (String)"level");
        boolean bl = true;
        ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)zip.get(), (String)"syncFlush");
        Reference percentCompressed = new Reference((Object)new GeneratedClosure((Object)this, (Object)this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                CallSite[] callSiteArray = _createZip_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(long compressed, long uncompressed) {
                CallSite[] callSiteArray = _createZip_closure5.$getCallSiteArray();
                if (!BytecodeInterface8.isOrigL() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)callSiteArray[0].call((Object)100, callSiteArray[1].call(callSiteArray[2].call((Object)compressed, (Object)uncompressed), (Object)100)), Integer.TYPE));
                }
                return DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)callSiteArray[3].call((Object)100, callSiteArray[4].call(callSiteArray[5].call((Object)compressed, (Object)uncompressed), (Object)100)), Integer.TYPE));
            }

            public Object call(long compressed, long uncompressed) {
                CallSite[] callSiteArray = _createZip_closure5.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[6].callCurrent((GroovyObject)this, (Object)compressed, (Object)uncompressed);
                }
                return this.doCall(compressed, uncompressed);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createZip_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "minus";
                stringArray[1] = "multiply";
                stringArray[2] = "div";
                stringArray[3] = "minus";
                stringArray[4] = "multiply";
                stringArray[5] = "div";
                stringArray[6] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[7];
                _createZip_closure5.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_createZip_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createZip_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        });
        Reference addEntry = new Reference((Object)new GeneratedClosure((Object)this, (Object)this, zip, prefix2){
            private /* synthetic */ Reference zip;
            private /* synthetic */ Reference prefix;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _createZip_closure6.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.zip = reference2 = zip;
                this.prefix = reference = prefix;
            }

            public Object doCall(String path) {
                CallSite[] callSiteArray = _createZip_closure6.$getCallSiteArray();
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call((Object)path, (Object)"/"))) {
                    Object object = callSiteArray[1].call((Object)"/", (Object)path);
                    path = ShortTypeHandling.castToString((Object)object);
                }
                Object entry = callSiteArray[2].callConstructor(ZipEntry.class, callSiteArray[3].call(this.prefix.get(), (Object)path));
                callSiteArray[4].call(this.zip.get(), entry);
                return entry;
            }

            public Object call(String path) {
                CallSite[] callSiteArray = _createZip_closure6.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[5].callCurrent((GroovyObject)this, (Object)path);
                }
                return this.doCall(path);
            }

            public Object getZip() {
                CallSite[] callSiteArray = _createZip_closure6.$getCallSiteArray();
                return this.zip.get();
            }

            public String getPrefix() {
                CallSite[] callSiteArray = _createZip_closure6.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.prefix.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createZip_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "startsWith";
                stringArray[1] = "plus";
                stringArray[2] = "<$constructor$>";
                stringArray[3] = "plus";
                stringArray[4] = "putNextEntry";
                stringArray[5] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _createZip_closure6.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_createZip_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createZip_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        });
        Reference closeEntry = new Reference((Object)new GeneratedClosure((Object)this, (Object)this, zip, totalUncompressed, percentCompressed){
            private /* synthetic */ Reference zip;
            private /* synthetic */ Reference totalUncompressed;
            private /* synthetic */ Reference percentCompressed;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _createZip_closure7.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.zip = reference3 = zip;
                this.totalUncompressed = reference2 = totalUncompressed;
                this.percentCompressed = reference = percentCompressed;
            }

            public Object doCall(ZipEntry entry) {
                CallSite[] callSiteArray = _createZip_closure7.$getCallSiteArray();
                callSiteArray[0].call(this.zip.get());
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].callGetProperty((Object)entry))) {
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].callGetProperty(callSiteArray[3].callGroovyObjectGetProperty((Object)this)))) {
                        callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this), (Object)"Entry (in={} out={}) bytes, compressed: {}%", callSiteArray[6].callGetProperty((Object)entry), callSiteArray[7].callGetProperty((Object)entry), callSiteArray[8].call(this.percentCompressed.get(), callSiteArray[9].callGetProperty((Object)entry), callSiteArray[10].callGetProperty((Object)entry)));
                    }
                    Object object = callSiteArray[11].call(this.totalUncompressed.get(), callSiteArray[12].callGetProperty((Object)entry));
                    this.totalUncompressed.set((Object)((Long)ScriptBytecodeAdapter.castToType((Object)object, Long.class)));
                    return object;
                }
                return null;
            }

            public Object call(ZipEntry entry) {
                CallSite[] callSiteArray = _createZip_closure7.$getCallSiteArray();
                return callSiteArray[13].callCurrent((GroovyObject)this, (Object)entry);
            }

            public Object getZip() {
                CallSite[] callSiteArray = _createZip_closure7.$getCallSiteArray();
                return this.zip.get();
            }

            public Long getTotalUncompressed() {
                CallSite[] callSiteArray = _createZip_closure7.$getCallSiteArray();
                return (Long)ScriptBytecodeAdapter.castToType((Object)this.totalUncompressed.get(), Long.class);
            }

            public Object getPercentCompressed() {
                CallSite[] callSiteArray = _createZip_closure7.$getCallSiteArray();
                return this.percentCompressed.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createZip_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "closeEntry";
                stringArray[1] = "size";
                stringArray[2] = "debugEnabled";
                stringArray[3] = "log";
                stringArray[4] = "debug";
                stringArray[5] = "log";
                stringArray[6] = "size";
                stringArray[7] = "compressedSize";
                stringArray[8] = "call";
                stringArray[9] = "compressedSize";
                stringArray[10] = "size";
                stringArray[11] = "plus";
                stringArray[12] = "size";
                stringArray[13] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[14];
                _createZip_closure7.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_createZip_closure7.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createZip_closure7.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        });
        GeneratedClosure addDirectoryEntries = new GeneratedClosure((Object)this, (Object)this, addEntry, sources2, closeEntry){
            private /* synthetic */ Reference addEntry;
            private /* synthetic */ Reference sources;
            private /* synthetic */ Reference closeEntry;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _createZip_closure8.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.addEntry = reference3 = addEntry;
                this.sources = reference2 = sources;
                this.closeEntry = reference = closeEntry;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _createZip_closure8.$getCallSiteArray();
                callSiteArray[0].call(this.addEntry.get(), (Object)"/");
                Reference dirs = new Reference((Object)((Set)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class)));
                callSiteArray[1].call(this.sources.get(), (Object)new GeneratedClosure((Object)this, this.getThisObject(), dirs){
                    private /* synthetic */ Reference dirs;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;
                    {
                        Reference reference;
                        CallSite[] callSiteArray = _closure10.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.dirs = reference = dirs;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure10.$getCallSiteArray();
                        List path = (List)ScriptBytecodeAdapter.asType((Object)callSiteArray[0].call(callSiteArray[1].callGetProperty(it), (Object)"/"), List.class);
                        if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[2].call((Object)path), (Object)1)) {
                            int l = DefaultTypeTransformation.intUnbox((Object)callSiteArray[3].call((Object)path));
                            while (l > 1) {
                                callSiteArray[4].call(this.dirs.get(), callSiteArray[5].call(callSiteArray[6].call((Object)path, (Object)ScriptBytecodeAdapter.createRange((Object)0, (Object)ScriptBytecodeAdapter.unaryMinus((Object)l), (boolean)true)), (Object)"/"));
                                int n = l;
                                l = DefaultTypeTransformation.intUnbox((Object)callSiteArray[7].call((Object)n));
                            }
                            return null;
                        }
                        return null;
                    }

                    public Set getDirs() {
                        CallSite[] callSiteArray = _closure10.$getCallSiteArray();
                        return (Set)ScriptBytecodeAdapter.castToType((Object)this.dirs.get(), Set.class);
                    }

                    public Object doCall() {
                        CallSite[] callSiteArray = _closure10.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure10.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "split";
                        stringArray[1] = "path";
                        stringArray[2] = "size";
                        stringArray[3] = "size";
                        stringArray[4] = "leftShift";
                        stringArray[5] = "join";
                        stringArray[6] = "getAt";
                        stringArray[7] = "previous";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[8];
                        _closure10.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure10.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure10.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                });
                return callSiteArray[2].call(callSiteArray[3].call((Object)((Set)dirs.get())), (Object)new GeneratedClosure((Object)this, this.getThisObject(), this.addEntry, this.closeEntry){
                    private /* synthetic */ Reference addEntry;
                    private /* synthetic */ Reference closeEntry;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;
                    {
                        Reference reference;
                        Reference reference2;
                        CallSite[] callSiteArray = _closure11.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.addEntry = reference2 = addEntry;
                        this.closeEntry = reference = closeEntry;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure11.$getCallSiteArray();
                        callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), (Object)"Adding directory entry: {}", it);
                        Object entry = callSiteArray[2].call(this.addEntry.get(), (Object)new GStringImpl(new Object[]{it}, new String[]{"", "/"}));
                        return callSiteArray[3].call(this.closeEntry.get(), entry);
                    }

                    public Object getAddEntry() {
                        CallSite[] callSiteArray = _closure11.$getCallSiteArray();
                        return this.addEntry.get();
                    }

                    public Object getCloseEntry() {
                        CallSite[] callSiteArray = _closure11.$getCallSiteArray();
                        return this.closeEntry.get();
                    }

                    public Object doCall() {
                        CallSite[] callSiteArray = _closure11.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure11.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "debug";
                        stringArray[1] = "log";
                        stringArray[2] = "call";
                        stringArray[3] = "call";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[4];
                        _closure11.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure11.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure11.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                });
            }

            public Object getAddEntry() {
                CallSite[] callSiteArray = _createZip_closure8.$getCallSiteArray();
                return this.addEntry.get();
            }

            public List getSources() {
                CallSite[] callSiteArray = _createZip_closure8.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.sources.get(), List.class);
            }

            public Object getCloseEntry() {
                CallSite[] callSiteArray = _createZip_closure8.$getCallSiteArray();
                return this.closeEntry.get();
            }

            public Object doCall() {
                CallSite[] callSiteArray = _createZip_closure8.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createZip_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "call";
                stringArray[1] = "each";
                stringArray[2] = "each";
                stringArray[3] = "sort";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _createZip_closure8.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_createZip_closure8.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createZip_closure8.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        };
        Reference maxContentSize = new Reference((Object)((Integer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[69].call((Object)this.maxFileSize), Integer.class)));
        Reference chunkSize = new Reference((Object)0);
        if (!BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object2 = callSiteArray[70].call((Object)4, (Object)1024);
            chunkSize.set((Object)((Integer)ScriptBytecodeAdapter.castToType((Object)object2, Integer.class)));
        } else {
            int n = 4 * 1024;
            chunkSize.set((Object)n);
        }
        Reference maxZipSize = new Reference((Object)((Integer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[71].call(callSiteArray[72].call((Object)this.maxZipFileSize), callSiteArray[73].call((Object)DefaultTypeTransformation.intUnbox((Object)chunkSize.get()), (Object)2)), Integer.class)));
        Reference TRUNCATED_TOKEN = new Reference((Object)"** TRUNCATED **");
        Reference truncated = new Reference((Object)false);
        try {
            callSiteArray[74].call((Object)addDirectoryEntries);
            callSiteArray[75].call(callSiteArray[76].call((Object)((List)sources2.get())), (Object)new GeneratedClosure((Object)this, (Object)this, zip, TRUNCATED_TOKEN, maxZipSize, addEntry, chunkSize, closeEntry, stream, maxContentSize, truncated, limitZipSize2, limitFileSizes2){
                private /* synthetic */ Reference zip;
                private /* synthetic */ Reference TRUNCATED_TOKEN;
                private /* synthetic */ Reference maxZipSize;
                private /* synthetic */ Reference addEntry;
                private /* synthetic */ Reference chunkSize;
                private /* synthetic */ Reference closeEntry;
                private /* synthetic */ Reference stream;
                private /* synthetic */ Reference maxContentSize;
                private /* synthetic */ Reference truncated;
                private /* synthetic */ Reference limitZipSize;
                private /* synthetic */ Reference limitFileSizes;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;
                {
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    Reference reference5;
                    Reference reference6;
                    Reference reference7;
                    Reference reference8;
                    Reference reference9;
                    Reference reference10;
                    Reference reference11;
                    CallSite[] callSiteArray = _createZip_closure9.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.zip = reference11 = zip;
                    this.TRUNCATED_TOKEN = reference10 = TRUNCATED_TOKEN;
                    this.maxZipSize = reference9 = maxZipSize;
                    this.addEntry = reference8 = addEntry;
                    this.chunkSize = reference7 = chunkSize;
                    this.closeEntry = reference6 = closeEntry;
                    this.stream = reference5 = stream;
                    this.maxContentSize = reference4 = maxContentSize;
                    this.truncated = reference3 = truncated;
                    this.limitZipSize = reference2 = limitZipSize;
                    this.limitFileSizes = reference = limitFileSizes;
                }

                public Object doCall(Object source) {
                    Reference source2 = new Reference(source);
                    CallSite[] callSiteArray = _createZip_closure9.$getCallSiteArray();
                    callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), (Object)"Adding content entry: {} {} bytes", source2.get(), callSiteArray[2].callGetProperty(source2.get()));
                    Object entry = callSiteArray[3].call(this.addEntry.get(), callSiteArray[4].callGetProperty(source2.get()));
                    callSiteArray[5].call(callSiteArray[6].callGetProperty(source2.get()), (Object)new GeneratedClosure((Object)this, this.getThisObject(), this.zip, this.TRUNCATED_TOKEN, this.maxZipSize, this.chunkSize, this.stream, this.maxContentSize, this.truncated, this.limitZipSize, source2, this.limitFileSizes){
                        private /* synthetic */ Reference zip;
                        private /* synthetic */ Reference TRUNCATED_TOKEN;
                        private /* synthetic */ Reference maxZipSize;
                        private /* synthetic */ Reference chunkSize;
                        private /* synthetic */ Reference stream;
                        private /* synthetic */ Reference maxContentSize;
                        private /* synthetic */ Reference truncated;
                        private /* synthetic */ Reference limitZipSize;
                        private /* synthetic */ Reference source;
                        private /* synthetic */ Reference limitFileSizes;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;
                        {
                            Reference reference;
                            Reference reference2;
                            Reference reference3;
                            Reference reference4;
                            Reference reference5;
                            Reference reference6;
                            Reference reference7;
                            Reference reference8;
                            Reference reference9;
                            Reference reference10;
                            CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                            this.zip = reference10 = zip;
                            this.TRUNCATED_TOKEN = reference9 = TRUNCATED_TOKEN;
                            this.maxZipSize = reference8 = maxZipSize;
                            this.chunkSize = reference7 = chunkSize;
                            this.stream = reference6 = stream;
                            this.maxContentSize = reference5 = maxContentSize;
                            this.truncated = reference4 = truncated;
                            this.limitZipSize = reference3 = limitZipSize;
                            this.source = reference2 = source;
                            this.limitFileSizes = reference = limitFileSizes;
                        }

                        public Object doCall(InputStream input) {
                            CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                            if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                                if (DefaultTypeTransformation.booleanUnbox((Object)this.limitFileSizes.get()) && ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[0].callGetProperty(this.source.get()), (Object)this.maxContentSize.get())) {
                                    callSiteArray[1].call(callSiteArray[2].callGroovyObjectGetProperty((Object)this), (Object)"Truncating source contents; exceeds maximum included file size: {}", callSiteArray[3].callGetProperty(this.source.get()));
                                    callSiteArray[4].call(this.zip.get(), this.TRUNCATED_TOKEN.get());
                                    boolean bl = true;
                                    this.truncated.set((Object)bl);
                                    callSiteArray[5].call((Object)input, callSiteArray[6].call(callSiteArray[7].callGetProperty(this.source.get()), this.maxContentSize.get()));
                                }
                            } else if (DefaultTypeTransformation.booleanUnbox((Object)this.limitFileSizes.get()) && ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[8].callGetProperty(this.source.get()), (Object)this.maxContentSize.get())) {
                                callSiteArray[9].call(callSiteArray[10].callGroovyObjectGetProperty((Object)this), (Object)"Truncating source contents; exceeds maximum included file size: {}", callSiteArray[11].callGetProperty(this.source.get()));
                                callSiteArray[12].call(this.zip.get(), this.TRUNCATED_TOKEN.get());
                                boolean bl = true;
                                this.truncated.set((Object)bl);
                                callSiteArray[13].call((Object)input, callSiteArray[14].call(callSiteArray[15].callGetProperty(this.source.get()), this.maxContentSize.get()));
                            }
                            byte[] buff = new byte[DefaultTypeTransformation.intUnbox((Object)this.chunkSize.get())];
                            int len = 0;
                            while (true) {
                                Object object = callSiteArray[16].call((Object)input, (Object)buff);
                                len = DefaultTypeTransformation.intUnbox((Object)object);
                                if (!ScriptBytecodeAdapter.compareNotEqual((Object)object, (Object)-1)) break;
                                if (DefaultTypeTransformation.booleanUnbox((Object)this.limitZipSize.get()) && ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[17].call(callSiteArray[18].callGetProperty(this.stream.get()), (Object)len), (Object)this.maxZipSize.get())) {
                                    callSiteArray[19].call(callSiteArray[20].callGroovyObjectGetProperty((Object)this), (Object)"Truncating source contents; max ZIP size reached: {}", callSiteArray[21].callGetProperty(this.source.get()));
                                    callSiteArray[22].call(this.zip.get(), this.TRUNCATED_TOKEN.get());
                                    boolean bl = true;
                                    this.truncated.set((Object)bl);
                                    break;
                                }
                                callSiteArray[23].call(this.zip.get(), (Object)buff, (Object)0, (Object)len);
                                callSiteArray[24].call(this.zip.get());
                            }
                            return null;
                        }

                        public Object call(InputStream input) {
                            CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                            return callSiteArray[25].callCurrent((GroovyObject)this, (Object)input);
                        }

                        public Object getZip() {
                            CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                            return this.zip.get();
                        }

                        public String getTRUNCATED_TOKEN() {
                            CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                            return ShortTypeHandling.castToString((Object)this.TRUNCATED_TOKEN.get());
                        }

                        public Integer getMaxZipSize() {
                            CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                            return (Integer)ScriptBytecodeAdapter.castToType((Object)this.maxZipSize.get(), Integer.class);
                        }

                        public Integer getChunkSize() {
                            CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                            return (Integer)ScriptBytecodeAdapter.castToType((Object)this.chunkSize.get(), Integer.class);
                        }

                        public Object getStream() {
                            CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                            return this.stream.get();
                        }

                        public Integer getMaxContentSize() {
                            CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                            return (Integer)ScriptBytecodeAdapter.castToType((Object)this.maxContentSize.get(), Integer.class);
                        }

                        public Boolean getTruncated() {
                            CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                            return (Boolean)ScriptBytecodeAdapter.castToType((Object)this.truncated.get(), Boolean.class);
                        }

                        public boolean getLimitZipSize() {
                            CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                            return DefaultTypeTransformation.booleanUnbox((Object)this.limitZipSize.get());
                        }

                        public Object getSource() {
                            CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                            return this.source.get();
                        }

                        public boolean getLimitFileSizes() {
                            CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                            return DefaultTypeTransformation.booleanUnbox((Object)this.limitFileSizes.get());
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure12.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                            stringArray[0] = "size";
                            stringArray[1] = "warn";
                            stringArray[2] = "log";
                            stringArray[3] = "path";
                            stringArray[4] = "leftShift";
                            stringArray[5] = "skip";
                            stringArray[6] = "minus";
                            stringArray[7] = "size";
                            stringArray[8] = "size";
                            stringArray[9] = "warn";
                            stringArray[10] = "log";
                            stringArray[11] = "path";
                            stringArray[12] = "leftShift";
                            stringArray[13] = "skip";
                            stringArray[14] = "minus";
                            stringArray[15] = "size";
                            stringArray[16] = "read";
                            stringArray[17] = "plus";
                            stringArray[18] = "count";
                            stringArray[19] = "warn";
                            stringArray[20] = "log";
                            stringArray[21] = "path";
                            stringArray[22] = "leftShift";
                            stringArray[23] = "write";
                            stringArray[24] = "flush";
                            stringArray[25] = "doCall";
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[26];
                            _closure12.$createCallSiteArray_1(stringArray);
                            return new CallSiteArray(_closure12.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure12.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    });
                    return callSiteArray[7].call(this.closeEntry.get(), entry);
                }

                public Object getZip() {
                    CallSite[] callSiteArray = _createZip_closure9.$getCallSiteArray();
                    return this.zip.get();
                }

                public String getTRUNCATED_TOKEN() {
                    CallSite[] callSiteArray = _createZip_closure9.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.TRUNCATED_TOKEN.get());
                }

                public Integer getMaxZipSize() {
                    CallSite[] callSiteArray = _createZip_closure9.$getCallSiteArray();
                    return (Integer)ScriptBytecodeAdapter.castToType((Object)this.maxZipSize.get(), Integer.class);
                }

                public Object getAddEntry() {
                    CallSite[] callSiteArray = _createZip_closure9.$getCallSiteArray();
                    return this.addEntry.get();
                }

                public Integer getChunkSize() {
                    CallSite[] callSiteArray = _createZip_closure9.$getCallSiteArray();
                    return (Integer)ScriptBytecodeAdapter.castToType((Object)this.chunkSize.get(), Integer.class);
                }

                public Object getCloseEntry() {
                    CallSite[] callSiteArray = _createZip_closure9.$getCallSiteArray();
                    return this.closeEntry.get();
                }

                public Object getStream() {
                    CallSite[] callSiteArray = _createZip_closure9.$getCallSiteArray();
                    return this.stream.get();
                }

                public Integer getMaxContentSize() {
                    CallSite[] callSiteArray = _createZip_closure9.$getCallSiteArray();
                    return (Integer)ScriptBytecodeAdapter.castToType((Object)this.maxContentSize.get(), Integer.class);
                }

                public Boolean getTruncated() {
                    CallSite[] callSiteArray = _createZip_closure9.$getCallSiteArray();
                    return (Boolean)ScriptBytecodeAdapter.castToType((Object)this.truncated.get(), Boolean.class);
                }

                public boolean getLimitZipSize() {
                    CallSite[] callSiteArray = _createZip_closure9.$getCallSiteArray();
                    return DefaultTypeTransformation.booleanUnbox((Object)this.limitZipSize.get());
                }

                public boolean getLimitFileSizes() {
                    CallSite[] callSiteArray = _createZip_closure9.$getCallSiteArray();
                    return DefaultTypeTransformation.booleanUnbox((Object)this.limitFileSizes.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _createZip_closure9.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "debug";
                    stringArray[1] = "log";
                    stringArray[2] = "size";
                    stringArray[3] = "call";
                    stringArray[4] = "path";
                    stringArray[5] = "withStream";
                    stringArray[6] = "content";
                    stringArray[7] = "call";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[8];
                    _createZip_closure9.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_createZip_closure9.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _createZip_closure9.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            });
            if (DefaultTypeTransformation.booleanUnbox((Object)((Boolean)truncated.get()))) {
                callSiteArray[77].call(addEntry.get(), (Object)"truncated");
            }
        }
        catch (Throwable throwable) {
            callSiteArray[79].call(zip.get());
            throw throwable;
        }
        callSiteArray[78].call(zip.get());
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[80].callGetProperty(callSiteArray[81].callGroovyObjectGetProperty((Object)this)))) {
            callSiteArray[82].call(callSiteArray[83].callGroovyObjectGetProperty((Object)this), (Object)"ZIP file (in={} out={}) bytes, compressed: {}%", (Object)((Long)totalUncompressed.get()), callSiteArray[84].callGetProperty(stream.get()), callSiteArray[85].call(percentCompressed.get(), callSiteArray[86].callGetProperty(stream.get()), (Object)((Long)totalUncompressed.get())));
        }
        return DefaultTypeTransformation.booleanUnbox((Object)((Boolean)truncated.get()));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != SupportZipGeneratorImpl.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "checkNotNull";
        stringArray[1] = "checkNotNull";
        stringArray[2] = "info";
        stringArray[3] = "log";
        stringArray[4] = "info";
        stringArray[5] = "log";
        stringArray[6] = "systemInformation";
        stringArray[7] = "leftShift";
        stringArray[8] = "SYSINFO";
        stringArray[9] = "threadDump";
        stringArray[10] = "leftShift";
        stringArray[11] = "THREAD";
        stringArray[12] = "metrics";
        stringArray[13] = "leftShift";
        stringArray[14] = "METRICS";
        stringArray[15] = "configuration";
        stringArray[16] = "leftShift";
        stringArray[17] = "CONFIG";
        stringArray[18] = "security";
        stringArray[19] = "leftShift";
        stringArray[20] = "SECURITY";
        stringArray[21] = "log";
        stringArray[22] = "leftShift";
        stringArray[23] = "LOG";
        stringArray[24] = "taskLog";
        stringArray[25] = "leftShift";
        stringArray[26] = "TASKLOG";
        stringArray[27] = "jmx";
        stringArray[28] = "leftShift";
        stringArray[29] = "JMX";
        stringArray[30] = "includedTypes";
        stringArray[31] = "each";
        stringArray[32] = "sources";
        stringArray[33] = "checkNotNull";
        stringArray[34] = "info";
        stringArray[35] = "log";
        stringArray[36] = "uniqueName";
        stringArray[37] = "canonicalFile";
        stringArray[38] = "createTempFile";
        stringArray[39] = "debug";
        stringArray[40] = "log";
        stringArray[41] = "generate";
        stringArray[42] = "newOutputStream";
        stringArray[43] = "length";
        stringArray[44] = "move";
        stringArray[45] = "info";
        stringArray[46] = "log";
        stringArray[47] = "<$constructor$>";
        stringArray[48] = "<$constructor$>";
        stringArray[49] = "each";
        stringArray[50] = "checkState";
        stringArray[51] = "isEmpty";
        stringArray[52] = "sources";
        stringArray[53] = "filterSources";
        stringArray[54] = "checkState";
        stringArray[55] = "isEmpty";
        stringArray[56] = "each";
        stringArray[57] = "createZip";
        stringArray[58] = "limitFileSizes";
        stringArray[59] = "limitZipSize";
        stringArray[60] = "each";
        stringArray[61] = "error";
        stringArray[62] = "log";
        stringArray[63] = "each";
        stringArray[64] = "each";
        stringArray[65] = "each";
        stringArray[66] = "<$constructor$>";
        stringArray[67] = "<$constructor$>";
        stringArray[68] = "DEFAULT_COMPRESSION";
        stringArray[69] = "toBytes";
        stringArray[70] = "multiply";
        stringArray[71] = "minus";
        stringArray[72] = "toBytes";
        stringArray[73] = "multiply";
        stringArray[74] = "call";
        stringArray[75] = "each";
        stringArray[76] = "sort";
        stringArray[77] = "call";
        stringArray[78] = "close";
        stringArray[79] = "close";
        stringArray[80] = "debugEnabled";
        stringArray[81] = "log";
        stringArray[82] = "debug";
        stringArray[83] = "log";
        stringArray[84] = "count";
        stringArray[85] = "call";
        stringArray[86] = "count";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[87];
        SupportZipGeneratorImpl.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(SupportZipGeneratorImpl.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = SupportZipGeneratorImpl.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

