/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.backup;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.common.app.ApplicationVersion;
import org.sonatype.nexus.internal.backup.DatabaseBackup;
import org.sonatype.nexus.internal.backup.DatabaseBackupRunner;
import org.sonatype.nexus.orient.DatabaseManager;
import org.sonatype.nexus.orient.DatabaseRestorer;
import org.sonatype.nexus.orient.DatabaseServer;
import org.sonatype.nexus.orient.restore.RestoreFile;

@Named
@Singleton
public class DatabaseBackupImpl
extends ComponentSupport
implements DatabaseBackup {
    private final int compressionLevel;
    private final int bufferSize;
    private final DatabaseServer databaseServer;
    private final DatabaseManager databaseManager;
    private final DatabaseRestorer databaseRestorer;
    private final ApplicationDirectories applicationDirectories;
    private final ApplicationVersion applicationVersion;

    @Inject
    public DatabaseBackupImpl(DatabaseServer databaseServer, DatabaseManager databaseManager, DatabaseRestorer databaseRestorer, @Named(value="${nexus.backup.compressionLevel:-9}") int compressionLevel, @Named(value="${nexus.backup.bufferSize:-1024}") int bufferSize, ApplicationDirectories applicationDirectories, ApplicationVersion applicationVersion) {
        this.databaseServer = (DatabaseServer)Preconditions.checkNotNull((Object)databaseServer);
        this.databaseManager = (DatabaseManager)Preconditions.checkNotNull((Object)databaseManager);
        this.databaseRestorer = (DatabaseRestorer)Preconditions.checkNotNull((Object)databaseRestorer);
        this.compressionLevel = compressionLevel;
        this.bufferSize = bufferSize;
        this.applicationDirectories = (ApplicationDirectories)Preconditions.checkNotNull((Object)applicationDirectories);
        this.applicationVersion = (ApplicationVersion)Preconditions.checkNotNull((Object)applicationVersion);
    }

    @Override
    public Callable<Void> fullBackup(String backupFolder, String dbName, LocalDateTime timestamp) throws IOException {
        File backupFile = this.checkTarget(backupFolder, dbName, timestamp);
        return new DatabaseBackupRunner(this.databaseManager.instance(dbName), backupFile, this.compressionLevel, this.bufferSize);
    }

    @VisibleForTesting
    File checkTarget(String backupFolder, String dbName, LocalDateTime timestamp) throws IOException {
        String filename = RestoreFile.formatFilename((String)dbName, (LocalDateTime)timestamp, (String)this.applicationVersion.getVersion());
        File parentDir = this.applicationDirectories.getWorkDirectory(backupFolder);
        if (this.databaseRestorer.isRestoreFromLocation(parentDir)) {
            throw new IllegalArgumentException("Backup to " + parentDir + " is not allowed.");
        }
        File output = new File(parentDir, filename);
        if (output.createNewFile()) {
            return output;
        }
        throw new IOException("file creation failed for file: " + output.getAbsolutePath());
    }

    @Override
    public List<String> dbNames() {
        return ImmutableList.copyOf((Collection)this.databaseServer.databases());
    }
}

