/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.backup;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;

public class DatabaseBackupRunner
implements Callable<Void> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final DatabaseInstance databaseInstance;
    private final File backupFile;
    private final int compressionLevel;
    private final int bufferSize;

    public DatabaseBackupRunner(DatabaseInstance databaseInstance, File backupFile, int compressionLevel, int bufferSize) {
        this.databaseInstance = (DatabaseInstance)Preconditions.checkNotNull((Object)databaseInstance);
        this.backupFile = (File)Preconditions.checkNotNull((Object)backupFile);
        this.compressionLevel = (Integer)Preconditions.checkNotNull((Object)compressionLevel);
        this.bufferSize = (Integer)Preconditions.checkNotNull((Object)bufferSize);
    }

    @Override
    public Void call() throws Exception {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileOutputStream backupOutputStream = new FileOutputStream(this.backupFile);){
                OrientTransactional.inTx(() -> this.databaseInstance).throwing(IOException.class).run(db -> {
                    db.backup(backupOutputStream, null, null, iText -> this.log.debug("database backup of {}, received message '{}'", (Object)this.databaseInstance.getName(), (Object)iText), this.compressionLevel, this.bufferSize);
                    this.log.info("database backup of {} completed successfully", (Object)this.databaseInstance.getName());
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(String.format("database backup of %s failed", this.databaseInstance.getName()), e);
        }
        return null;
    }
}

