/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.backup;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.shiro.subject.Subject;
import org.sonatype.goodies.common.MultipleFailures;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.internal.backup.DatabaseBackup;
import org.sonatype.nexus.orient.freeze.DatabaseFreezeService;
import org.sonatype.nexus.orient.freeze.FreezeRequest;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskSupport;
import org.sonatype.nexus.security.subject.FakeAlmightySubject;
import org.sonatype.nexus.thread.NexusExecutorService;
import org.sonatype.nexus.thread.NexusThreadFactory;

@Named
public class DatabaseBackupTask
extends TaskSupport {
    private static final int MAX_CONCURRENT_BACKUPS = 32;
    private static final int MAX_QUEUED_BACKUPS = 2;
    private String location;
    private final DatabaseBackup databaseBackup;
    private final DatabaseFreezeService freezeService;
    private static final Messages messages = (Messages)I18N.create(Messages.class);

    @Inject
    public DatabaseBackupTask(DatabaseBackup databaseBackup, DatabaseFreezeService freezeService) {
        this.databaseBackup = (DatabaseBackup)Preconditions.checkNotNull((Object)databaseBackup);
        this.freezeService = (DatabaseFreezeService)Preconditions.checkNotNull((Object)freezeService);
    }

    public String getMessage() {
        return messages.message();
    }

    public void configure(TaskConfiguration configuration) {
        super.configure(configuration);
        this.location = configuration.getString("location");
    }

    protected Object execute() throws Exception {
        ArrayList jobs = Lists.newArrayList();
        LocalDateTime timestamp = LocalDateTime.now();
        this.log.info("task named '{}' database backup to location {}", (Object)this.getName(), (Object)this.location);
        MultipleFailures failures = new MultipleFailures();
        FreezeRequest request = this.freezeService.requestFreeze(FreezeRequest.InitiatorType.SYSTEM, this.getConfiguration().getName());
        if (request == null) {
            throw new RuntimeException("unable to perform backup task, as attempt to freeze databases failed");
        }
        for (String dbName : this.databaseBackup.dbNames()) {
            try {
                this.log.info("database backup of {} starting", (Object)dbName);
                Callable<Void> job = this.databaseBackup.fullBackup(this.location, dbName, timestamp);
                jobs.add(job);
            }
            catch (Exception e) {
                failures.add((Throwable)new RuntimeException(String.format("database backup of %s to location: %s please check filesystem permissions and that the location exists", dbName, this.location), e));
            }
        }
        this.monitorBackupResults(jobs, failures);
        if (!this.freezeService.releaseRequest(request)) {
            failures.add((Throwable)new RuntimeException("failed to automatically release read-only state; view the nodes screen to disable read-only mode."));
        }
        failures.maybePropagate();
        return null;
    }

    private void monitorBackupResults(List<Callable<Void>> jobs, MultipleFailures failures) throws InterruptedException {
        ExecutorService executorService = this.makeExecutorService();
        List<Future<Void>> futures = executorService.invokeAll(jobs);
        executorService.shutdown();
        for (Future<Void> future : futures) {
            try {
                future.get();
            }
            catch (ExecutionException e) {
                if (e.getCause() != null) {
                    failures.add(e.getCause());
                    continue;
                }
                failures.add((Throwable)e);
            }
        }
    }

    private ExecutorService makeExecutorService() {
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>(2);
        NexusThreadFactory factory = new NexusThreadFactory("dbbackup", "dbbackup");
        ThreadPoolExecutor backing = new ThreadPoolExecutor(32, 32, 1L, TimeUnit.NANOSECONDS, queue, (ThreadFactory)factory);
        backing.allowCoreThreadTimeOut(true);
        return NexusExecutorService.forFixedSubject((ExecutorService)backing, (Subject)FakeAlmightySubject.TASK_SUBJECT);
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Admin - Export databases for backup")
        public String message();
    }
}

