/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.capability;

import com.google.common.base.Preconditions;
import com.google.inject.Provider;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.capability.CapabilityRegistry;
import org.sonatype.nexus.capability.CapabilityRegistryEvent;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.internal.capability.DefaultCapabilityRegistry;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.CAPABILITIES)
@Singleton
public class CapabilityRegistryBooter
extends StateGuardLifecycleSupport {
    private final EventManager eventManager;
    private final Provider<DefaultCapabilityRegistry> capabilityRegistryProvider;

    @Inject
    public CapabilityRegistryBooter(EventManager eventManager, Provider<DefaultCapabilityRegistry> capabilityRegistryProvider) {
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.capabilityRegistryProvider = (Provider)Preconditions.checkNotNull(capabilityRegistryProvider);
    }

    protected void doStart() throws Exception {
        DefaultCapabilityRegistry registry = (DefaultCapabilityRegistry)((Object)this.capabilityRegistryProvider.get());
        registry.load();
        this.eventManager.post((Object)new CapabilityRegistryEvent.Ready((CapabilityRegistry)registry));
    }
}

