/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.capability;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.inject.ConfigurationException;
import com.google.inject.Key;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.sisu.BeanEntry;
import org.eclipse.sisu.inject.BeanLocator;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.capability.Capability;
import org.sonatype.nexus.capability.CapabilityDescriptor;
import org.sonatype.nexus.capability.CapabilityDescriptorRegistry;
import org.sonatype.nexus.capability.CapabilityFactory;
import org.sonatype.nexus.capability.CapabilityFactoryRegistry;
import org.sonatype.nexus.capability.CapabilityType;

@Named
@Singleton
class DefaultCapabilityFactoryRegistry
extends ComponentSupport
implements CapabilityFactoryRegistry {
    private final Map<String, CapabilityFactory> factories;
    private final Map<String, CapabilityFactory> dynamicFactories;
    private final CapabilityDescriptorRegistry capabilityDescriptorRegistry;
    private final BeanLocator beanLocator;

    @Inject
    DefaultCapabilityFactoryRegistry(Map<String, CapabilityFactory> factories, CapabilityDescriptorRegistry capabilityDescriptorRegistry, BeanLocator beanLocator) {
        this.beanLocator = (BeanLocator)Preconditions.checkNotNull((Object)beanLocator);
        this.capabilityDescriptorRegistry = (CapabilityDescriptorRegistry)Preconditions.checkNotNull((Object)capabilityDescriptorRegistry);
        this.factories = (Map)Preconditions.checkNotNull(factories);
        this.dynamicFactories = Maps.newConcurrentMap();
    }

    public CapabilityFactoryRegistry register(CapabilityType type, CapabilityFactory factory) {
        Preconditions.checkNotNull((Object)factory);
        Preconditions.checkArgument((!this.factories.containsKey(type.toString()) ? 1 : 0) != 0, (String)"Factory already registered for %s", (Object)type);
        Preconditions.checkArgument((!this.dynamicFactories.containsKey(type.toString()) ? 1 : 0) != 0, (String)"Factory already registered for %s", (Object)type);
        this.dynamicFactories.put(type.toString(), factory);
        this.log.debug("Added {} -> {}", (Object)type, (Object)factory);
        return this;
    }

    public CapabilityFactoryRegistry unregister(CapabilityType type) {
        if (type != null) {
            CapabilityFactory factory = this.dynamicFactories.remove(type.toString());
            this.log.debug("Removed {} -> {}", (Object)type, (Object)factory);
        }
        return this;
    }

    public CapabilityFactory get(CapabilityType type) {
        CapabilityFactory factory = this.factories.get(((CapabilityType)Preconditions.checkNotNull((Object)type)).toString());
        if (factory == null) {
            factory = this.dynamicFactories.get(((CapabilityType)Preconditions.checkNotNull((Object)type)).toString());
        }
        if (factory == null) {
            CapabilityDescriptor descriptor = this.capabilityDescriptorRegistry.get(type);
            if (descriptor instanceof CapabilityFactory) {
                factory = (CapabilityFactory)descriptor;
            }
            if (factory == null) {
                try {
                    final Iterable entries = this.beanLocator.locate(Key.get(Capability.class, (Annotation)Names.named((String)type.toString())));
                    if (entries != null && entries.iterator().hasNext()) {
                        factory = new CapabilityFactory(){

                            public Capability create() {
                                return (Capability)((BeanEntry)entries.iterator().next()).getValue();
                            }
                        };
                    }
                }
                catch (ConfigurationException configurationException) {}
            }
        }
        return factory;
    }
}

