/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.capability.storage;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityEvent;
import org.sonatype.nexus.common.entity.EntityMetadata;
import org.sonatype.nexus.internal.capability.storage.CapabilityStorageItem;
import org.sonatype.nexus.internal.capability.storage.CapabilityStorageItemCreatedEvent;
import org.sonatype.nexus.internal.capability.storage.CapabilityStorageItemDeletedEvent;
import org.sonatype.nexus.internal.capability.storage.CapabilityStorageItemUpdatedEvent;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.entity.AttachedEntityMetadata;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;

@Named
@Singleton
public class CapabilityStorageItemEntityAdapter
extends IterableEntityAdapter<CapabilityStorageItem> {
    private static final String DB_CLASS = new OClassNameBuilder().type("capability").build();
    private static final String P_VERSION = "version";
    private static final String P_TYPE = "type";
    private static final String P_ENABLED = "enabled";
    private static final String P_NOTES = "notes";
    private static final String P_PROPERTIES = "properties";

    public CapabilityStorageItemEntityAdapter() {
        super(DB_CLASS);
    }

    protected void defineType(OClass type) {
        type.createProperty(P_VERSION, OType.INTEGER);
        type.createProperty(P_TYPE, OType.STRING);
        type.createProperty(P_ENABLED, OType.BOOLEAN);
        type.createProperty(P_NOTES, OType.STRING);
        type.createProperty(P_PROPERTIES, OType.EMBEDDEDMAP);
    }

    protected CapabilityStorageItem newEntity() {
        return new CapabilityStorageItem();
    }

    protected void readFields(ODocument document, CapabilityStorageItem entity) {
        entity.setVersion((Integer)document.field(P_VERSION, OType.INTEGER));
        entity.setType((String)document.field(P_TYPE, OType.STRING));
        entity.setEnabled((Boolean)document.field(P_ENABLED, OType.BOOLEAN));
        entity.setNotes((String)document.field(P_NOTES, OType.STRING));
        Map properties = (Map)document.field(P_PROPERTIES, OType.EMBEDDEDMAP);
        entity.setProperties(properties);
    }

    protected void writeFields(ODocument document, CapabilityStorageItem entity) {
        document.field(P_VERSION, (Object)entity.getVersion());
        document.field(P_TYPE, (Object)entity.getType());
        document.field(P_ENABLED, (Object)entity.isEnabled());
        document.field(P_NOTES, (Object)entity.getNotes());
        document.field(P_PROPERTIES, entity.getProperties());
    }

    @Nullable
    private ODocument findDocument(ODatabaseDocumentTx db, String id) {
        ORID rid = this.getRecordIdObfuscator().decode(this.getSchemaType(), id);
        return (ODocument)db.getRecord((OIdentifiable)rid);
    }

    @Nullable
    public CapabilityStorageItem read(ODatabaseDocumentTx db, String id) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)id);
        ODocument document = this.findDocument(db, id);
        if (document != null) {
            return (CapabilityStorageItem)this.readEntity(document);
        }
        return null;
    }

    public boolean edit(ODatabaseDocumentTx db, String id, CapabilityStorageItem entity) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkNotNull((Object)((Object)entity));
        ODocument document = this.findDocument(db, id);
        if (document != null) {
            this.writeEntity(document, (Entity)entity);
            return true;
        }
        return false;
    }

    public boolean delete(ODatabaseDocumentTx db, String id) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)id);
        ODocument document = this.findDocument(db, id);
        if (document != null) {
            db.delete((ORecord)document);
            return true;
        }
        return false;
    }

    public boolean sendEvents() {
        return true;
    }

    public EntityEvent newEvent(ODocument document, EntityAdapter.EventKind eventKind) {
        AttachedEntityMetadata metadata = new AttachedEntityMetadata((EntityAdapter)this, document);
        switch (eventKind) {
            case CREATE: {
                return new CapabilityStorageItemCreatedEvent((EntityMetadata)metadata);
            }
            case UPDATE: {
                return new CapabilityStorageItemUpdatedEvent((EntityMetadata)metadata);
            }
            case DELETE: {
                return new CapabilityStorageItemDeletedEvent((EntityMetadata)metadata);
            }
        }
        return null;
    }
}

