/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.capability.storage;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.capability.CapabilityIdentity;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityHelper;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.internal.capability.storage.CapabilityStorage;
import org.sonatype.nexus.internal.capability.storage.CapabilityStorageItem;
import org.sonatype.nexus.internal.capability.storage.CapabilityStorageItemEntityAdapter;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;

@Named(value="orient")
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@Singleton
public class OrientCapabilityStorage
extends StateGuardLifecycleSupport
implements CapabilityStorage {
    private final Provider<DatabaseInstance> databaseInstance;
    private final CapabilityStorageItemEntityAdapter entityAdapter;

    @Inject
    public OrientCapabilityStorage(@Named(value="config") Provider<DatabaseInstance> databaseInstance, CapabilityStorageItemEntityAdapter entityAdapter) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.entityAdapter = (CapabilityStorageItemEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)entityAdapter)));
    }

    protected void doStart() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.entityAdapter.register(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private CapabilityIdentity identity(CapabilityStorageItem item) {
        return CapabilityStorageItem.identity(EntityHelper.id((Entity)item));
    }

    @Override
    @Guarded(by={"STARTED"})
    public CapabilityIdentity add(CapabilityStorageItem item) {
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            ODocument oDocument = this.entityAdapter.addEntity(db, (Entity)item);
        });
        return this.identity(item);
    }

    @Override
    @Guarded(by={"STARTED"})
    public boolean update(CapabilityIdentity id, CapabilityStorageItem item) {
        return (Boolean)OrientTransactional.inTxRetry(this.databaseInstance).call(db -> this.entityAdapter.edit(db, id.toString(), item));
    }

    @Override
    @Guarded(by={"STARTED"})
    public boolean remove(CapabilityIdentity id) {
        return (Boolean)OrientTransactional.inTxRetry(this.databaseInstance).call(db -> this.entityAdapter.delete(db, id.toString()));
    }

    @Override
    @Guarded(by={"STARTED"})
    public Map<CapabilityIdentity, CapabilityStorageItem> getAll() {
        return (Map)OrientTransactional.inTx(this.databaseInstance).call(db -> Maps.uniqueIndex((Iterable)this.entityAdapter.browse(db), this::identity));
    }
}

