/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.commands;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.sonatype.nexus.orient.freeze.DatabaseFreezeService;
import org.sonatype.nexus.orient.freeze.FreezeRequest;

@Named
@Command(name="freezeDb", scope="nexus", description="Freeze or release Nexus database")
public class DatabaseFreezeAction
implements Action {
    private final DatabaseFreezeService databaseFreezeService;
    @Option(name="-m", aliases={"--mode"}, description="Manage mode: enable or release (default enable)")
    Mode mode = Mode.enable;

    @Inject
    public DatabaseFreezeAction(DatabaseFreezeService databaseFreezeService) {
        this.databaseFreezeService = (DatabaseFreezeService)Preconditions.checkNotNull((Object)databaseFreezeService);
    }

    public Object execute() throws Exception {
        switch (this.mode) {
            case enable: {
                this.databaseFreezeService.requestFreeze(FreezeRequest.InitiatorType.USER_INITIATED, "console");
                break;
            }
            case release: {
                this.databaseFreezeService.releaseUserInitiatedIfPresent();
            }
        }
        return null;
    }

    @VisibleForTesting
    static enum Mode {
        enable,
        release;

    }
}

