/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.httpclient;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import org.apache.http.conn.HttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.goodies.common.Time;

class ConnectionEvictionThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(ConnectionEvictionThread.class);
    private final HttpClientConnectionManager connectionManager;
    private final long idleTimeMillis;
    private final long evictingDelayMillis;

    @VisibleForTesting
    ConnectionEvictionThread(HttpClientConnectionManager connectionManager, long idleTimeMillis, long evictingDelayMillis) {
        super("nexus-httpclient-eviction-thread");
        Preconditions.checkArgument((idleTimeMillis > -1L ? 1 : 0) != 0, (Object)"Keep alive period in milliseconds cannot be negative");
        Preconditions.checkArgument((evictingDelayMillis > 0L ? 1 : 0) != 0, (Object)"Evicting delay period in milliseconds must be greater than 0");
        this.connectionManager = (HttpClientConnectionManager)Preconditions.checkNotNull((Object)connectionManager);
        this.idleTimeMillis = idleTimeMillis;
        this.evictingDelayMillis = evictingDelayMillis;
        this.setDaemon(true);
        this.setPriority(1);
    }

    ConnectionEvictionThread(HttpClientConnectionManager connectionManager, Time idleTime, Time evictingDelayTime) {
        this(connectionManager, idleTime.toMillis(), evictingDelayTime.toMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        ConnectionEvictionThread.log.debug("Starting '{}' (delay {} millis)", (Object)this.getName(), (Object)this.evictingDelayMillis);
        try {
            while (true) lbl-1000:
            // 2 sources

            {
                var1_1 = this;
                synchronized (var1_1) {
                    this.wait(this.evictingDelayMillis);
                    try {
                        this.connectionManager.closeExpiredConnections();
                    }
                    catch (Exception e) {
                        ConnectionEvictionThread.log.warn("Failed to close expired connections", (Throwable)e);
                    }
                    try {
                        this.connectionManager.closeIdleConnections(this.idleTimeMillis, TimeUnit.MILLISECONDS);
                    }
                    catch (Exception e) {
                        ConnectionEvictionThread.log.warn("Failed to close idle connections", (Throwable)e);
                    }
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException v1) {
            ConnectionEvictionThread.log.debug("Stopped '{}'", (Object)this.getName());
            return;
        }
        {
            ** while (true)
        }
    }
}

