/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.httpclient;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Arrays;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.audit.AuditData;
import org.sonatype.nexus.audit.AuditorSupport;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.httpclient.config.AuthenticationConfiguration;
import org.sonatype.nexus.httpclient.config.ConnectionConfiguration;
import org.sonatype.nexus.httpclient.config.HttpClientConfiguration;
import org.sonatype.nexus.httpclient.config.HttpClientConfigurationChangedEvent;
import org.sonatype.nexus.httpclient.config.NtlmAuthenticationConfiguration;
import org.sonatype.nexus.httpclient.config.ProxyConfiguration;
import org.sonatype.nexus.httpclient.config.ProxyServerConfiguration;
import org.sonatype.nexus.httpclient.config.UsernameAuthenticationConfiguration;

@Named
@Singleton
public class HttpClientAuditor
extends AuditorSupport
implements EventAware {
    public static final String DOMAIN = "httpclient";

    @Subscribe
    @AllowConcurrentEvents
    public void on(HttpClientConfigurationChangedEvent event) {
        if (this.isRecording()) {
            ProxyConfiguration proxy;
            HttpClientConfiguration configuration = event.getConfiguration();
            AuditData data = new AuditData();
            data.setDomain(DOMAIN);
            data.setType("changed");
            data.setContext("system");
            Map attributes = data.getAttributes();
            ConnectionConfiguration connection = configuration.getConnection();
            if (connection != null) {
                attributes.put("connection.timeout", HttpClientAuditor.string((Object)connection.getTimeout()));
                attributes.put("connection.maximumRetries", HttpClientAuditor.string((Object)connection.getMaximumRetries()));
                attributes.put("connection.userAgentSuffix", HttpClientAuditor.string((Object)connection.getUserAgentSuffix()));
                attributes.put("connection.useTrustStore", HttpClientAuditor.string((Object)connection.getUseTrustStore()));
            }
            if ((proxy = configuration.getProxy()) != null) {
                HttpClientAuditor.proxy(attributes, "proxy.http", proxy.getHttp());
                HttpClientAuditor.proxy(attributes, "proxy.https", proxy.getHttps());
                if (proxy.getNonProxyHosts() != null) {
                    attributes.put("proxy.nonProxyHosts", HttpClientAuditor.string(Arrays.asList(proxy.getNonProxyHosts())));
                }
            }
            this.record(data);
        }
    }

    private static String key(String prefix, String suffix) {
        return String.valueOf(prefix) + "." + suffix;
    }

    private static void proxy(Map<String, String> attributes, String prefix, ProxyServerConfiguration server) {
        if (server == null) {
            return;
        }
        attributes.put(HttpClientAuditor.key(prefix, "enabled"), HttpClientAuditor.string((Object)server.isEnabled()));
        attributes.put(HttpClientAuditor.key(prefix, "host"), server.getHost());
        attributes.put(HttpClientAuditor.key(prefix, "port"), HttpClientAuditor.string((Object)server.getPort()));
        AuthenticationConfiguration auth = server.getAuthentication();
        if (auth != null) {
            attributes.put(HttpClientAuditor.key(prefix, "authentication.type"), auth.getType());
            if (auth instanceof UsernameAuthenticationConfiguration) {
                UsernameAuthenticationConfiguration username = (UsernameAuthenticationConfiguration)auth;
                attributes.put(HttpClientAuditor.key(prefix, "authentication.username"), username.getUsername());
            } else if (auth instanceof NtlmAuthenticationConfiguration) {
                NtlmAuthenticationConfiguration nrlm = (NtlmAuthenticationConfiguration)auth;
                attributes.put(HttpClientAuditor.key(prefix, "authentication.username"), nrlm.getUsername());
                attributes.put(HttpClientAuditor.key(prefix, "authentication.host"), nrlm.getHost());
                attributes.put(HttpClientAuditor.key(prefix, "authentication.domain"), nrlm.getDomain());
            }
        }
    }
}

