/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.httpclient;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.Time;
import org.sonatype.nexus.httpclient.config.AuthenticationConfiguration;
import org.sonatype.nexus.internal.httpclient.AuthenticationConfigurationDeserializer;
import org.sonatype.nexus.internal.httpclient.AuthenticationConfigurationSerializer;
import org.sonatype.nexus.internal.httpclient.SecondsDeserializer;
import org.sonatype.nexus.internal.httpclient.SecondsSerializer;
import org.sonatype.nexus.repository.config.ConfigurationObjectMapperCustomizer;
import org.sonatype.nexus.security.PasswordHelper;

@Named
@Singleton
public class HttpClientConfigurationObjectMapperCustomizer
implements ConfigurationObjectMapperCustomizer {
    private final PasswordHelper passwordHelper;

    @Inject
    public HttpClientConfigurationObjectMapperCustomizer(PasswordHelper passwordHelper) {
        this.passwordHelper = (PasswordHelper)Preconditions.checkNotNull((Object)passwordHelper);
    }

    public void customize(ObjectMapper objectMapper) {
        objectMapper.registerModule((Module)new SimpleModule().addSerializer(Time.class, (JsonSerializer)new SecondsSerializer()).addDeserializer(Time.class, (JsonDeserializer)new SecondsDeserializer()).addSerializer(AuthenticationConfiguration.class, (JsonSerializer)new AuthenticationConfigurationSerializer(this.passwordHelper)).addDeserializer(AuthenticationConfiguration.class, (JsonDeserializer)new AuthenticationConfigurationDeserializer(this.passwordHelper)));
    }
}

