/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.httpclient;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.List;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.protocol.HttpContext;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.httpclient.SSLContextSelector;

public class NexusSSLConnectionSocketFactory
implements LayeredConnectionSocketFactory {
    private static final Splitter propertiesSplitter = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private final SSLConnectionSocketFactory defaultSocketFactory = SSLConnectionSocketFactory.getSystemSocketFactory();
    @Nullable
    private final List<SSLContextSelector> sslContextSelectors;
    private final String[] supportedProtocols;
    private final String[] supportedCipherSuites;

    public NexusSSLConnectionSocketFactory(@Nullable List<SSLContextSelector> sslContextSelectors) {
        this.sslContextSelectors = sslContextSelectors;
        this.supportedProtocols = NexusSSLConnectionSocketFactory.split(System.getProperty("https.protocols"));
        this.supportedCipherSuites = NexusSSLConnectionSocketFactory.split(System.getProperty("https.cipherSuites"));
    }

    private SSLConnectionSocketFactory select(HttpContext context) {
        if (this.sslContextSelectors != null) {
            for (SSLContextSelector selector : this.sslContextSelectors) {
                SSLContext sslContext = selector.select(context);
                if (sslContext == null) continue;
                return new SSLConnectionSocketFactory(sslContext, this.supportedProtocols, this.supportedCipherSuites, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
            }
        }
        return this.defaultSocketFactory;
    }

    public Socket createSocket(HttpContext context) throws IOException {
        return this.select(context).createSocket(context);
    }

    public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
        return this.select(context).connectSocket(connectTimeout, socket, host, remoteAddress, localAddress, context);
    }

    public Socket createLayeredSocket(Socket socket, String target, int port, HttpContext context) throws IOException {
        return this.select(context).createLayeredSocket(socket, target, port, context);
    }

    private static String[] split(String s) {
        if (Strings2.isBlank((String)s)) {
            return null;
        }
        return (String[])Iterables.toArray((Iterable)propertiesSplitter.split((CharSequence)s), String.class);
    }
}

